/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.model.massinjection;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import hec.map.MapIdentifier;
import hec.map.MapObjectInterface;
import hec.map.WorldRect;
import hec.map.crs.CoordinateReferenceSystem;
import hec.rss.wq.model.JsonManager;
import hec.wqenginecore.jackson.TypeResolver;
import hec.wqengineimpl.massInjection.WQMassInjectionSite;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@JsonPropertyOrder(value={"name", "description"})
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY)
@JsonTypeIdResolver(value=TypeResolver.class)
public class MassInjectionManager
extends JsonManager
implements MapObjectInterface {
    public static final int CURRENT_VERSION = 1;
    public static final String EXT = ".massInject";
    @JsonIgnore
    private final MapIdentifier _mapIdentifier;
    @JsonProperty(value="massInjectionSiteList")
    @JsonDeserialize(contentAs=WQMassInjectionSite.class)
    @JsonSerialize(contentAs=WQMassInjectionSite.class)
    private List<WQMassInjectionSite> _sites = new ArrayList<WQMassInjectionSite>();
    @JsonProperty
    private int _nextId = 0;
    @JsonProperty
    private int _version = -1;

    public MassInjectionManager() {
        this._mapIdentifier = new MapIdentifier();
        this._mapIdentifier.setMapShown(true);
        this._mapIdentifier.setIsManager(true);
    }

    public WQMassInjectionSite addMassInjectionSite(String string, String string2) {
        if (string == null || string.isEmpty()) {
            return null;
        }
        if (this.findMassInjectionSite(string) != null) {
            return null;
        }
        string = new WQMassInjectionSite(string, string2);
        string.setId(this.getNextId());
        this._sites.add((WQMassInjectionSite)string);
        this.setModified(true);
        return string;
    }

    public boolean deleteMassInjectionSite(WQMassInjectionSite wQMassInjectionSite) {
        if (this._sites.remove(wQMassInjectionSite)) {
            this.setModified(true);
            return true;
        }
        return false;
    }

    private int getNextId() {
        return this._nextId++;
    }

    public List<WQMassInjectionSite> getMassInjectionSites() {
        return this._sites;
    }

    public WQMassInjectionSite findMassInjectionSite(String optional) {
        optional = this._sites.stream().filter(arg_0 -> MassInjectionManager.a((String)((Object)optional), arg_0)).findFirst();
        if (optional.isPresent()) {
            return (WQMassInjectionSite)optional.get();
        }
        return null;
    }

    @Override
    protected void updateToCurrentVersion() {
        this._version = 1;
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return null;
    }

    @JsonIgnore
    public WorldRect getExtent() {
        WorldRect worldRect = new WorldRect();
        return worldRect;
    }

    @JsonIgnore
    public MapIdentifier getMapIdentifier() {
        return this._mapIdentifier;
    }

    public void load() throws IOException {
    }

    public void setExtent(WorldRect worldRect) {
    }

    public void setMapIdentifier(MapIdentifier mapIdentifier) {
    }

    public void unload() {
    }

    public List<String> getMassInjectionSiteNames() {
        return this._sites.stream().map(wQMassInjectionSite -> wQMassInjectionSite.getName()).collect(Collectors.toList());
    }

    private static /* synthetic */ boolean a(String string, WQMassInjectionSite wQMassInjectionSite) {
        return wQMassInjectionSite.getName().equals(string);
    }
}

