/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.model.massinjection;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import hec.clientapp.model.ManagerProxy;
import hec.clientapp.model.StreamAlignment;
import hec.clientapp.model.TSDataSet;
import hec.clientapp.model.TSRecordProxy;
import hec.clientapp.rmi.csinterface.HecRmiWorkspace;
import hec.clientapp.rmi.csinterface.RmiWorkspace;
import hec.heclib.dss.DSSPathname;
import hec.io.Identifier;
import hec.rss.wq.client.massinjection.FindSitesForGeometry;
import hec.rss.wq.model.ConstituentManager;
import hec.rss.wq.model.ConstituentSetManager;
import hec.rss.wq.model.GeometryManager;
import hec.rss.wq.model.JsonManager;
import hec.rss.wq.model.WQTSDataProvider;
import hec.rss.wq.model.WqGeometry;
import hec.rss.wq.model.massinjection.MassInjectionManager;
import hec.wqenginecore.ConstituentSet;
import hec.wqenginecore.dataSource.timeSeries.DssData;
import hec.wqenginecore.geometry.SubDomainRef;
import hec.wqenginecore.massinjection.MassInjectionSet;
import hec.wqenginecore.massinjection.MassInjectionSite;
import hec.wqenginecore.massinjection.MassInjectionSiteData;
import hec.wqengineimpl.geometry.WQGeoSubDomain;
import hec.wqengineimpl.geometry.WQGeoSubDomainJunction;
import hec.wqengineimpl.massInjection.WQMassInjectionSet;
import hec.wqengineimpl.massInjection.WQMassInjectionSite;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;

public class MassInjectionSetManager
extends JsonManager
implements ConstituentManager,
GeometryManager,
WQTSDataProvider {
    public static final int CURRENT_VERSION = 1;
    public static final Logger logger = Logger.getLogger(MassInjectionSetManager.class.getName());
    public static final String EXT = ".massInjection";
    public static final String SUBDIR = "wq/";
    @JsonProperty
    private int _version = -1;
    @JsonProperty
    @JsonDeserialize(as=WQMassInjectionSet.class)
    @JsonSerialize(as=WQMassInjectionSet.class)
    private MassInjectionSet _set;
    @JsonProperty
    private int _geometryId;
    @JsonProperty
    private int _constituentId;

    public void setSet(MassInjectionSet massInjectionSet) {
        this._set = massInjectionSet;
        if (this._set != null) {
            MassInjectionSetManager massInjectionSetManager = this;
            massInjectionSetManager.setName(massInjectionSetManager._set.getName());
            MassInjectionSetManager massInjectionSetManager2 = this;
            massInjectionSetManager2.setDescription(massInjectionSetManager2._set.getDescription());
            return;
        }
        this.setName("");
        this.setDescription("");
    }

    public MassInjectionSet getSet() {
        return this._set;
    }

    public MassInjectionManager getMassInjectionManager() {
        MassInjectionManager massInjectionManager = null;
        try {
            RmiWorkspace rmiWorkspace = (RmiWorkspace)this.getWorkspace().getRemote();
            rmiWorkspace = (HecRmiWorkspace)rmiWorkspace.getChildWorkspace("");
            Vector vector = rmiWorkspace.getBaseWorkspace().getChildWorkspace("rss").getManagers().getManagerIDList(MassInjectionManager.class.getName());
            if (!vector.isEmpty()) {
                massInjectionManager = (MassInjectionManager)rmiWorkspace.getBaseWorkspace().getChildWorkspace("rss").getManager(MassInjectionManager.class.getName(), (Identifier)vector.get(0));
            }
        }
        catch (RemoteException remoteException) {
            logger.severe("Exception when retrieving the workspace information for the MassInjectionManager" + remoteException.getMessage());
        }
        return massInjectionManager;
    }

    public List<WQMassInjectionSite> getAllMassInjectionSites() {
        List<WQMassInjectionSite> list = new ArrayList<WQMassInjectionSite>();
        MassInjectionManager massInjectionManager = this.getMassInjectionManager();
        if (massInjectionManager != null) {
            list = massInjectionManager.getMassInjectionSites();
        }
        return list;
    }

    @Override
    @JsonProperty
    public String getName() {
        String string = "";
        if (this._set != null) {
            string = this._set.getName();
        }
        return string;
    }

    @Override
    @JsonProperty
    public String getDescription() {
        String string = "";
        if (this._set != null) {
            string = this._set.getDescription();
        }
        return string;
    }

    public void setDescription(String string) {
        super.setDescription(string);
        if (this._set instanceof WQMassInjectionSet) {
            string = (WQMassInjectionSet)this._set;
            string.setDescription(super.getDescription());
        }
    }

    public void setName(String string) {
        super.setName(string);
        if (this._set instanceof WQMassInjectionSet) {
            string = (WQMassInjectionSet)this._set;
            string.setName(super.getName());
        }
    }

    @Override
    public void setGeometryId(int n) {
        this._geometryId = n;
    }

    @Override
    public int getGeometryId() {
        return this._geometryId;
    }

    @Override
    @JsonIgnore
    public WqGeometry getGeometry() {
        ManagerProxy managerProxy = this._proxyList.getManagerProxy(WqGeometry.class.getName(), this._geometryId);
        if (managerProxy != null) {
            return (WqGeometry)managerProxy.loadManager(null, null);
        }
        return null;
    }

    @Override
    public void setConstituentSetId(int n) {
        this._constituentId = n;
    }

    @Override
    public int getConstituentSetId() {
        return this._constituentId;
    }

    @Override
    @JsonIgnore
    public ConstituentSetManager getConstituentSet() {
        ManagerProxy managerProxy = this._proxyList.getManagerProxy(ConstituentSetManager.class.getName(), this._constituentId);
        if (managerProxy != null) {
            return (ConstituentSetManager)managerProxy.loadManager(null, null);
        }
        return null;
    }

    @Override
    protected void updateToCurrentVersion() {
        this._version = 1;
    }

    public boolean addMassInjectionSite(WQMassInjectionSite wQMassInjectionSite) {
        Object object = this.findElementForSite(wQMassInjectionSite);
        if (object == null) {
            return false;
        }
        if (this.getSet().addMassInjectionSite((MassInjectionSite)wQMassInjectionSite)) {
            wQMassInjectionSite = ((WQMassInjectionSet)this.getSet()).getMassInjectionSiteData((MassInjectionSite)wQMassInjectionSite);
            if (object instanceof WQGeoSubDomainJunction) {
                wQMassInjectionSite.setSubDomainJunctionRef(((WQGeoSubDomainJunction)object).getRef());
            } else if (object instanceof WQGeoSubDomain) {
                wQMassInjectionSite.setSubDomainRef((SubDomainRef)((WQGeoSubDomain)object).getRef());
            }
            return true;
        }
        return false;
    }

    private Object findElementForSite(WQMassInjectionSite wQMassInjectionSite) {
        if (wQMassInjectionSite == null) {
            return null;
        }
        FindSitesForGeometry findSitesForGeometry = new FindSitesForGeometry();
        ArrayList<WQMassInjectionSite> arrayList = new ArrayList<WQMassInjectionSite>();
        arrayList.add(wQMassInjectionSite);
        WqGeometry wqGeometry = this.getGeometry();
        wqGeometry = wqGeometry.getNetwork().getAlignment();
        findSitesForGeometry.a(this.getGeometry(), arrayList, (StreamAlignment)wqGeometry);
        return findSitesForGeometry.a((MassInjectionSite)wQMassInjectionSite);
    }

    @Override
    public List<TSRecordProxy> getActiveTSRecordProxies(TSDataSet tSDataSet) {
        ArrayList<TSRecordProxy> arrayList = new ArrayList<TSRecordProxy>();
        if (this.getConstituentSet() == null || this.getConstituentSet().getSet() == null) {
            return arrayList;
        }
        ConstituentSet constituentSet = this.getConstituentSet().getSet();
        Object object = new ArrayList<WQMassInjectionSite>();
        object.addAll(this.getAllMassInjectionSites());
        List list = this._set.getMassInjectionSiteList(object);
        if (list == null || list.isEmpty()) {
            return arrayList;
        }
        for (int i = 0; i < list.size(); ++i) {
            Object object2;
            MassInjectionSite massInjectionSite = (MassInjectionSite)list.get(i);
            MassInjectionSiteData massInjectionSiteData = this._set.getMassInjectionSiteData(massInjectionSite);
            object = massInjectionSiteData.getConstituentIds();
            DssData dssData = new HashSet();
            object = object.iterator();
            while (object.hasNext()) {
                object2 = (Integer)object.next();
                if (!constituentSet.hasConstituent((Integer)object2)) continue;
                dssData.add(object2);
            }
            int n = dssData.size();
            object = new int[n];
            int n2 = 0;
            for (Integer n3 : dssData) {
                object[n2] = n3;
                ++n2;
            }
            object2 = dssData.iterator();
            while (object2.hasNext()) {
                int n4 = (Integer)object2.next();
                object = massInjectionSiteData.getMassInjectionConstituentData(n4);
                Object object3 = object.getSelectedDataSource();
                if (object3 == null || !"DSSData".equals(object3.getType())) continue;
                dssData = (DssData)object3;
                object = new TSRecordProxy();
                object.setInput(true);
                object.setDSSPathname(dssData.getDssPath());
                object.setDSSFilename(dssData.getDssFilePath());
                object.setIndex(massInjectionSite.getId());
                object.setName(massInjectionSite.getName() + ":" + object3.getName());
                object.setDescription("MassInjectSite:" + massInjectionSite.getName() + ", MassInjectSet:" + ((JsonManager)this).getName());
                object3 = new DSSPathname(dssData.getDssPath());
                if (constituentSet != null) {
                    dssData = constituentSet.getConstituent(Integer.valueOf(n4));
                    if (dssData != null) {
                        object3 = dssData.getName();
                        object.setParamName((String)object3);
                        object.setName(massInjectionSite.getName() + "-" + dssData.getName());
                        object3 = dssData.getUnit();
                        object.setUnits((String)object3);
                        object.setVariableId(2000 + dssData.getId());
                    } else {
                        object.setParamName(object3.getCPart());
                    }
                } else {
                    object.setParamName(object3.getCPart());
                }
                object.setTSDataSet(tSDataSet);
                arrayList.add((TSRecordProxy)object);
            }
        }
        return arrayList;
    }

    @Override
    protected boolean alwaysRelativeToBase() {
        return true;
    }
}

