/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.model.wqParameters;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import hec.clientapp.model.ManagerProxy;
import hec.clientapp.model.TSDataSet;
import hec.clientapp.model.TSRecordProxy;
import hec.heclib.dss.DSSPathname;
import hec.rss.wq.model.GeometryManager;
import hec.rss.wq.model.JsonManager;
import hec.rss.wq.model.WQTSDataProvider;
import hec.rss.wq.model.WqGeometry;
import hec.wqenginecore.dataSource.timeSeries.DssData;
import hec.wqenginecore.parameter.ParameterSet;
import hec.wqengineimpl.parameter.WQParameterSet;
import hec.wqengineimpl.parameter.WQParameterSettingDSSValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import rma.util.RMAIO;

public class ParameterSetManager
extends JsonManager
implements GeometryManager,
WQTSDataProvider {
    public static final int CURRENT_VERSION = 1;
    public static final Logger LOGGER = Logger.getLogger(ParameterSetManager.class.getName());
    public static final String EXT = ".wqParameters";
    public static final String SUBDIR = "wq/";
    public static final String PARAMETER_ID_DELIMETER = "-";
    public static final String PARAMETER_ID_PREFIX = "WQ Parameter Id ";
    public static final String BASE_REGION_NAME = "Base Region";
    @JsonProperty
    private int _version = -1;
    @JsonProperty
    private Map<Integer, WQParameterSet> _setMap = new HashMap<Integer, WQParameterSet>();
    @JsonProperty
    private int _geometryId;

    public ParameterSet getSet(int n) {
        WQParameterSet wQParameterSet = this._setMap.get(n);
        if (wQParameterSet == null) {
            wQParameterSet = new WQParameterSet();
            this._setMap.put(n, wQParameterSet);
        }
        return wQParameterSet;
    }

    @JsonIgnore
    public Set<Integer> getConstituentSetIds() {
        return Collections.unmodifiableSet(this._setMap.keySet());
    }

    public void setSet(int n, WQParameterSet wQParameterSet) {
        if (wQParameterSet != null) {
            this._setMap.put(n, wQParameterSet);
        }
    }

    @Override
    public void setGeometryId(int n) {
        this._geometryId = n;
    }

    @Override
    public int getGeometryId() {
        return this._geometryId;
    }

    @Override
    @JsonIgnore
    public WqGeometry getGeometry() {
        ManagerProxy managerProxy = this._proxyList.getManagerProxy(WqGeometry.class.getName(), this._geometryId);
        if (managerProxy != null) {
            return (WqGeometry)managerProxy.loadManager(null, null);
        }
        return null;
    }

    @Override
    protected void updateToCurrentVersion() {
        this._version = 1;
    }

    public void clearSet() {
        this._setMap.clear();
    }

    @Override
    public List<TSRecordProxy> getActiveTSRecordProxies(TSDataSet tSDataSet) {
        ArrayList<TSRecordProxy> arrayList = new ArrayList<TSRecordProxy>();
        for (Map.Entry<Integer, WQParameterSet> entry : this._setMap.entrySet()) {
            Integer n = entry.getKey();
            WQParameterSet wQParameterSet = entry.getValue();
            wQParameterSet.getParameterSettings().forEach(object -> {
                if (object.getParameterValue() instanceof WQParameterSettingDSSValue) {
                    WQParameterSettingDSSValue wQParameterSettingDSSValue = (WQParameterSettingDSSValue)object.getParameterValue();
                    object = "Base Region-WQ Parameter Id " + object.getParameterId();
                    arrayList.addAll(this.buildActiveTsRecordProxies((String)object, tSDataSet, n, Collections.singletonList(wQParameterSettingDSSValue)));
                }
            });
            wQParameterSet.getRegionParameterSettings().forEach(regionParameterSettings -> regionParameterSettings.getParameterSettings().forEach(wQParameterSetting -> {
                if (wQParameterSetting.getParameterValue() instanceof WQParameterSettingDSSValue) {
                    WQParameterSettingDSSValue wQParameterSettingDSSValue = (WQParameterSettingDSSValue)wQParameterSetting.getParameterValue();
                    regionParameterSettings = regionParameterSettings.getRegionRef().getName() + "-WQ Parameter Id " + wQParameterSetting.getParameterId();
                    arrayList.addAll(this.buildActiveTsRecordProxies((String)regionParameterSettings, tSDataSet, n, Collections.singletonList(wQParameterSettingDSSValue)));
                }
            }));
        }
        return arrayList;
    }

    private Collection<? extends TSRecordProxy> buildActiveTsRecordProxies(String string, TSDataSet tSDataSet, Integer n, List<WQParameterSettingDSSValue> object) {
        ArrayList<TSRecordProxy> arrayList = new ArrayList<TSRecordProxy>();
        object = object.iterator();
        while (object.hasNext()) {
            WQParameterSettingDSSValue wQParameterSettingDSSValue = (WQParameterSettingDSSValue)object.next();
            if ((wQParameterSettingDSSValue = (DssData)wQParameterSettingDSSValue.getValue()) == null) continue;
            TSRecordProxy tSRecordProxy = new TSRecordProxy();
            tSRecordProxy.setInput(true);
            tSRecordProxy.setDSSPathname(wQParameterSettingDSSValue.getDssPath());
            tSRecordProxy.setDSSFilename(wQParameterSettingDSSValue.getDssFilePath());
            new DSSPathname(wQParameterSettingDSSValue.getDssPath());
            tSRecordProxy.setUnits(wQParameterSettingDSSValue.getUnits());
            tSRecordProxy.setName(string);
            tSRecordProxy.setTSDataSet(tSDataSet);
            TSRecordProxy tSRecordProxy2 = tSRecordProxy;
            tSRecordProxy2.setParamName(PARAMETER_ID_PREFIX + String.valueOf(ParameterSetManager.a(tSRecordProxy2).orElse(-1)));
            tSRecordProxy.setVariableId(2000 + n);
            arrayList.add(tSRecordProxy);
        }
        return arrayList;
    }

    public static Optional<Integer> a(TSRecordProxy object) {
        Optional<Integer> optional = Optional.empty();
        int n = ((String)(object = object.getName())).lastIndexOf(PARAMETER_ID_DELIMETER);
        if (n > 0) {
            object = ((String)object).substring(n + 16 + 1);
            optional = Optional.of(RMAIO.parseInt((String)object));
        }
        return optional;
    }
}

