/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.ui;

import hec.clientapp.client.ClientApp;
import hec.io.Identifier;
import hec.lang.UserId;
import hec.rss.model.RssSystem;
import hec.rss.wq.util.WqI18n;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.File;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaValidComponent;
import rma.swing.list.RmaListModel;
import rma.util.RMAIO;

public class GeometryAccessoryPanel
extends JPanel
implements RmaValidComponent {
    private RmaJComboBox<Identifier> _networkCombo;
    private RmaJComboBox<Identifier> _rasGeoCombo;
    private JButton _importBtn;

    public GeometryAccessoryPanel() {
        super(new GridBagLayout());
        this.buildControls();
        this.addListeners();
        this.fillForm();
    }

    private void buildControls() {
        JLabel jLabel = WqI18n.a("WqModule.Label.Network").createJLabel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.add((Component)jLabel, gridBagConstraints);
        this._networkCombo = new RmaJComboBox();
        jLabel.setLabelFor((Component)this._networkCombo);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        GeometryAccessoryPanel geometryAccessoryPanel = this;
        geometryAccessoryPanel.add((Component)geometryAccessoryPanel._networkCombo, gridBagConstraints);
        jLabel = WqI18n.a("WqModule.Label.RasGeometry").createJLabel();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.add((Component)jLabel, gridBagConstraints);
        this._rasGeoCombo = new RmaJComboBox();
        jLabel.setLabelFor((Component)this._rasGeoCombo);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        GeometryAccessoryPanel geometryAccessoryPanel2 = this;
        geometryAccessoryPanel2.add((Component)geometryAccessoryPanel2._rasGeoCombo, gridBagConstraints);
        this._importBtn = WqI18n.a("GeoAccPanel.Button.RasImport").createJButton();
        this._importBtn.setMargin(RmaInsets.INSETS0000);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        GeometryAccessoryPanel geometryAccessoryPanel3 = this;
        geometryAccessoryPanel3.add((Component)geometryAccessoryPanel3._importBtn, gridBagConstraints);
    }

    private void addListeners() {
        this._importBtn.addActionListener(actionEvent -> this.selectGeoFileAction());
    }

    private void fillForm() {
        Object object = ClientApp.Workspace();
        object = object.getManagerIDList("rss", RssSystem.class.getName());
        object = new RmaListModel(true, (Collection)object);
        this._networkCombo.setModel((ComboBoxModel)object);
        this.fillRasGeometries();
    }

    private void fillRasGeometries() {
        Object object;
        Object object2 = RMAIO.concatPath((String)ClientApp.Workspace().getWorkspacePath(), (String)"ras");
        Object object3 = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
        try {
            object2 = object3.getRemoteFileIDList(UserId.getUserId(), (String)object2, "*.*");
        }
        catch (RemoteException remoteException) {
            System.out.println("fillRasGeometries:failed to get list of RAS files " + String.valueOf(remoteException));
            return;
        }
        object3 = new ArrayList();
        if (object2 != null) {
            for (int i = 0; i < ((Vector)object2).size(); ++i) {
                object = RMAIO.getFileExtension((String)((Identifier)((Vector)object2).get(i)).getPath());
                if (object == null || ((String)object).isEmpty() || !((String)object).startsWith(".g")) continue;
                object3.add((Identifier)((Vector)object2).get(i));
            }
        }
        object = new RmaListModel(true, (Collection)object3);
        this._rasGeoCombo.setModel((ComboBoxModel)object);
    }

    private void selectGeoFileAction() {
        Object object = RMAIO.concatPath((String)ClientApp.Workspace().getWorkspacePath(), (String)"ras");
        object = new JFileChooser((String)object);
        String string = WqI18n.a("GeoAccPanel.Title.RasChooser").getText();
        ((JFileChooser)object).setDialogTitle(string);
        int n = ((JFileChooser)object).showOpenDialog(this);
        if (n != 0) {
            return;
        }
        if ((object = ((JFileChooser)object).getSelectedFile()) == null) {
            return;
        }
        String string2 = RMAIO.getFileExtension((String)(object = ((File)object).getPath()));
        if (string2.startsWith(".g")) {
            object = new Identifier((String)object);
            this._rasGeoCombo.addItem(object);
            this._rasGeoCombo.setSelectedItem(object);
            return;
        }
        object = WqI18n.a("GeoAccPanel.Msg.SelectRasGeoFile").getText();
        string2 = WqI18n.a("GeoAccPanel.Msg.SelectRasGeoFile.Title").getText();
        JOptionPane.showMessageDialog(this, object, string2, 1);
    }

    public Identifier getSelectedNetworkId() {
        return (Identifier)this._networkCombo.getSelectedItem();
    }

    public Identifier getSelectedRasGeometryId() {
        return (Identifier)this._rasGeoCombo.getSelectedItem();
    }

    public boolean isValid(boolean bl) {
        if (this._networkCombo.getSelectedItem() == null) {
            String string = WqI18n.a("GeoAccPanel.Msg.NoNetwork").getText();
            String string2 = WqI18n.a("GeoAccPanel.Msg.NoNetwork.Title").getText();
            JOptionPane.showMessageDialog(this, string, string2, 0);
            return false;
        }
        if (this._rasGeoCombo.getSelectedItem() == null) {
            String string = WqI18n.a("GeoAccPanel.Msg.NoRasGeometry").getText();
            String string3 = WqI18n.a("GeoAccPanel.Msg.NoRasGeometry.Title").getText();
            JOptionPane.showMessageDialog(this, string, string3, 0);
            return false;
        }
        return true;
    }
}

