/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.ui;

import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ClientWorkspace;
import hec.rss.RssRmiWorkspace;
import hec.rss.client.RSS;
import hec.rss.client.RssFrame;
import hec.rss.server.RssAdvancedOptions;
import hec.rss.wq.util.WqI18n;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import rma.swing.DefaultJPanel;
import rma.swing.RmaJCheckBox;

public class WaterQualityOptionPanel
extends DefaultJPanel {
    private RmaJCheckBox _hasWaterQualityModuleCheckbox;
    private RssAdvancedOptions _opts = null;

    public WaterQualityOptionPanel() {
        super((LayoutManager)new GridBagLayout());
        this.buildControls();
    }

    private void buildControls() {
        this._hasWaterQualityModuleCheckbox = new RmaJCheckBox(WqI18n.a("Watershed.NewWatershed.UseWQ.Checkbox.Label").getText());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.01;
        gridBagConstraints.weighty = 0.01;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(5, 10, 0, 5);
        WaterQualityOptionPanel waterQualityOptionPanel = this;
        waterQualityOptionPanel.add((Component)waterQualityOptionPanel._hasWaterQualityModuleCheckbox, gridBagConstraints);
    }

    private RssRmiWorkspace getRssRmiWorkspace() {
        ClientWorkspace clientWorkspace = ClientApp.Workspace();
        if (clientWorkspace == null) {
            return null;
        }
        return (RssRmiWorkspace)clientWorkspace.getChildWorkspace("rss");
    }

    public void fillPanel() {
        RssRmiWorkspace rssRmiWorkspace = this.getRssRmiWorkspace();
        if (rssRmiWorkspace == null) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
        try {
            this._opts = rssRmiWorkspace.getRssAdvancedOptions();
        }
        catch (RemoteException remoteException) {
            StringBuffer stringBuffer = new StringBuffer("An error occured while trying to get the ResSim Advanced Options from the server.\n");
            stringBuffer.append(remoteException.getMessage());
            JOptionPane.showMessageDialog((Component)((Object)this), stringBuffer.toString(), "Error!", 0);
            return;
        }
        this._hasWaterQualityModuleCheckbox.setSelected(this._opts.hasWaterQuality());
    }

    public boolean savePanel() {
        RssRmiWorkspace rssRmiWorkspace = this.getRssRmiWorkspace();
        if (this._opts == null) {
            if (rssRmiWorkspace == null) {
                return false;
            }
            try {
                this._opts = rssRmiWorkspace.getRssAdvancedOptions();
            }
            catch (RemoteException remoteException) {
                Logger.getLogger(WaterQualityOptionPanel.class.getName()).log(Level.SEVERE, "Error getting Rss Advanced Options", remoteException);
            }
            if (this._opts == null) {
                return false;
            }
        }
        boolean bl = this._hasWaterQualityModuleCheckbox.isSelected();
        this._opts.setHasWaterQuality(bl);
        RssFrame rssFrame = RSS.rssFrame();
        rssFrame.setHasWaterQualityMode(bl);
        try {
            if (rssRmiWorkspace != null) {
                rssRmiWorkspace.setRssAdvancedOptions(this._opts);
                if (this.isModified()) {
                    ClientApp.Workspace().setModified(true);
                }
            }
            this.setModified(false);
        }
        catch (RemoteException remoteException) {
            StringBuffer stringBuffer = new StringBuffer("An error occured while trying to save the ResSim Advanced Options to the server.\n");
            stringBuffer.append(remoteException.getMessage());
            JOptionPane.showMessageDialog((Component)((Object)this), stringBuffer.toString(), "Error!", 0);
        }
        return true;
    }
}

