/*
 * Decompiled with CFR 0.152.
 */
package ressim.hec.res.model;

import hec.client.RunObserver;
import hec.clientapp.model.Manager;
import hec.clientapp.model.TSDataSet;
import hec.clientapp.rmi.csinterface.RmiWorkspace;
import hec.io.AsciiSerializable;
import hec.io.Identifier;
import hec.model.RunTimeWindow;
import hec.model.TSRecord;
import hec.watershed.res.model.ResAlt;
import hec.watershed.res.model.ResNetwork;
import java.io.Serializable;
import java.lang.reflect.Field;
import rma.util.RMAIO;

public abstract class ResRun
extends Manager
implements AsciiSerializable,
Serializable,
Runnable {
    public static final int RTN_NOPROBLEM = 0;
    public static final int RTN_PROBLEM = 1;
    protected String _outputDSSFilePath;
    protected String _outputDSSFileName;
    protected String _altPath = "";
    protected String _outputFpart = "";
    protected RunTimeWindow _runTimeWindow = new RunTimeWindow();
    protected String _runId = null;
    protected int _logLevel = 10;
    protected int _inputPos = 0;
    protected int _modelPos = 3;
    protected transient RunObserver a = null;
    protected transient TSDataSet b = null;
    protected transient TSDataSet c = null;
    protected transient TSDataSet d = null;
    protected transient String e;
    protected transient int f = 2;
    protected transient ResAlt g;
    protected transient ResNetwork h;

    public ResRun() {
    }

    public ResRun(String string) {
        super(string);
    }

    public void init() {
    }

    protected abstract String getRunErrorMsg();

    protected abstract String getFailedToLoadAltMsg();

    protected abstract TSDataSet createForecastInputTSData(TSDataSet var1, String var2, String var3);

    public abstract String getAltClassName();

    protected abstract TSDataSet createOutputTSData(String var1);

    public void setDSSOutputFile(String string) {
        this._outputDSSFilePath = string;
        if (string != null) {
            try {
                this._outputDSSFileName = RMAIO.getRelativePath((String)((RmiWorkspace)this._Workspace.getRemote()).getWorkspacePath(), (String)string);
            }
            catch (Exception exception) {
                this._outputDSSFileName = string;
            }
            if (RMAIO.isFullPath((String)string)) {
                this._outputDSSFilePath = string;
                return;
            }
            try {
                this._outputDSSFilePath = ((RmiWorkspace)this._Workspace.getRemote()).getWorkspacePath() + "/" + this._outputDSSFileName;
                return;
            }
            catch (Exception exception) {
                this._outputDSSFilePath = string;
            }
        }
    }

    public String getAltPath() {
        ResRun resRun = this;
        String string = resRun.makeAbsolutePath(resRun._altPath);
        return string;
    }

    public RunTimeWindow getRunTimeWindow() {
        return this._runTimeWindow;
    }

    public String getTimeWindowString() {
        return this._runTimeWindow.getLookbackTimeString() + " " + this._runTimeWindow.getEndTimeString();
    }

    public void setComputeObserver(RunObserver runObserver) {
        this.a = runObserver;
    }

    public TSDataSet getInputTSData() {
        if (this.b != null) {
            return this.b;
        }
        if (this.g == null && this.getAlternative() == null) {
            ResRun resRun = this;
            resRun.printMessage("Failed to load ResPrm Alternative " + resRun._altPath);
            this.printMessage("Cannot load inputTSData");
            return null;
        }
        this.b = this.g.getInputTSDataSet();
        if (this._runId != null) {
            this.b = this.createForecastInputTSData(this.b, this.getDSSOutputFile(), this._runId);
        }
        return this.b;
    }

    public TSDataSet getObservedTSData() {
        if (this.c != null) {
            return this.c;
        }
        if (this.g == null && this.getAlternative() == null) {
            ResRun resRun = this;
            resRun.printMessage("Failed to load ResPrm Alternative " + resRun._altPath);
            this.printMessage("Cannot load Observed TSDataSet");
            return null;
        }
        this.c = this.g.getObservedTSDataSet();
        if (this._runId != null && this.c != null) {
            this.c = this.createForecastInputTSData(this.c, this.getDSSOutputFile(), this._runId);
        }
        return this.c;
    }

    public TSDataSet getOutputTSData() {
        if (this.d != null) {
            return this.d;
        }
        if (this.g == null && this.getAlternative() == null) {
            this.printMessage("Can't load outputTSData");
            return null;
        }
        this.h = this.g.getNetwork();
        if (this.h == null) {
            this.printMessage("Failed to load ResPrm Network.");
            return null;
        }
        this.d = this._runId == null ? this.createOutputTSData(this.g.getName()) : this.createOutputTSData(this._runId);
        return this.d;
    }

    public ResAlt getAlternative() {
        block4: {
            if (this.g != null) {
                return this.g;
            }
            ResRun resRun = this;
            Identifier identifier = new Identifier(resRun.makeAbsolutePath(resRun._altPath));
            try {
                this.g = (ResAlt)this._proxyList.loadManager(this.getAltClassName(), identifier);
            }
            catch (Exception exception) {
                ResRun resRun2 = this;
                resRun2.printErrorMessage(resRun2.getRunErrorMsg() + ".loadManagers - RemoteException");
                ResRun resRun3 = this;
                resRun3.printMessage(resRun3.getFailedToLoadAltMsg() + this._altPath);
                if (this._logLevel < 5) break block4;
                this.printMessage(exception.toString());
            }
        }
        if (this.g == null && this._logLevel > 4) {
            ResRun resRun = this;
            resRun.printWarningMessage("Failed to load Alternative " + resRun._altPath);
        }
        return this.g;
    }

    protected int loadManagers() {
        if (this._logLevel > 5) {
            ResRun resRun = this;
            resRun.printLogMessage("Loading Res Alternative: " + resRun._altPath);
        }
        if (this.getAlternative() == null) {
            this.printErrorMessage("Failed to load Res Alternative");
            ResRun resRun = this;
            resRun.printLogMessage("Failed to Load Res Alternative: " + resRun._altPath);
            return 1;
        }
        if (this._logLevel > 5) {
            ResRun resRun = this;
            resRun.printLogMessage("Loading Res Network: " + resRun.g.getNetworkPath());
        }
        this.h = this.g.getNetwork();
        if (this.h == null) {
            this.printErrorMessage("Failed to load Res Network");
            ResRun resRun = this;
            resRun.printLogMessage("Failed to Load Res Network: " + resRun.g.getNetworkPath());
            return 1;
        }
        if (this._logLevel > 5) {
            ResRun resRun = this;
            resRun.printLogMessage("Loading Input Time Series: " + resRun.g.getInputTSDataPath());
        }
        this.b = this.g.getInputTSDataSet();
        if (this._runId != null) {
            this.b = this.createForecastInputTSData(this.b, this.getDSSOutputFile(), this._runId);
        }
        this.c = this.g.getObservedTSDataSet();
        if (this._runId != null && this.c != null) {
            this.c = this.createForecastInputTSData(this.c, this.getDSSOutputFile(), this._runId);
        }
        if (this.b == null) {
            this.printErrorMessage("Failed to load input TSDataSet");
            ResRun resRun = this;
            resRun.printLogMessage("Failed to load input TSDataSet " + resRun.g.getInputTSDataPath());
            return 1;
        }
        return 0;
    }

    private void printTSErrorMsg(TSRecord tSRecord) {
        String string = this.h.getNameForKeyString(tSRecord.getName());
        this.printErrorMessage("Res Time Series location: " + string);
        this.printErrorMessage("dssfile " + tSRecord.getDSSFilename());
        this.printErrorMessage("dsspath " + tSRecord.getDSSPathname());
        this.printErrorMessage("param " + tSRecord.getParamName());
        this.printErrorMessage("timewindow " + tSRecord.getTimeWindowString());
        this.printMessage(" ");
    }

    public void unloading() {
        this.unloadManagers();
    }

    void unloadManagers() {
        if (this.g != null) {
            this._proxyList.unloadManager(this.g.getIdentifier());
            this.g = null;
        }
    }

    public String getOutputFPart() {
        if (this._runId == null) {
            return this.getName();
        }
        return this._runId.substring(0, this._modelPos);
    }

    public String getDSSOutputFile() {
        if (this._outputDSSFilePath != null) {
            return this._outputDSSFilePath;
        }
        if (RMAIO.isFullPath((String)this._outputDSSFileName)) {
            return this._outputDSSFileName;
        }
        try {
            this._outputDSSFilePath = ((RmiWorkspace)this._Workspace.getRemote()).getWorkspacePath() + "/" + this._outputDSSFileName;
        }
        catch (Exception exception) {
            return this._outputDSSFileName;
        }
        return this._outputDSSFilePath;
    }

    public void setAltPath(String string) {
        string = this.getRelativePath(string);
        if (this._altPath != null && !this._altPath.equals(string)) {
            this.g = null;
            this.h = null;
            this.b = null;
        }
        this._altPath = string;
    }

    public void setForecastDir(String string) {
        this.e = string;
    }

    public void setRunId(String string) {
        this._runId = string;
    }

    public String getRunId() {
        return this._runId;
    }

    public void setTimeWindow(RunTimeWindow runTimeWindow) {
        this._runTimeWindow = runTimeWindow;
        this.setModified(true);
    }

    public long getRunModifiedTime() {
        return super.getLastModifiedTime();
    }

    public void setFpartPos(int n, int n2) {
        this._inputPos = n;
        this._modelPos = n2;
    }

    public void setFpartMultiplier(int n) {
        this.f = n;
    }

    public long getLastModifiedTime() {
        long l = super.getLastModifiedTime();
        if (l == Long.MAX_VALUE) {
            l = 0L;
        }
        ResRun resRun = this;
        l = resRun.getModTime(resRun._altPath, this.getAltClassName(), l);
        return l;
    }

    public int getLogLevel() {
        return this._logLevel;
    }

    public void setLogLevel(int n) {
        this._logLevel = n;
        this.setModified(true);
    }

    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }
}

