/*
 * Decompiled with CFR 0.152.
 */
package ressim.rma.util;

import hec.clientapp.model.StreamAlignment;
import hec.io.FilePath;
import hec.io.HecFile;
import hec.io.Identifier;
import hec.map.WorldRect;
import hec.model.StreamNode;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import mil.army.usace.hec.rmi.io.HecFileImpl;
import rma.util.RMAIO;
import rma.util.WildCardFileFilter;

public class StreamAlignVerifier {
    private HecFileImpl a;
    private WorldRect b;

    public StreamAlignVerifier(String fileArray) {
        this.a = new HecFileImpl(new FilePath((String)fileArray));
        if (!this.a.exists()) {
            System.out.println("StreamAlignVerifier: can't find file " + (String)fileArray);
            System.exit(1);
        }
        if (!this.a.canRead()) {
            System.out.println("StreamAlignVerifier: can't read file " + (String)fileArray);
            System.exit(1);
        }
        if (!this.a.canWrite()) {
            System.out.println("StreamAlignVerifier: can't write file " + (String)fileArray);
            System.exit(1);
        }
        fileArray = RMAIO.getDirectoryFromPath((String)fileArray);
        fileArray = new File((String)fileArray);
        Object object = new WildCardFileFilter("*.wksp");
        object.setAcceptDirectories(false);
        fileArray = fileArray.listFiles((FilenameFilter)object);
        if (fileArray != null && fileArray.length > 0) {
            try {
                Object object2;
                System.out.println("Using watershed file " + fileArray[0].getPath());
                object = new BufferedReader(new FileReader(fileArray[0]));
                while ((object2 = ((BufferedReader)object).readLine()) != null) {
                    if (!((String)object2).startsWith("Extents")) continue;
                    object2 = RMAIO.getParam((String)object2, (String)"=");
                    object2 = new StringTokenizer((String)object2, ",");
                    String string = ((StringTokenizer)object2).nextToken();
                    String string2 = ((StringTokenizer)object2).nextToken();
                    String string3 = ((StringTokenizer)object2).nextToken();
                    object2 = ((StringTokenizer)object2).nextToken();
                    double d = new Double(string);
                    double d2 = new Double(string2);
                    double d3 = new Double(string3);
                    double d4 = new Double((String)object2);
                    this.b = new WorldRect(d, d4, d2, d3);
                }
                ((BufferedReader)object).close();
                return;
            }
            catch (IOException iOException) {
                System.out.println("Error reading " + fileArray[0].getPath() + " Error:" + String.valueOf(iOException));
            }
        }
    }

    public static void a(String[] object) {
        if (object == null || ((String[])object).length == 0) {
            System.out.println("USAGE: StreamAlignVerifier stream align file");
            System.exit(1);
        }
        object = new StreamAlignVerifier(object[0]);
        StreamAlignment streamAlignment = new StreamAlignment();
        Identifier identifier = new Identifier(object.a.getPath(), (HecFile)object.a);
        if (!streamAlignment.readFile(identifier)) {
            System.out.println("failed to read file " + identifier.getPath());
        }
        Vector vector = streamAlignment.getNodeVector();
        boolean bl = false;
        for (int i = vector.size() - 1; i >= 0; --i) {
            StreamNode streamNode = (StreamNode)vector.get(i);
            if (streamNode == null) {
                vector.remove(i);
                continue;
            }
            if (streamNode.getStream() == null) {
                System.out.println("verify: node " + streamNode.getIndex() + " with no stream");
                vector.remove(i);
                bl = true;
            }
            if (object.b == null || object.b.contains(streamNode.getLocation())) continue;
            System.out.println("verify: WARNING node " + streamNode.getIndex() + " at (" + String.valueOf(streamNode.getLocation()) + ") is not within the Watershed's extents (" + String.valueOf(object.b) + ")");
        }
        if (bl) {
            File file = new File(identifier.getPath() + ".orig");
            System.out.println("verify: saving original file to " + file.getPath());
            if (!object.a.renameTo(file)) {
                System.out.println("verify: failed to rename original file. Not saving changes");
                System.exit(2);
            }
            System.out.println("verify: saving " + identifier.getPath());
            streamAlignment.writeFile(identifier);
        } else {
            System.out.println("verify: No Errors detected. no changes made.");
        }
        System.exit(0);
    }
}

