/*
 * Decompiled with CFR 0.152.
 */
package hec.help;

import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class ContextSpecificHelpActionListener
extends AbstractAction
implements MenuListener {
    private final String _url;
    private String _localPath;
    private Logger _logger = Logger.getLogger(ContextSpecificHelpActionListener.class.getName());

    public ContextSpecificHelpActionListener(String url, String localPath) {
        this._url = url;
        this._localPath = localPath;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this._logger.fine("Clicked " + this._url);
        this.displayHelp();
    }

    @Override
    public void menuSelected(MenuEvent e) {
        this._logger.fine("Selected " + this._url);
        this.displayHelp();
    }

    @Override
    public void menuDeselected(MenuEvent e) {
    }

    @Override
    public void menuCanceled(MenuEvent e) {
    }

    public void displayHelp() {
        try {
            if (ContextSpecificHelpActionListener.isOnline() && Desktop.isDesktopSupported()) {
                Desktop.getDesktop().browse(new URI(this._url));
            } else {
                URL localUrl = Thread.currentThread().getContextClassLoader().getResource(this._localPath);
                if (localUrl != null) {
                    String path = localUrl.getFile();
                    if (path.contains("jar!/")) {
                        path = this.extractFile(this._localPath);
                    }
                    if (path != null) {
                        this.openLocalFile(path);
                    }
                } else {
                    this.openLocalFile(this._localPath);
                }
            }
        }
        catch (Exception ex) {
            this._logger.info(ex.getMessage());
        }
    }

    private void openLocalFile(String path) throws IOException {
        this._logger.info("openLocalFile:opening local file path " + path);
        try {
            Desktop.getDesktop().open(new File(path));
        }
        catch (IllegalArgumentException iae) {
            this._logger.info("openLocalFile:" + iae);
        }
    }

    private String extractFile(String jarPath) {
        File tempFile;
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(jarPath);
        if (is == null) {
            this._logger.info("failed to open file " + jarPath);
            return null;
        }
        int extIdx = jarPath.lastIndexOf(46);
        String ext = null;
        if (extIdx > -1) {
            ext = jarPath.substring(extIdx);
        }
        try {
            tempFile = File.createTempFile("doc", ext);
        }
        catch (IOException e) {
            this._logger.info("failed to create temp file for local help " + e);
            return null;
        }
        tempFile.deleteOnExit();
        long rv = -1L;
        try {
            rv = Files.copy(is, tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            this._logger.info("failed to copy file " + e);
            return null;
        }
        if (rv > 0L) {
            this._localPath = tempFile.toString();
        }
        return this._localPath;
    }

    private static boolean isOnline() {
        try {
            URL url = new URL("http://www.google.com");
            URLConnection conn = url.openConnection();
            conn.connect();
            conn.getInputStream().close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

