/*
 * Decompiled with CFR 0.152.
 */
package hec.vrt;

import hec.vrt.VRTRasterBand;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.awt.Dimension;
import java.util.List;

@XmlRootElement(name="VRTDataset")
public class VRTDataSet {
    @XmlAttribute(name="rasterXSize")
    int mRasterXSize = 0;
    @XmlAttribute(name="rasterYSize")
    int mRasterYSize = 0;
    @XmlElement(name="SRS")
    String mCrsWKT = "";
    @XmlElement(name="GeoTransform")
    @XmlJavaTypeAdapter(value=GeoTransformAdapter.class)
    double[] mGeoTransform = new double[6];
    @XmlElement(name="VRTRasterBand")
    List<VRTRasterBand> mRasterBands = null;

    public Dimension getRasterDimension() {
        return new Dimension(this.mRasterXSize, this.mRasterYSize);
    }

    public String getCrsWKT() {
        return this.mCrsWKT;
    }

    public int getNumberOfBands() {
        return this.mRasterBands.size();
    }

    public VRTRasterBand getRasterBand(int band) {
        return this.mRasterBands.get(band - 1);
    }

    public double getNoDataValue() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static class GeoTransformAdapter
    extends XmlAdapter<String, double[]> {
        public double[] unmarshal(String v) throws Exception {
            String[] split = v.split(",");
            double[] values = new double[6];
            for (int i = 0; i < 6 && i < split.length; ++i) {
                String part = split[i].trim();
                if (part.isEmpty()) continue;
                values[i] = Double.valueOf(part);
            }
            return values;
        }

        public String marshal(double[] v) throws Exception {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < v.length; ++i) {
                if (i > 0) {
                    builder.append(",");
                }
                builder.append(v[i]);
            }
            return builder.toString();
        }
    }
}

