/*
 * Decompiled with CFR 0.152.
 */
package hec.vrt;

import hec.vrt.ComplexSource;
import hec.vrt.Histogram;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlValue;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class VRTRasterBand {
    @XmlAttribute(name="dataType")
    String mDataType;
    @XmlAttribute(name="band")
    int mBand = 0;
    @XmlElement(name="NoDataValue")
    double mNoDataValue;
    @XmlElementWrapper(name="Histograms")
    @XmlElement(name="HistItem")
    List<Histogram> mHistograms = new ArrayList<Histogram>();
    @XmlJavaTypeAdapter(value=MetaDataAdapter.class)
    @XmlElement(name="Metadata")
    Map<String, String> mMetaData = new HashMap<String, String>();
    @XmlElement(name="ComplexSource")
    List<ComplexSource> mComplexSource = new ArrayList<ComplexSource>();

    public List<ComplexSource> getSources() {
        return this.mComplexSource;
    }

    public double getNoDataValue() {
        return this.mNoDataValue;
    }

    public void setMetaDataItem(String key, String item) {
        if (key == null || item == null) {
            return;
        }
        this.mMetaData.put(key, item);
    }

    public String getMetaDataItem(String key) {
        return this.mMetaData.get(key);
    }

    public static class MetadataXmlElement {
        @XmlAttribute(name="key")
        String mKey;
        @XmlValue
        String mValue = "";
    }

    public static class MetadataXmlElements {
        @XmlElement(name="MDI")
        ArrayList<MetadataXmlElement> mElements = new ArrayList();
    }

    public static class MetaDataAdapter
    extends XmlAdapter<MetadataXmlElements, Map<String, String>> {
        public Map<String, String> unmarshal(MetadataXmlElements v) throws Exception {
            HashMap<String, String> map = new HashMap<String, String>();
            for (MetadataXmlElement element : v.mElements) {
                map.put(element.mKey, element.mValue);
            }
            return map;
        }

        public MetadataXmlElements marshal(Map<String, String> v) throws Exception {
            MetadataXmlElements elements = new MetadataXmlElements();
            Set<Map.Entry<String, String>> entrySet = v.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                MetadataXmlElement elem = new MetadataXmlElement();
                elem.mKey = entry.getKey();
                elem.mValue = entry.getValue();
                elements.mElements.add(elem);
            }
            return elements;
        }
    }
}

