/*
 * Decompiled with CFR 0.152.
 */
package hec.vrt;

import hec.vrt.RelativePathAdapter;
import hec.vrt.VRTDataSet;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class VRTReader {
    public VRTDataSet read(File inputFile) throws IOException {
        return this.read(new FileInputStream(inputFile), inputFile.getParentFile());
    }

    public VRTDataSet read(InputStream inputStream, File basePath) throws IOException {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{VRTDataSet.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            if (basePath != null) {
                RelativePathAdapter pathAdapter = new RelativePathAdapter(basePath.getAbsolutePath());
                unmarshaller.setAdapter((XmlAdapter)pathAdapter);
            }
            VRTDataSet unmarshal = (VRTDataSet)unmarshaller.unmarshal(inputStream);
            return unmarshal;
        }
        catch (JAXBException ex) {
            throw new IOException(ex.getMessage(), ex);
        }
    }
}

