/*
 * Decompiled with CFR 0.152.
 */
package hec.appInterface;

import hec.appInterface.AppDaddy;
import hec.appInterface.Application;
import hec.io.Identifier;
import hec.lang.ClientAppCheck;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.army.usace.hec.metadata.resourceservices.ParameterLoader;
import mil.army.usace.hec.metadata.resourceservices.ParameterResourceReader;
import rma.services.annotations.ServiceProvider;

@ServiceProvider(path="hec/data/Parameter", position=2000, service=ParameterLoader.class)
public class AppDaddyParameterLoader
extends ParameterResourceReader {
    private static final Logger LOGGER = Logger.getLogger(AppDaddyParameterLoader.class.getName());

    private static Optional<Identifier> downloadParameterFile() {
        return Optional.ofNullable(AppDaddy.getApp()).map(Application::downLoadParameterFile);
    }

    protected BufferedReader getBufferedReader() throws IOException {
        String fileName;
        Optional<Identifier> id;
        BufferedReader retval = null;
        if (ClientAppCheck.haveClientApp() && (id = AppDaddyParameterLoader.downloadParameterFile()).isPresent() && (fileName = id.get().getPath()) != null) {
            LOGGER.log(Level.INFO, "Reading parameter resource file from file system: {}", fileName);
            retval = new BufferedReader(new FileReader(fileName));
        }
        return retval;
    }

    protected Logger getLogger() {
        return LOGGER;
    }

    public int getOverwritePriority() {
        return super.getOverwritePriority(2000);
    }
}

