/*
 * Decompiled with CFR 0.152.
 */
package hec.chart;

import hec.chart.Selector;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;

public class ColorPanel
extends JPanel {
    private static final long serialVersionUID = -7747819230619938664L;
    private float _H = 0.5f;
    private float _S = 0.5f;
    private float _B = 1.0f;
    private Color _selectedColor = Color.red;
    private int _selectedX;
    private int _selectedY;
    public Color[][] ColorWheel;
    private int pW;
    private int pH;
    private int pW2;
    private int pH2;
    private int X;
    private int Y;
    public float[][] R;
    public float[][] Alpha;
    public float[][] Hue;
    public float[][] Saturation;
    Selector selector;

    public ColorPanel() {
        Dimension d = this.getPreferredSize();
        this.pH = this.pW = d.width;
        this.pH = d.height;
        this.pW2 = this.pW / 2;
        this.pH2 = this.pH / 2;
        this.ColorWheel = new Color[this.pH][this.pW];
        this.R = new float[this.pH][this.pW];
        this.Alpha = new float[this.pH][this.pW];
        this.Hue = new float[this.pH][this.pW];
        this.Saturation = new float[this.pH][this.pW];
        this._selectedX = 75;
        this._selectedY = 75;
        this.initColorWheel();
        this.setSelectedColor();
        this.selector = new Selector(this._selectedX, this._selectedY, 15, 15);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                ColorPanel.this.moveSelector(evt);
            }
        });
        this.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                ColorPanel.this.moveSelector(evt);
            }
        });
    }

    public void initColorWheel() {
        float tol = 1.5f;
        for (int x = 0; x < this.pW; ++x) {
            for (int y = 0; y < this.pH; ++y) {
                float r;
                this.X = x - this.pW2;
                this.Y = y - this.pH2;
                this.R[y][x] = r = (float)Math.sqrt(Math.pow(this.X, 2.0) + Math.pow(this.Y, 2.0));
                if (r <= (float)this.pW2 && r <= (float)this.pH2) {
                    Color drawColor;
                    float alpha = (float)Math.atan2(this.Y, this.X);
                    this._H = (float)((double)alpha / (Math.PI * 2));
                    this._S = r / (float)this.pW2;
                    this.Hue[y][x] = this._H;
                    this.Saturation[y][x] = this._S;
                    this.Alpha[y][x] = alpha;
                    this.ColorWheel[y][x] = drawColor = Color.getHSBColor(this._H, this._S, this._B);
                    continue;
                }
                this.ColorWheel[y][x] = null;
            }
        }
    }

    public void updateColorWheel() {
        for (int x = 0; x < this.pW; ++x) {
            for (int y = 0; y < this.pH; ++y) {
                this.X = x - this.pW2;
                this.Y = y - this.pH2;
                float r = this.R[y][x];
                if (r < (float)this.pW2 && r < (float)this.pH2) {
                    Color drawColor;
                    this._H = this.Hue[y][x];
                    this._S = this.Saturation[y][x];
                    this.ColorWheel[y][x] = drawColor = Color.getHSBColor(this._H, this._S, this._B);
                    continue;
                }
                this.ColorWheel[y][x] = null;
            }
        }
    }

    public void setBrightness(float b) {
        this._B = b;
        this.selector.setBrightness(this._B);
        this.setSelectedColor(this._selectedX, this._selectedY);
        this.repaint();
    }

    public float getBrightness() {
        return this._B;
    }

    public void setSelectedColor(int x, int y) {
        if (x >= 0 && y >= 0 && x < this.pW && y < this.pW && this.ColorWheel[y][x] != null) {
            this._selectedColor = this.ColorWheel[y][x];
            this._selectedX = x;
            this._selectedY = y;
        }
    }

    public void setSelectedColor() {
        this.setSelectedColor(this._selectedX, this._selectedY);
    }

    public Color getSelectedColor() {
        return this._selectedColor;
    }

    public int getSelectedX() {
        return this._selectedX;
    }

    public int getSelectedY() {
        return this._selectedY;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(200, 200);
    }

    private void moveSelector(MouseEvent evt) {
        int CURR_X = this.selector.getCx();
        int CURR_Y = this.selector.getCy();
        int CURR_W = this.selector.getWidth();
        int CURR_H = this.selector.getHeight();
        boolean OFFSET = true;
        int x = evt.getX();
        int y = evt.getY();
        if (x >= 0 && y >= 0 && x < this.pW && y < this.pH) {
            if (this.R[y][x] < (float)this.pW2 && this.R[y][x] < (float)this.pH2) {
                int cx = x - CURR_W / 2;
                int cy = y - CURR_H / 2;
                if (CURR_X != cx || CURR_Y != cy) {
                    this.repaint(CURR_X, CURR_Y, CURR_W + 1, CURR_H + 1);
                    this.selector.setX(x);
                    this.selector.setY(y);
                    this.repaint(this.selector.getCx(), this.selector.getCy(), this.selector.getWidth() + 1, this.selector.getHeight() + 1);
                }
            }
            this.setSelectedColor(x, y);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        Color drawColor = null;
        int blockSize = 1;
        for (int x = 0; x < this.pW; x += blockSize) {
            for (int y = 0; y < this.pH; y += blockSize) {
                drawColor = this.ColorWheel[y][x];
                if (drawColor == null) continue;
                g2d.setColor(drawColor);
                g2d.drawLine(x, y, x, y);
            }
        }
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.selector.setBrightness(this._B);
        this.selector.paintSelector(g2d);
        Color bColor = this.getBackground();
        g2d.setColor(bColor);
        BasicStroke stroke = new BasicStroke(20.0f);
        g2d.setStroke(stroke);
        int offset = 10;
        g2d.drawRoundRect(0 - offset, 0 - offset, this.pW + 2 * offset, this.pH + 2 * offset, this.pW + 2 * offset, this.pH + 2 * offset);
        stroke = new BasicStroke(1.0f);
        g2d.setStroke(stroke);
    }
}

