/*
 * Decompiled with CFR 0.152.
 */
package hec.chart;

import hec.chart.ColorPanel;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ColorWheel {
    private static float _B;
    private JFrame _frame;
    ColorPanel cp = new ColorPanel();

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (UnsupportedLookAndFeelException e) {
            ColorWheel.print(e.getStackTrace());
        }
        catch (ClassNotFoundException e) {
            ColorWheel.print(e.getStackTrace());
        }
        catch (InstantiationException e) {
            ColorWheel.print(e.getStackTrace());
        }
        catch (IllegalAccessException e) {
            ColorWheel.print(e.getStackTrace());
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ColorWheel.createAndShowGui();
            }
        });
    }

    public static void print(Object obj) {
        System.out.println(obj);
    }

    public ColorPanel getColorPanel() {
        return this.cp;
    }

    public void init() {
        boolean S_MIN = false;
        int S_MAX = 100;
        int S_MAJOR_TIC = 25;
        int S_MINOR_TIC = 5;
        int S_INIT = (int)(this.cp.getBrightness() * 100.0f);
        final JSlider brightSlider = new JSlider(0, 0, 100, S_INIT);
        brightSlider.setName("Brightness");
        brightSlider.setPreferredSize(new Dimension(275, 70));
        brightSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                float _B = (float)brightSlider.getValue() / 100.0f;
                ColorWheel.this.cp.setBrightness(_B);
                ColorWheel.this.cp.updateColorWheel();
            }
        });
        brightSlider.setMajorTickSpacing(25);
        brightSlider.setMinorTickSpacing(5);
        brightSlider.setPaintTicks(true);
        brightSlider.setPaintLabels(true);
        Border emptyBorder = BorderFactory.createEmptyBorder(40, 10, 40, 10);
        brightSlider.setBorder(BorderFactory.createTitledBorder(emptyBorder, "Brightness (%)", 2, 6));
        JPanel mp = new JPanel();
        mp.setLayout(new BoxLayout(mp, 3));
        Border mainBorder = BorderFactory.createEmptyBorder(20, 20, 20, 20);
        mp.setBorder(mainBorder);
        JPanel cpHolder = new JPanel();
        cpHolder.add(this.cp);
        Border colorBorder = BorderFactory.createEmptyBorder(0, 5, 5, 5);
        cpHolder.setBorder(colorBorder);
        mp.add(cpHolder);
        mp.add(Box.createRigidArea(new Dimension(0, 10)));
        mp.add(brightSlider);
        this._frame = new JFrame("HSB Color Wheel");
        this._frame.setDefaultCloseOperation(2);
        this._frame.add(mp);
        this._frame.setVisible(true);
        this._frame.setSize(270, 380);
    }

    public JFrame getFrame() {
        return this._frame;
    }

    public static void createAndShowGui() {
        ColorWheel cw = new ColorWheel();
        cw.init();
    }
}

