/*
 * Decompiled with CFR 0.152.
 */
package hec.chart;

import hec.chart.HistogramBin;
import hec.chart.HistogramWeightProvider;
import hec.statistics.PlottingPositions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Histogram {
    private static final Logger LOGGER = Logger.getLogger(Histogram.class.getName());
    public static final double TINY_DOUBLE = -1.0E9;
    public static final double HUGE_DOUBLE = 1.0E9;
    public static final int AUTOMATIC = 1;
    public static final int UNIFORM = 2;
    public static final int IRREGULAR = 3;
    public static final double UNDEFINED_DOUBLE = -3.4028234663852886E38;
    public static final int UNDEFINED_INT = Integer.MIN_VALUE;
    private ArrayList<HistogramBin> _bins = new ArrayList();
    private double[] _data;
    private double[] _binMinimums;
    private double[] _binMaximums;
    private double[] _binCenters;
    private double[] _frequencies;
    private double[] _counts;
    private double[] _cumlativeFrequencies;
    private double[] _sortedData;
    private double _binSize = -3.4028234663852886E38;
    private double _xMin = -3.4028234663852886E38;
    private double _xMax = -3.4028234663852886E38;
    private int _npts = 0;
    private int _nbins = 20;
    private int _method = Integer.MIN_VALUE;
    private HistogramWeightProvider _histWeightProvider = new UniformWeightProvider();

    public Histogram(double[] X, HistogramWeightProvider histWeightProvider, int nbins, double binSize, double xMin, double xMax) {
        this._data = X;
        if (histWeightProvider != null) {
            this._histWeightProvider = histWeightProvider;
        }
        this._xMin = xMin;
        this._xMax = xMax;
        this._nbins = nbins;
        this._binSize = binSize;
        this._method = 1;
        if (this._data != null) {
            this._npts = this._data.length;
        }
        this.setBins();
        this.computeHistogram();
    }

    public Histogram(double[] X, int nbins, double binSize, double Xmin, double Xmax) {
        this(X, null, nbins, binSize, Xmin, Xmax);
    }

    public Histogram(double[] x, double[] uBins) {
        this._data = x;
        if (this._data != null) {
            this._npts = this._data.length;
        }
        this.setBins(uBins);
        this.computeHistogram();
        this._method = this.isUniform(uBins) ? 2 : 3;
    }

    public Histogram(double[] x, int nbins, double xMin, double xMax) {
        this(x, nbins, -3.4028234663852886E38, xMin, xMax);
    }

    public Histogram(double[] x, double binSize, double xMin, double xMax) {
        this(x, Integer.MIN_VALUE, binSize, xMin, xMax);
    }

    public Histogram(double[] x, int nbins) {
        this(x, nbins, -3.4028234663852886E38, -3.4028234663852886E38, -3.4028234663852886E38);
    }

    public Histogram(double[] x, double binSize) {
        this(x, Integer.MIN_VALUE, binSize, -3.4028234663852886E38, -3.4028234663852886E38);
    }

    public boolean isUniform(double[] bins) {
        double tol = 0.001;
        double test = bins[1] - bins[0];
        for (int i = 1; i < bins.length; ++i) {
            double diff = bins[i] - bins[i - 1];
            if (!(Math.abs(diff - test) > tol)) continue;
            return false;
        }
        return true;
    }

    public void computeHistogram() {
        int i;
        this._npts = 0;
        if (this._data != null) {
            this._npts = this._data.length;
        }
        for (i = 0; i < this._npts; ++i) {
            for (HistogramBin bin : this._bins) {
                if (!(this._data[i] >= bin.getMin()) || !(this._data[i] < bin.getMax())) continue;
                bin.increment(this._histWeightProvider.getWeight(i, this._npts));
            }
        }
        this._binMinimums = new double[this._nbins];
        this._binMaximums = new double[this._nbins];
        this._binCenters = new double[this._nbins];
        this._counts = new double[this._nbins];
        this._frequencies = new double[this._nbins];
        this._cumlativeFrequencies = new double[this._nbins];
        for (i = 0; i < this._nbins; ++i) {
            this._binMinimums[i] = this._bins.get(i).getMin();
            this._binMaximums[i] = this._bins.get(i).getMax();
            this._binCenters[i] = this._bins.get(i).getCenter();
            this._counts[i] = this._bins.get(i).getCount();
            this._frequencies[i] = this._bins.get(i).getFrequency();
            this._cumlativeFrequencies[i] = i > 0 ? this._bins.get(i).getFrequency() + this._cumlativeFrequencies[i - 1] : this._bins.get(i).getFrequency();
        }
        this._sortedData = new double[this._npts];
        System.arraycopy(this._data, 0, this._sortedData, 0, this._npts);
        Arrays.sort(this._sortedData);
    }

    public double max(double[] x) {
        double xmax = -1.0E9;
        if (x != null) {
            for (double i : x) {
                if (!(i > xmax)) continue;
                xmax = i;
            }
        }
        return xmax;
    }

    public double min(double[] x) {
        double xmin = 1.0E9;
        if (x != null) {
            for (double i : x) {
                if (!(i < xmin)) continue;
                xmin = i;
            }
        }
        return xmin;
    }

    public int length() {
        if (this._data == null) {
            return 0;
        }
        return this._data.length;
    }

    public double max() {
        double xmax = -1.0E9;
        if (this._data != null) {
            for (double x : this._data) {
                if (!(x > xmax)) continue;
                xmax = x;
            }
        }
        return xmax;
    }

    public double min() {
        double xmin = 1.0E9;
        if (this._data != null) {
            for (double x : this._data) {
                if (!(x < xmin)) continue;
                xmin = x;
            }
        }
        return xmin;
    }

    public double range() {
        return this.max() - this.min();
    }

    public double mean() {
        double xmean = 0.0;
        double sum = 0.0;
        int count = 0;
        if (this._data != null) {
            for (double x : this._data) {
                sum += x;
                ++count;
            }
        }
        if (count != 0) {
            xmean = sum / (double)count;
        }
        return xmean;
    }

    public double frequencyCheck() {
        double freq = 0.0;
        for (HistogramBin bin : this._bins) {
            freq += bin.getFrequency();
        }
        return freq;
    }

    public double stdDev() {
        double sum = 0.0;
        double xmean = this.mean();
        int count = 0;
        if (this._data != null) {
            for (double x : this._data) {
                double xdiff = x - xmean;
                double xdiffsq = Math.pow(xdiff, 2.0);
                sum += xdiffsq;
                ++count;
            }
        }
        double xstd = Math.sqrt(sum / ((double)count - 1.0));
        return xstd;
    }

    public void setBins() {
        if (this._data == null) {
            return;
        }
        if (this._xMin == -3.4028234663852886E38) {
            this._xMin = this.min();
        }
        if (this._xMax == -3.4028234663852886E38) {
            this._xMax = this.max();
        }
        if (this._binSize == -3.4028234663852886E38) {
            this._binSize = (this._xMax - this._xMin) / (double)this._nbins;
            this._binSize += this._binSize * 1.0E-12;
        }
        if (this._binSize > 0.0) {
            for (double d = this._xMin; d < this._xMax; d += this._binSize) {
                HistogramBin bin = new HistogramBin(d, d + this._binSize, this._npts);
                this._bins.add(bin);
            }
        } else {
            double xmax = this._xMin + Math.pow(10.0, Math.round(Math.log10(this._xMin))) / 10.0;
            HistogramBin bin = new HistogramBin(this._xMin, xmax, this._npts);
            this._bins.add(bin);
        }
        this._nbins = this._bins.size();
    }

    public void setBins(double[] uBins) {
        double bMin = this.min(uBins);
        double bMax = this.max(uBins);
        double xMin = this.min();
        double xMax = this.max();
        if (xMin < bMin) {
            HistogramBin bin = new HistogramBin(xMin, bMin, this._npts);
            this._bins.add(bin);
        }
        for (int i = 0; i < uBins.length - 1; ++i) {
            HistogramBin bin = new HistogramBin(uBins[i], uBins[i + 1], this._npts);
            this._bins.add(bin);
        }
        if (xMax > bMax) {
            HistogramBin bin = new HistogramBin(bMax, xMax, this._npts);
            this._bins.add(bin);
        }
        this._nbins = this._bins.size();
    }

    public void setBinsOverrideMinAndMax(double[] uBins) {
        for (int i = 0; i < uBins.length - 1; ++i) {
            HistogramBin bin = new HistogramBin(uBins[i], uBins[i + 1], this._npts);
            this._bins.add(bin);
        }
        this._nbins = this._bins.size();
    }

    public int getMethod() {
        return this._method;
    }

    public double[] getData() {
        return this._data;
    }

    public double[] getSortedData() {
        return this._sortedData;
    }

    public double[] getBinMinimums() {
        return this._binMinimums;
    }

    public double[] getBinMaximums() {
        return this._binMaximums;
    }

    public double[] getBinCenters() {
        return this._binCenters;
    }

    public double[] getCounts() {
        return this._counts;
    }

    public double[] getFrequencies() {
        return this._frequencies;
    }

    public double[] getCumlativeFrequencies() {
        return this._cumlativeFrequencies;
    }

    public int getNumBins() {
        return this._nbins;
    }

    public double getBinSize() {
        return this._binSize;
    }

    public void setNumBins(int nbins) {
        this._nbins = nbins;
    }

    public void setBinSize(double binSize) {
        this._binSize = binSize;
    }

    public static double[] arange(double xmin, double xmax, double dx) {
        int n = (int)((xmax - xmin) / dx + 1.0);
        double[] x = new double[n];
        double min = xmin;
        for (int i = 0; i < n; ++i) {
            x[i] = min;
            min += dx;
        }
        return x;
    }

    public void printArray(double[] x) {
        LOGGER.info("[ ");
        for (double i : x) {
            String xstr = String.format("%.2f", i);
            LOGGER.info(xstr + ", ");
        }
        LOGGER.info(" ]\n");
    }

    public void print(boolean plotHist) {
        Object header = "Min \tCenter\tMax \tRange\tCount\tFreq";
        if (plotHist) {
            header = (String)header + "\tHistogram";
        }
        LOGGER.info("Bin Summary:");
        LOGGER.info("-------------------------------------------------------------");
        LOGGER.info((String)header);
        LOGGER.info("-------------------------------------------------------------");
        for (HistogramBin bin : this._bins) {
            String gmin = String.format("%.2f", bin.getMin());
            String gcenter = String.format("%.2f", bin.getCenter());
            String gmax = String.format("%.2f", bin.getMax());
            String grange = String.format("%.2f", bin.getRange());
            String gcount = String.format("%d", bin.getCount());
            String gfreq = String.format("%.4f", bin.getFrequency());
            if (bin.getMin() <= -1.0E9) {
                gmin = "-Inf ";
                gcenter = "NaN ";
                grange = "NaN ";
            }
            if (bin.getMax() >= 1.0E9) {
                gmax = "+Inf ";
                gcenter = "NaN ";
                grange = "NaN ";
            }
            String tableRow = gmin + "\t" + gcenter + "\t" + gmax + "\t" + grange + "\t" + gcount + "\t" + gfreq;
            if (plotHist) {
                tableRow = tableRow + "\t" + bin.getCountString();
            }
            LOGGER.info(tableRow);
        }
    }

    public void print() {
        this.print(false);
    }

    public String toString() {
        String numberOfPts = this._data != null ? String.format("%d", this._data.length) : "null";
        return "\nNumber of Points:\t" + numberOfPts + "\nMean:\t\t" + String.format("%.2f", this.mean()) + "\nStandard Deviation:\t" + String.format("%.2f", this.stdDev()) + "\nMinimum:\t\t" + String.format("%.2f", this.min()) + "\nMaximum:\t\t" + String.format("%.2f", this.max()) + "\nRange:\t\t" + String.format("%.2f", this.range()) + "\nTotal Frequency:\t" + String.format("%.4f", this.frequencyCheck());
    }

    public void printSummaryStats() {
        String numberOfPts = this._data != null ? String.format("%d", this._data.length) : "null";
        LOGGER.info("Summary Statistics:");
        LOGGER.info("-------------------------------------------------------------");
        LOGGER.info(() -> "Number of Points:   " + numberOfPts);
        LOGGER.info(() -> "Mean:               " + String.format("%.2f", this.mean()));
        LOGGER.info(() -> "Standard Deviation: " + String.format("%.2f", this.stdDev()));
        LOGGER.info(() -> "Minimum:            " + String.format("%.2f", this.min()));
        LOGGER.info(() -> "Maximum:            " + String.format("%.2f", this.max()));
        LOGGER.info(() -> "Range:              " + String.format("%.2f", this.range()));
        LOGGER.info(() -> "Total Frequency:    " + String.format("%.4f", this.frequencyCheck()));
        LOGGER.info("-------------------------------------------------------------");
    }

    public double getPercentile(int rank) {
        return ((double)rank - 0.5) / (double)this._sortedData.length;
    }

    @Deprecated
    public double getPlottingPercentile(int rankM, double A, double B) {
        int sortedDatalengthN = this._sortedData.length;
        if (A >= 0.0 && A <= 1.0 && B >= 0.0 && B <= 1.0) {
            return ((double)rankM - A) / ((double)(sortedDatalengthN + 1) - A - B);
        }
        return this.getPercentile(rankM);
    }

    public double getPlottingPercentile(int rankM, PlottingPositions plotPositions) {
        int sortedDatalengthN = this._sortedData.length;
        try {
            return plotPositions.computePlottingPosition(rankM, sortedDatalengthN);
        }
        catch (IllegalArgumentException e) {
            Logger.getLogger(Histogram.class.getName()).log(Level.FINE, "Illegal plotting positions settings. Using hazen plotting position.", e);
            return this.getPercentile(rankM);
        }
    }

    public void clearBins() {
        this._bins.clear();
    }

    private class UniformWeightProvider
    implements HistogramWeightProvider {
        private UniformWeightProvider() {
        }

        @Override
        public double getWeight(int index, int datasetLength) {
            return 1.0 / (double)datasetLength;
        }
    }
}

