/*
 * Decompiled with CFR 0.152.
 */
package hec.chart;

public class HistogramBin {
    private int _bcount = 0;
    private double _bmin;
    private double _bmax;
    private double _bcenter;
    private double _brange;
    private double _bfrequency = 0.0;
    private String _bcountStr = "";
    private int _npts = 0;

    public HistogramBin(double bmin, double bmax, int npts) {
        this._bmin = bmin;
        this._bmax = bmax;
        this._bcount = 0;
        this._brange = this._bmax - this._bmin;
        this._bcenter = (this._bmax + this._bmin) / 2.0;
        this._npts = npts;
    }

    public void increment() {
        ++this._bcount;
        this._bfrequency += 1.0 / (double)this._npts;
    }

    public void increment(double weight) {
        ++this._bcount;
        this._bfrequency += weight;
    }

    public double getMin() {
        return this._bmin;
    }

    public double getMax() {
        return this._bmax;
    }

    public double getCenter() {
        return this._bcenter;
    }

    public int getCount() {
        return this._bcount;
    }

    public String getCountString() {
        if (this._bcountStr.isEmpty()) {
            StringBuilder sb = new StringBuilder(this._bcount + 1);
            sb.append("|");
            for (int i = 0; i < this._bcount; ++i) {
                sb.append('+');
            }
            this._bcountStr = sb.toString();
        } else {
            int length = this._bcountStr.length();
            if (length > this._bcount + 1) {
                this._bcountStr = this._bcountStr.substring(0, this._bcount + 1);
            } else if (length < this._bcount + 1) {
                StringBuilder sb = new StringBuilder(this._bcount + 1);
                sb.append(this._bcountStr);
                this._bcountStr = "";
                for (int i = length; i < this._bcount + 1; ++i) {
                    sb.append('+');
                }
                this._bcountStr = sb.toString();
            }
        }
        return this._bcountStr;
    }

    public double getRange() {
        return this._brange;
    }

    public double getFrequency() {
        return this._bfrequency;
    }
}

