/*
 * Decompiled with CFR 0.152.
 */
package hec.chart;

import hec.chart.Histogram;
import hec.chart.HistogramPlotDialog;
import hec.chart.HistogramWeightProvider;
import hec.io.DataContainer;
import hec.io.PairedDataContainer;
import hec.io.TimeSeriesContainer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItem;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYBarPainter;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYBarPainter;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYIntervalSeries;
import org.jfree.data.xy.XYIntervalSeriesCollection;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.RectangleEdge;

public class HistogramChart
extends ChartPanel {
    private static final long serialVersionUID = 4271577384491806180L;
    private static final Logger LOGGER = Logger.getLogger(HistogramChart.class.getName());
    public static final int COUNTS = 0;
    public static final int FREQUENCIES = 1;
    public static final int NUMBER_OF_BINS = 0;
    public static final int BIN_SIZE = 1;
    public static final int USER_DEFINED = 2;
    public static final int nBinsDefault = 20;
    public static final double binSizeDefault = 1.0;
    private static Random rand = new Random(100L);
    protected JFreeChart _chart;
    protected double[] _values;
    private HistogramWeightProvider _histWeightProvider = null;
    protected int _nbins = 20;
    protected double _binSize = 1.0;
    protected double _xMin = -3.4028234663852886E38;
    protected double _xMax = -3.4028234663852886E38;
    protected int _histogramType = 0;
    protected int _binType = 0;
    protected Histogram _hist;
    protected ChartPanel _cp = null;
    protected String _dataName = "Data";
    protected String _xLabel = "Value";
    protected String _yLabel = "";
    protected String _histTitle = "";
    private Color _color1 = new Color(140, 120, 255);
    private Color _color2 = this._color1.darker();
    private GradientPaint _gradientPaint = new GradientPaint(0.0f, 0.0f, this._color1, 0.0f, 0.0f, this._color2);
    protected boolean _plotAnalytic = false;
    private double[] _xA;
    private double[] _yA;
    private Color _seriesColor = this._gradientPaint.getColor1();
    protected List<? extends DataContainer> _containers = null;
    protected HistogramPlotDialog _histTool = null;
    private boolean _displayHistogramDialog = true;
    protected int _curve = 0;

    public HistogramChart() {
        super(null);
        this.setMouseWheelEnabled(true);
        this.addMouseListener((MouseListener)((Object)this));
        this.addMouseMotionListener((MouseMotionListener)((Object)this));
        this.addChartMouseListener(new ChartMouseListener(){

            public void chartMouseClicked(ChartMouseEvent e) {
                try {
                    ChartEntity entity = e.getEntity();
                    XYItemEntity xyentity = (XYItemEntity)entity;
                    XYDataset xydataset = xyentity.getDataset();
                    XYPlot plot = HistogramChart.this._chart.getXYPlot();
                    XYItemRenderer renderer = plot.getRendererForDataset(xydataset);
                    if (renderer instanceof XYBarRenderer) {
                        XYBarRenderer barRenderer = (XYBarRenderer)renderer;
                        barRenderer.setSeriesPaint(0, (Paint)HistogramChart.this._seriesColor, true);
                        XYBarPainter painter = new XYBarPainter(){

                            public void paintBar(Graphics2D g2, XYBarRenderer renderer, int row, int col, RectangularShape bar, RectangleEdge base) {
                                double newWidth = bar.getWidth() - 1.7;
                                bar.setFrame(bar.getX(), bar.getY(), newWidth, bar.getHeight());
                                g2.setColor(HistogramChart.this._seriesColor);
                                g2.setPaint(HistogramChart.this._gradientPaint);
                                g2.fill(bar);
                                g2.draw(bar);
                            }

                            public void paintBarShadow(Graphics2D g2, XYBarRenderer renderer, int row, int col, RectangularShape bar, RectangleEdge base, boolean arg6) {
                            }
                        };
                        barRenderer.setBarPainter(painter);
                        LOGGER.info("BAR RENDERER");
                    } else {
                        LOGGER.info("UNKNOWN RENDERER");
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            public void chartMouseMoved(ChartMouseEvent e) {
            }
        });
        this._cp = this;
    }

    public HistogramChart(Histogram hist, int histType, int binType) {
        this();
        this.init(hist, histType, binType);
    }

    public HistogramChart(List<? extends DataContainer> pdContainers, int histType, int binType) {
        this();
        this.init(pdContainers, histType, binType);
    }

    public void init(List<? extends DataContainer> pdcList, int histType, int binType) {
        this.init(pdcList, histType, binType, this._xLabel);
    }

    public void init(List<? extends DataContainer> pdcList, int histType, int binType, int curve) {
        this._curve = curve;
        this.init(pdcList, histType, binType, this._xLabel);
    }

    public void init(List<? extends DataContainer> containers, int histType, int binType, String xAxisPlotLabels) {
        this._histogramType = histType;
        this._binType = binType;
        if (xAxisPlotLabels != null && !xAxisPlotLabels.isEmpty()) {
            this._xLabel = xAxisPlotLabels;
        }
        if (containers == null || containers.isEmpty()) {
            return;
        }
        this.setContainers(containers);
        if (containers.get(0) instanceof PairedDataContainer) {
            PairedDataContainer first = (PairedDataContainer)containers.get(0);
            PairedDataContainer pdc = new PairedDataContainer();
            first.clone(pdc);
            this.replaceYOrdinateValue(pdc, -3.4028234663852886E38, Double.NaN);
            if (null == pdc.yOrdinates || pdc.yOrdinates.length == 0) {
                LOGGER.log(Level.WARNING, "HistogramChart cannot be initialized from a PairedDataContainer with a null or zero-sized yOrdinates array.{0}", pdc);
                this._values = null;
            } else if (this._curve == -1) {
                this._values = new double[pdc.numberCurves * pdc.numberOrdinates];
                for (int i = 0; i < pdc.numberCurves; ++i) {
                    System.arraycopy(pdc.yOrdinates[i], 0, this._values, i * pdc.numberOrdinates, pdc.numberOrdinates);
                }
            } else if (this._curve < pdc.yOrdinates.length) {
                this._values = pdc.yOrdinates[this._curve];
            }
        } else if (containers.get(0) instanceof TimeSeriesContainer) {
            TimeSeriesContainer tsc = (TimeSeriesContainer)containers.get(0);
            this._values = tsc.values;
        }
        if (this._binType == 0) {
            this._hist = new Histogram(this._values, 20);
        } else if (this._binType == 1) {
            this._hist = new Histogram(this._values, 1.0);
        }
    }

    public void init(Histogram hist, int histType, int binType) {
        this.init(hist, histType, binType, this._xLabel);
    }

    public void init(Histogram hist, int histType, int binType, String xAxisPlotLabels) {
        this._histogramType = histType;
        this._binType = binType;
        this._nbins = 20;
        this._hist = hist;
        if (xAxisPlotLabels != null && !xAxisPlotLabels.isEmpty()) {
            this._xLabel = xAxisPlotLabels;
        }
    }

    public void setNumBins(int nbins) {
        this._nbins = nbins;
        this.update();
    }

    public void setBinSize(double binSize) {
        this._binSize = binSize;
        this.update();
    }

    public void setHistogramType(int type) {
        this._histogramType = type;
        this.update();
    }

    public void setBinType(int type) {
        this._binType = type;
        this.update();
    }

    public void setXmin(double xmin) {
        this._xMin = xmin;
    }

    public void setXmax(double xmax) {
        this._xMax = xmax;
    }

    public void setSeriesColor() {
        this.update();
    }

    public Histogram getHistogram() {
        return this._hist;
    }

    public JFreeChart getChart() {
        return this._chart;
    }

    public ChartPanel getChartPanel() {
        return this._cp;
    }

    public int getNumBins() {
        return this._nbins;
    }

    public double getBinSize() {
        return this._binSize;
    }

    public void update() {
        if (this._binType == 0) {
            this._hist = new Histogram(this._values, this._histWeightProvider, this._nbins, -3.4028234663852886E38, this._xMin, this._xMax);
        } else if (this._binType == 1) {
            this._hist = new Histogram(this._values, this._histWeightProvider, this._nbins, this._binSize, this._xMin, this._xMax);
        }
        this._nbins = this._hist.getNumBins();
        this.plot();
    }

    public void updateWithNoReconstruction() {
        this._nbins = this._hist.getNumBins();
        this.plot();
    }

    public void plot() {
        if (this._hist == null) {
            return;
        }
        this.setYLabel();
        this.plot(this._histTitle, this._dataName, this._xLabel, this._yLabel);
    }

    public Image getImage(String filePath) {
        BufferedImage image = null;
        if (filePath != null && filePath.startsWith("http")) {
            URL url = null;
            try {
                url = new URL(filePath);
                image = ImageIO.read(url);
            }
            catch (MalformedURLException e) {
                Logger.getLogger(HistogramChart.class.getName()).log(Level.WARNING, null, e);
            }
            catch (IOException ex) {
                Logger.getLogger(HistogramChart.class.getName()).log(Level.WARNING, null, ex);
            }
        } else {
            File imFile = new File(filePath);
            try {
                image = ImageIO.read(imFile);
            }
            catch (IOException e) {
                Logger.getLogger(HistogramChart.class.getName()).log(Level.WARNING, null, e);
            }
        }
        return image;
    }

    public void plot(String histTitle, String dataName, String xLabel, String yLabel) {
        this._histTitle = histTitle;
        this._dataName = dataName;
        this._xLabel = xLabel;
        this._yLabel = yLabel;
        IntervalXYDataset dataset = this.createDataset(dataName, this._histogramType);
        if (dataset == null) {
            dataset = new XYIntervalSeriesCollection();
        }
        this._chart = ChartFactory.createXYBarChart((String)this._histTitle, (String)this._xLabel, (boolean)false, (String)this._yLabel, (IntervalXYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        this._chart.setBackgroundPaint((Paint)Color.white);
        this._chart.getTitle().setFont(new Font("Arial", 1, 22));
        XYPlot plot = (XYPlot)this._chart.getPlot();
        XYBarRenderer br = (XYBarRenderer)plot.getRenderer();
        br.setShadowVisible(false);
        br.setMargin(0.3);
        br.setDrawBarOutline(false);
        br.setBarPainter((XYBarPainter)new StandardXYBarPainter());
        br.setSeriesPaint(0, (Paint)this._gradientPaint);
        plot.setBackgroundPaint((Paint)Color.white);
        plot.setRangeGridlinePaint((Paint)Color.lightGray);
        plot.setBackgroundPaint((Paint)Color.white);
        plot.setRangeGridlinePaint((Paint)Color.lightGray);
        Color white = new Color(255, 255, 255);
        GradientPaint p = new GradientPaint(0.0f, 0.0f, white, 1000.0f, 1000.0f, white);
        this._chart.setBackgroundPaint((Paint)p);
        this._chart.getPlot().setBackgroundPaint((Paint)new Color(245, 245, 245));
        this._chart.getPlot().setOutlinePaint((Paint)new Color(120, 120, 120));
        this._chart.getLegend().setVisible(false);
        int legendItemCount = plot.getLegendItems().getItemCount();
        if (legendItemCount > 0) {
            LegendItem ppp = plot.getLegendItems().get(0);
            if (legendItemCount <= 20) {
                ppp.setLabelFont(new Font("Sanserif", 10, 12));
            } else {
                ppp.setLabelFont(new Font("Sanserif", 10, 10));
            }
        }
        plot.setBackgroundAlpha(0.9f);
        this._chart.setBackgroundImageAlpha(0.1f);
        LegendTitle legend = this._chart.getLegend();
        legend.setBorder(0.5, 0.5, 0.5, 0.5);
        legend.setMargin(3.0, 3.0, 10.0, 3.0);
        legend.setPadding(4.0, 7.0, 4.0, 7.0);
        Font labelFont = new Font("Palatino", 1, 12);
        if (legendItemCount > 20) {
            labelFont = new Font("Palatino", 1, 10);
        }
        legend.setItemFont(labelFont);
        legend.setBackgroundPaint((Paint)new Color(255, 247, 247));
        if (!this._histTitle.isEmpty()) {
            this._chart.getTitle().setPadding(10.0, 10.0, 10.0, 10.0);
        }
        this._chart.setBackgroundPaint((Paint)Color.white);
        Color bColor = new Color(240, 240, 240);
        this._chart.setBackgroundPaint((Paint)bColor);
        if (this._plotAnalytic) {
            this.plotAnalytic();
        }
        if (this._cp != null) {
            this.remove((Component)this._cp);
        }
        this.setChart(this._chart);
        this.setVisible(true);
    }

    protected IntervalXYDataset createDataset(String histTitle, int histType) {
        XYIntervalSeries series1 = new XYIntervalSeries((Comparable)((Object)histTitle));
        if (this._hist.getBinMaximums() == null || this._hist.getBinMinimums() == null) {
            return null;
        }
        int npts = this._hist.getBinMinimums().length;
        for (int i = 0; i < npts; ++i) {
            double x1 = this._hist.getBinMinimums()[i];
            double x2 = this._hist.getBinMaximums()[i];
            double y = histType == 0 ? this._hist.getCounts()[i] : this._hist.getFrequencies()[i];
            series1.add(x1, x1, x2, y, 0.0, y);
        }
        XYIntervalSeriesCollection dataset = new XYIntervalSeriesCollection();
        if (series1.getItemCount() > 0) {
            dataset.addSeries(series1);
        }
        return dataset;
    }

    public void setAnalyticData(double[] xA, double[] yA) {
        this._xA = xA;
        this._yA = yA;
    }

    public void setPlotAnalytic(boolean plotA) {
        this._plotAnalytic = plotA;
    }

    public boolean hasPlotAnalytic() {
        return this._plotAnalytic;
    }

    public void plotAnalytic() {
        if (this._xA == null || this._yA == null) {
            return;
        }
        XYPlot plot = this._chart.getXYPlot();
        XYSeries series = new XYSeries((Comparable)((Object)"Analytic Gaussian"));
        for (int i = 0; i < this._xA.length; ++i) {
            series.add(this._xA[i], this._yA[i]);
        }
        XYSeriesCollection dataset2 = new XYSeriesCollection();
        dataset2.addSeries(series);
        plot.setDataset(1, (XYDataset)dataset2);
        plot.mapDatasetToRangeAxis(1, 1);
        NumberAxis axis2 = new NumberAxis("Secondary");
        plot.setRangeAxis(1, (ValueAxis)axis2);
        axis2.setVisible(false);
        StandardXYItemRenderer renderer2 = new StandardXYItemRenderer();
        Color lineColor = new Color(255, 0, 0);
        renderer2.setSeriesPaint(0, (Paint)lineColor);
        renderer2.setBaseToolTipGenerator((XYToolTipGenerator)new StandardXYToolTipGenerator());
        plot.setRenderer(1, (XYItemRenderer)renderer2);
        plot.setDatasetRenderingOrder(DatasetRenderingOrder.FORWARD);
    }

    public static double[] gaussianArray(int npts, double shift, double scale) {
        double[] x1 = new double[npts];
        for (int i = 0; i < npts; ++i) {
            x1[i] = (rand.nextGaussian() + shift) * scale;
        }
        return x1;
    }

    public static double[] gaussianArray(int npts) {
        double[] x1 = new double[npts];
        for (int i = 0; i < npts; ++i) {
            x1[i] = rand.nextGaussian();
        }
        return x1;
    }

    public static double[] analyticGaussian(double[] X) {
        double[] y = new double[X.length];
        double a = 1.0;
        double b = 0.0;
        double c2 = 1.0;
        for (int i = 0; i < X.length; ++i) {
            double x = X[i];
            double u = Math.pow(x - b, 2.0);
            double l = 2.0 * Math.pow(c2, 2.0);
            y[i] = a * Math.exp(-u / l);
        }
        return y;
    }

    public void zoomToAll() {
        this.restoreAutoBounds();
    }

    protected void replaceYOrdinateValue(PairedDataContainer pdc, double query, double replacement) {
        if (pdc != null && null != pdc.yOrdinates && pdc.yOrdinates.length > 0) {
            double[][] dArray = pdc.yOrdinates;
            int n = dArray.length;
            for (int i = 0; i < n; ++i) {
                double[] yOrdinate2;
                double[] yOrdinate = yOrdinate2 = dArray[i];
                for (int k = 0; k < yOrdinate.length; ++k) {
                    double d = yOrdinate[k];
                    if (query != d) continue;
                    yOrdinate[k] = replacement;
                }
            }
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (this._cp == null) {
            return;
        }
        if (e.getClickCount() > 1 && SwingUtilities.isLeftMouseButton(e)) {
            this.showPopupPlot();
        }
    }

    public void showPopupPlot() {
        if (!this.isDisplayHistogramDialog()) {
            return;
        }
        if (this.getHistTool() == null && this.getContainers() != null && !this.getContainers().isEmpty()) {
            this.setHistTool(new HistogramPlotDialog(this.getContainers()));
        } else {
            JOptionPane.showMessageDialog((Component)((Object)this), "No data read", "No data found", 2);
        }
    }

    public void setDisplayHistogramDialog(boolean displayHistogramDialog) {
        this._displayHistogramDialog = displayHistogramDialog;
    }

    public void setBinSizeNoRebuild(double binSize) {
        this._binSize = binSize;
    }

    public void setBinTypeNoRebuild(int binType) {
        this._binType = binType;
    }

    public void setNumBinsNoRebuild(int length) {
        this._nbins = length;
    }

    public boolean isDisplayHistogramDialog() {
        return this._displayHistogramDialog;
    }

    public HistogramPlotDialog getHistTool() {
        return this._histTool;
    }

    public void setHistTool(HistogramPlotDialog histTool) {
        this._histTool = histTool;
    }

    public List<? extends DataContainer> getContainers() {
        return this._containers;
    }

    public void setContainers(List<? extends DataContainer> containers) {
        this._containers = containers;
    }

    public void setYLabel(String yLabel) {
        this._yLabel = yLabel;
    }

    public void setYLabel() {
        this._yLabel = this._histogramType == 0 ? "Counts" : "Probability";
    }

    public void setHistogramWeightProvider(HistogramWeightProvider weightProvider) {
        this._histWeightProvider = weightProvider;
    }
}

