/*
 * Decompiled with CFR 0.152.
 */
package hec.chart;

import hec.chart.Histogram;
import hec.chart.HistogramChart;
import hec.io.DataContainer;
import hec.statistics.DistributionTypes;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JPanel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJButton;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJPanel;
import rma.swing.RmaJRadioButton;
import rma.swing.RmaJSpinner;
import rma.util.RMAIO;

public class HistogramOptionsPanel
extends RmaJPanel
implements ButtonCmdPanelListener {
    protected JPanel _topPanel;
    protected JPanel _distributionPanel;
    private JPanel _fittingMethodsPanel;
    private JPanel _plotTypesPanel;
    private JPanel _buttonsPanel;
    private ButtonCmdPanel _cmdPanel = new ButtonCmdPanel(8);
    protected RmaJDecimalField _histMinField;
    protected RmaJDecimalField _histMaxField;
    protected RmaJSpinner _binsField;
    private SpinnerNumberModel _spinnerModel;
    protected HistogramChart _histChart;
    private RmaJRadioButton _rdbtnCDF;
    private RmaJRadioButton _rdbtnPDF;
    private RmaJRadioButton _rdbtnPP;
    private RmaJRadioButton _rdbtnQQ;
    private RmaJRadioButton _rdbtnSPMoments;
    private RmaJRadioButton _rdbtnLMoments;
    protected RmaJComboBox _binsComboBox;
    private RmaJComboBox _distributionType;
    protected RmaJCheckBox _histogramMinimumCB;
    protected RmaJCheckBox _histogramMaximumCB;
    private RmaJCheckBox _displayDistributionFittingCB;
    private RmaJButton _autoZoomButton;
    private RmaJButton _resetButton;
    private ButtonGroup _plotTypesBG = new ButtonGroup();
    private ButtonGroup _fittingMethodsBG = new ButtonGroup();
    private List<DataContainer> _containers;
    String title = null;
    private static final int WINDOW_WIDTH = 400;
    private static final int WINDOW_HEIGHT = 400;
    protected Histogram _hist;
    private boolean _displayDistributionFittingPanel = true;
    private int _histogramType = 1;
    private int _binType = 0;
    private int _nbinsDefault = 20;
    private double _binSizeDefault = 1.0;
    protected int _nbins = this._nbinsDefault;
    protected double _binSize = this._binSizeDefault;
    private static final double UNDEFINED_DOUBLE = -3.4028234663852886E38;
    protected double _Xmin = -3.4028234663852886E38;
    protected double _Xmax = -3.4028234663852886E38;
    private int _nbinsMin;
    private int _nbinsMax;
    private int _nbinsStep;
    private double _binSizeMin;
    private double _binSizeMax;
    private double _binSizeStep;
    private List<HistogramChart> _histChartList;
    private ArrayList<Histogram> _histList;

    public HistogramOptionsPanel(Frame parent, boolean modal, HistogramChart histogramChart, List<DataContainer> containers) {
        this._histChart = histogramChart;
        this._containers = containers;
        this.buildControls();
        this.addListeners();
        this.fillPanel(this._histChart, this._containers);
    }

    public HistogramOptionsPanel(Frame parent, boolean modal, List<HistogramChart> histogramChartList, List<DataContainer> containers) {
        this._histChartList = histogramChartList;
        this._histChart = histogramChartList.get(0);
        this._containers = containers;
        this.buildControls();
        this.addListenersList();
        this.fillPanelWithList(this._histChartList, this._containers);
    }

    public HistogramOptionsPanel(Frame parent, boolean modal, List<HistogramChart> histogramChartList, List<DataContainer> containers, boolean displayDistributionFittingPanel) {
        this._histChartList = histogramChartList;
        this._containers = containers;
        this._displayDistributionFittingPanel = displayDistributionFittingPanel;
        this.buildControls();
        this.addListenersList();
        this.fillPanelWithList(this._histChartList, this._containers);
    }

    public HistogramOptionsPanel(Frame parent, boolean modal, HistogramChart histogramChart, List<DataContainer> containers, boolean displayDistributionFittingPanel) {
        this._histChart = histogramChart;
        this._containers = containers;
        this._displayDistributionFittingPanel = displayDistributionFittingPanel;
        this.buildControls();
        this.addListeners();
        this.fillPanel(this._histChart, this._containers);
    }

    private void buildControls() {
        this.title = "Advanced Histogram Options";
        this.setLayout(new GridBagLayout());
        this._topPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this._topPanel, gbc);
        this.buildTopPanel();
        if (this._displayDistributionFittingPanel) {
            this._distributionPanel = new JPanel(new GridBagLayout());
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(5, 5, 5, 0);
            this.add((Component)this._distributionPanel, gbc);
            this.buildDistributionFittingPanel();
        }
        this._buttonsPanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.insets = new Insets(5, 5, 5, 0);
        this.add((Component)this._buttonsPanel, gbc);
        this._autoZoomButton = new RmaJButton("AutoZoom");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = new Insets(5, 5, 5, 5);
        this._buttonsPanel.add((Component)this._autoZoomButton, gbc);
        this._resetButton = new RmaJButton("Reset");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = new Insets(5, 5, 5, 5);
        this._buttonsPanel.add(this._resetButton);
    }

    protected void buildTopPanel() {
        this._binsComboBox = new RmaJComboBox();
        this._binsComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Number Of Bins", "Bin Size"}));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 11;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5555;
        this._topPanel.add((Component)this._binsComboBox, gbc);
        this._binsField = new RmaJSpinner();
        if (this._histChart != null) {
            this._binsField.setValue(this._histChart.getNumBins());
        }
        gbc = new GridBagConstraints();
        gbc.anchor = 11;
        gbc.fill = 2;
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(5, 5, 5, 0);
        this._topPanel.add((Component)this._binsField, gbc);
        this._histogramMinimumCB = new RmaJCheckBox("Histogram Minimum");
        gbc = new GridBagConstraints();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = new Insets(5, 10, 5, 5);
        this._topPanel.add((Component)this._histogramMinimumCB, gbc);
        this._histMinField = new RmaJDecimalField();
        this._histMinField.setColumns(4);
        gbc = new GridBagConstraints();
        gbc.anchor = 11;
        gbc.fill = 2;
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(5, 5, 5, 0);
        this._topPanel.add((Component)this._histMinField, gbc);
        this._histogramMaximumCB = new RmaJCheckBox("Histogram Maximum");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = new Insets(5, 10, 0, 5);
        this._topPanel.add((Component)this._histogramMaximumCB, gbc);
        this._histMaxField = new RmaJDecimalField();
        this._histMaxField.setColumns(4);
        gbc = new GridBagConstraints();
        gbc.anchor = 11;
        gbc.fill = 2;
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(5, 5, 0, 0);
        this._topPanel.add((Component)this._histMaxField, gbc);
    }

    protected void buildDistributionFittingPanel() {
        this._distributionPanel.setBorder(new TitledBorder(null, "Distribution Fitting", 4, 2, null, null));
        this._displayDistributionFittingCB = new RmaJCheckBox();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = new Insets(5, 5, 5, 5);
        this._distributionPanel.add((Component)this._displayDistributionFittingCB, gbc);
        this._distributionType = new RmaJComboBox<DistributionTypes>(DistributionTypes.values());
        this._distributionType.setMaximumRowCount(16);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = new Insets(5, 5, 5, 5);
        this._distributionPanel.add((Component)this._distributionType, gbc);
        this._fittingMethodsPanel = new JPanel(new GridBagLayout());
        this._fittingMethodsPanel.setBorder(new TitledBorder(null, "Fitting Methods", 4, 2, null, null));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = new Insets(5, 30, 5, 5);
        this._distributionPanel.add((Component)this._fittingMethodsPanel, gbc);
        this._plotTypesPanel = new JPanel();
        this._plotTypesPanel.setBorder(new TitledBorder(null, "Plot Types", 4, 2, null, null));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = new Insets(5, 45, 5, 5);
        this._distributionPanel.add((Component)this._plotTypesPanel, gbc);
        this._rdbtnCDF = new RmaJRadioButton("CDF");
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.insets = new Insets(0, 0, 0, 5);
        gbc.gridx = 0;
        gbc.gridy = 0;
        this._plotTypesPanel.add((Component)this._rdbtnCDF, gbc);
        this._plotTypesBG.add(this._rdbtnCDF);
        this._rdbtnPDF = new RmaJRadioButton("PDF");
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.insets = new Insets(0, 0, 0, 5);
        gbc.gridx = 1;
        gbc.gridy = 0;
        this._plotTypesPanel.add((Component)this._rdbtnPDF, gbc);
        this._plotTypesBG.add(this._rdbtnPDF);
        this._rdbtnPP = new RmaJRadioButton("PP");
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.insets = new Insets(0, 0, 0, 5);
        gbc.gridx = 2;
        gbc.gridy = 0;
        this._plotTypesPanel.add((Component)this._rdbtnPP, gbc);
        this._plotTypesBG.add(this._rdbtnPP);
        this._rdbtnQQ = new RmaJRadioButton("QQ");
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.gridx = 3;
        gbc.gridy = 0;
        this._plotTypesPanel.add((Component)this._rdbtnQQ, gbc);
        this._plotTypesBG.add(this._rdbtnQQ);
        this._rdbtnSPMoments = new RmaJRadioButton("Standard Product Moments");
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.insets = new Insets(0, 0, 0, 5);
        gbc.gridx = 0;
        gbc.gridy = 0;
        this._fittingMethodsPanel.add((Component)this._rdbtnSPMoments, gbc);
        this._fittingMethodsBG.add(this._rdbtnSPMoments);
        this._rdbtnLMoments = new RmaJRadioButton("Linear Moments");
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.gridx = 1;
        gbc.gridy = 0;
        this._fittingMethodsPanel.add((Component)this._rdbtnLMoments, gbc);
        this._fittingMethodsBG.add(this._rdbtnLMoments);
    }

    public void fillPanel(HistogramChart histChart, List<DataContainer> containers) {
        this._histChart = histChart;
        this._containers = containers;
        if (this._hist.length() < 1) {
            return;
        }
        if (this._hist.length() < this._nbinsDefault || this._hist.length() < this._histChart.getNumBins()) {
            this._histChart.setNumBins(this._hist.length());
        }
        if (this._histMinField.getText() == null || this._histMinField.getText().isEmpty() || this._histMinField.getText().length() < 1) {
            this._histogramMinimumCB.setSelected(false);
            this._Xmin = -3.4028234663852886E38;
            this._histMinField.setEnabled(false);
            this._histMinField.setText(RMAIO.setPrecision2(this._hist.min(), 0));
        }
        if (this._histMaxField.getText() == null || this._histMaxField.getText().isEmpty() || this._histMaxField.getText().length() < 1) {
            this._histogramMaximumCB.setSelected(false);
            this._Xmax = -3.4028234663852886E38;
            this._histMaxField.setEnabled(false);
            this._histMaxField.setText(RMAIO.setPrecision2(this._hist.max(), 0));
        }
        this.updateHistChart();
    }

    public void fillPanelWithList(List<HistogramChart> histChartList, List<DataContainer> containers) {
        this._histChartList = histChartList;
        this._containers = containers;
        if (this._hist.length() < 1) {
            return;
        }
        if (this._hist.length() < this._nbinsDefault || this._hist.length() < this._histChart.getNumBins()) {
            for (HistogramChart histChart : this._histChartList) {
                histChart.setNumBins(this._hist.length());
            }
        }
        if (this._histMinField.getText() == null || this._histMinField.getText().isEmpty() || this._histMinField.getText().length() < 1) {
            this._histogramMinimumCB.setSelected(false);
            this._Xmin = -3.4028234663852886E38;
            this._histMinField.setEnabled(false);
            this._histMinField.setText(RMAIO.setPrecision2(this._hist.min(), 0));
        }
        if (this._histMaxField.getText() == null || this._histMaxField.getText().isEmpty() || this._histMaxField.getText().length() < 1) {
            this._histogramMaximumCB.setSelected(false);
            this._Xmax = -3.4028234663852886E38;
            this._histMaxField.setEnabled(false);
            this._histMaxField.setText(RMAIO.setPrecision2(this._hist.max(), 0));
        }
        this.updateHistChart();
    }

    public boolean savePanel() {
        return true;
    }

    private void addListenersList() {
        if (this._histChartList == null) {
            return;
        }
        for (HistogramChart histChart : this._histChartList) {
            histChart.init(this._containers, this._histogramType, this._binType);
        }
        this._histList = new ArrayList();
        for (HistogramChart histChart : this._histChartList) {
            histChart.plot();
            this._histList.add(histChart.getHistogram());
        }
        this._histChart = this._histChartList.get(0);
        if (this._histChart == null) {
            return;
        }
        this._hist = this._histChart.getHistogram();
        this._histogramMinimumCB.addActionListener(evt -> {
            if (this._histogramMinimumCB.isSelected()) {
                this._histMinField.setEnabled(true);
                this.histMinFieldActionList();
            } else {
                this._histMinField.setEnabled(false);
                this._Xmin = Double.NEGATIVE_INFINITY;
                this.histMinFieldActionList();
            }
        });
        this._histogramMaximumCB.addActionListener(evt -> {
            if (this._histogramMaximumCB.isSelected()) {
                this._histMaxField.setEnabled(true);
                this.histMaxFieldActionList();
            } else {
                this._histMaxField.setEnabled(false);
                this._Xmax = -3.4028234663852886E38;
                this.histMaxFieldActionList();
            }
        });
        this._histMinField.addActionListener(evt -> this.histMinFieldActionList());
        this._histMinField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                HistogramOptionsPanel.this.histMinFieldActionList();
            }

            @Override
            public void focusLost(FocusEvent e) {
                HistogramOptionsPanel.this.histMinFieldActionList();
            }
        });
        this._histMaxField.addActionListener(evt -> this.histMaxFieldActionList());
        this._histMaxField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                HistogramOptionsPanel.this.histMaxFieldActionList();
            }

            @Override
            public void focusLost(FocusEvent e) {
                HistogramOptionsPanel.this.histMaxFieldActionList();
            }
        });
        this._autoZoomButton.addActionListener(arg0 -> {
            for (HistogramChart histChart : this._histChartList) {
                histChart.zoomToAll();
            }
        });
        this._resetButton.addActionListener(arg0 -> this.reset());
        this._binsField.addChangeListener(arg0 -> this.binsFieldActionList());
        this._binsField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent evt) {
                HistogramOptionsPanel.this.binsFieldActionList();
            }

            @Override
            public void focusLost(FocusEvent evt) {
                HistogramOptionsPanel.this.binsFieldActionList();
            }
        });
        this._binsField.addMouseWheelListener(mwe -> {
            if (mwe.getScrollType() != 0) {
                return;
            }
            if (this._binsComboBox.getSelectedItem().equals("Number Of Bins")) {
                int value1 = (Integer)this._binsField.getValue();
                this._binsField.setValue(value1 -= mwe.getUnitsToScroll());
            } else {
                double value2 = (Double)this._binsField.getValue();
                this._binsField.setValue(value2 -= (double)mwe.getUnitsToScroll());
            }
        });
        this._binsComboBox.setSelectedIndex(0);
        this._binsComboBox.addActionListener(evt -> {
            if (this._binsComboBox.getSelectedItem().equals("Number Of Bins")) {
                this._binType = 0;
                this._nbins = this._histChart.getHistogram().getNumBins();
                this._binsField.setValue(this._nbins);
            } else if (this._binsComboBox.getSelectedItem().equals("Bin Size")) {
                this._binType = 1;
                this._binSize = this._histChart.getHistogram().getBinSize();
                this._binsField.setValue(this._binSize);
            } else {
                this._binType = 0;
                this._nbins = this._histChart.getHistogram().getNumBins();
                this._binsField.setValue(this._nbins);
            }
            this.binsFieldActionList();
        });
        if (this._histChart != null) {
            this._nbins = this._histChart.getNumBins();
        }
        if (this._binsComboBox.getSelectedItem().equals("Number Of Bins")) {
            this._binsField.setValue(this._nbins);
            this._nbins = this._histChart.getNumBins();
            this._nbinsMin = 1;
            this._nbinsMax = 1000000;
            this._nbinsStep = this._nbins / 10;
            if (this._nbinsStep < 1) {
                this._nbinsStep = 1;
            }
            if (this._nbins == 0) {
                this._nbins = 1;
            }
            this._spinnerModel = new SpinnerNumberModel(new Integer(this._nbins), new Integer(this._nbinsMin), new Integer(this._nbinsMax), new Integer(this._nbinsStep));
        } else {
            this._binsField.setValue(this._binSize);
            this._binSize = this._histChart.getNumBins();
            this._binSizeMin = 1.0E-4;
            this._binSizeMax = 1000000.0;
            this._binSizeStep = this._binSize / 10.0;
            this._spinnerModel = new SpinnerNumberModel(new Double(this._binSize), new Double(this._binSizeMin), new Double(this._binSizeMax), new Double(this._binSizeStep));
        }
        this._binsField.setModel(this._spinnerModel);
        this._histChart.requestFocusInWindow();
    }

    private void addListeners() {
        if (this._histChart == null) {
            return;
        }
        this._histChart.init(this._containers, this._histogramType, this._binType);
        this._histChart.plot();
        this._hist = this._histChart.getHistogram();
        this._histogramMinimumCB.addActionListener(evt -> {
            if (this._histogramMinimumCB.isSelected()) {
                this._histMinField.setEnabled(true);
                this.histMinFieldAction();
                this.updateHistChart();
            } else {
                this._histMinField.setEnabled(false);
                this._histMinField.setText(RMAIO.setPrecision2(this._hist.min(), 0));
                this._Xmin = Double.NEGATIVE_INFINITY;
                this.histMinFieldAction();
                this.updateHistChart();
            }
        });
        this._histogramMaximumCB.addActionListener(evt -> {
            if (this._histogramMaximumCB.isSelected()) {
                this._histMaxField.setEnabled(true);
                this.histMaxFieldAction();
                this.updateHistChart();
            } else {
                this._histMaxField.setEnabled(false);
                this._histMaxField.setText(RMAIO.setPrecision2(this._hist.max(), 0));
                this._Xmax = -3.4028234663852886E38;
                this.histMaxFieldAction();
                this.updateHistChart();
            }
        });
        this._histMinField.addActionListener(evt -> this.histMinFieldAction());
        this._histMinField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                HistogramOptionsPanel.this.histMinFieldAction();
            }

            @Override
            public void focusLost(FocusEvent e) {
                HistogramOptionsPanel.this.histMinFieldAction();
            }
        });
        this._histMaxField.addActionListener(evt -> this.histMaxFieldAction());
        this._histMaxField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                HistogramOptionsPanel.this.histMaxFieldAction();
            }

            @Override
            public void focusLost(FocusEvent e) {
                HistogramOptionsPanel.this.histMaxFieldAction();
            }
        });
        this._autoZoomButton.addActionListener(arg0 -> this._histChart.zoomToAll());
        this._resetButton.addActionListener(arg0 -> this.reset());
        this._binsField.addChangeListener(arg0 -> this.binsFieldAction());
        this._binsField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent evt) {
                HistogramOptionsPanel.this.binsFieldAction();
            }

            @Override
            public void focusLost(FocusEvent evt) {
                HistogramOptionsPanel.this.binsFieldAction();
            }
        });
        this._binsField.addMouseWheelListener(mwe -> {
            if (mwe.getScrollType() != 0) {
                return;
            }
            if (this._binsComboBox.getSelectedItem().equals("Number Of Bins")) {
                int value1 = (Integer)this._binsField.getValue();
                this._binsField.setValue(value1 -= mwe.getUnitsToScroll());
            } else {
                double value2 = (Double)this._binsField.getValue();
                this._binsField.setValue(value2 -= (double)mwe.getUnitsToScroll());
            }
        });
        this._binsComboBox.setSelectedIndex(0);
        this._binsComboBox.addActionListener(evt -> {
            if (this._binsComboBox.getSelectedItem().equals("Number Of Bins")) {
                this._binType = 0;
                this._nbins = this._histChart.getHistogram().getNumBins();
                this._binsField.setValue(this._nbins);
            } else if (this._binsComboBox.getSelectedItem().equals("Bin Size")) {
                this._binType = 1;
                this._binSize = this._histChart.getHistogram().getBinSize();
                this._binsField.setValue(this._binSize);
            } else {
                this._binType = 0;
                this._nbins = this._histChart.getHistogram().getNumBins();
                this._binsField.setValue(this._nbins);
            }
            this.binsFieldAction();
        });
        if (this._binsComboBox.getSelectedItem().equals("Number Of Bins")) {
            this._binsField.setValue(this._nbins);
            this._nbins = this._histChart.getNumBins();
            this._nbinsMin = 1;
            this._nbinsMax = 1000000;
            this._nbinsStep = this._nbins / 10;
            if (this._nbinsStep < 1) {
                this._nbinsStep = 1;
            }
            this._spinnerModel = new SpinnerNumberModel(new Integer(this._nbins), new Integer(this._nbinsMin), new Integer(this._nbinsMax), new Integer(this._nbinsStep));
        } else {
            this._binsField.setValue(this._binSize);
            this._binSize = this._histChart.getNumBins();
            this._binSizeMin = 1.0E-4;
            this._binSizeMax = 1000000.0;
            this._binSizeStep = this._binSize / 10.0;
            this._spinnerModel = new SpinnerNumberModel(new Double(this._binSize), new Double(this._binSizeMin), new Double(this._binSizeMax), new Double(this._binSizeStep));
        }
        this._binsField.setModel(this._spinnerModel);
        this._histChart.requestFocusInWindow();
    }

    protected void binsFieldAction() {
        Object binsFieldValue = this._binsField.getValue();
        if (this._binType == 0) {
            this._nbins = binsFieldValue instanceof Integer ? ((Integer)binsFieldValue).intValue() : ((Double)binsFieldValue).intValue();
            if (this._nbins < 1) {
                this._nbins = 1;
            }
            this._histChart.setNumBins(this._nbins);
            this._nbinsMin = 1;
            this._nbinsMax = 1000000;
            this._nbinsStep = this._nbins / 10;
            if (this._nbinsStep < 1) {
                this._nbinsStep = 1;
            }
            this._spinnerModel = new SpinnerNumberModel(new Integer(this._nbins), new Integer(this._nbinsMin), new Integer(this._nbinsMax), new Integer(this._nbinsStep));
            this._binsField.setModel(this._spinnerModel);
            this._binsField.setValue(new Integer(this._nbins));
        } else if (this._binType == 1) {
            this._binSize = binsFieldValue instanceof Double ? ((Double)binsFieldValue).doubleValue() : ((Integer)binsFieldValue).doubleValue();
            this._histChart.setBinSize(this._binSize);
            this._binSizeMin = 1.0E-4;
            this._binSizeMax = 1000000.0;
            this._binSizeStep = this._binSize / 10.0;
            this._spinnerModel = new SpinnerNumberModel(new Double(this._binSize), new Double(this._binSizeMin), new Double(this._binSizeMax), new Double(this._binSizeStep));
            this._binsField.setValue(new Double(this._binSize));
            this._binsField.setModel(this._spinnerModel);
        }
        this._histChart.setBinType(this._binType);
        this.updateHistChart();
    }

    protected void binsFieldActionList() {
        Object binsFieldValue = this._binsField.getValue();
        if (this._binType == 0) {
            this._nbins = binsFieldValue instanceof Integer ? ((Integer)binsFieldValue).intValue() : ((Double)binsFieldValue).intValue();
            if (this._nbins < 1) {
                this._nbins = 1;
            }
            for (HistogramChart histChart : this._histChartList) {
                histChart.setNumBins(this._nbins);
            }
            this._nbinsMin = 1;
            this._nbinsMax = 1000000;
            this._nbinsStep = this._nbins / 10;
            if (this._nbinsStep < 1) {
                this._nbinsStep = 1;
            }
            this._spinnerModel = new SpinnerNumberModel(new Integer(this._nbins), new Integer(this._nbinsMin), new Integer(this._nbinsMax), new Integer(this._nbinsStep));
            this._binsField.setModel(this._spinnerModel);
            this._binsField.setValue(new Integer(this._nbins));
        } else if (this._binType == 1) {
            this._binSize = binsFieldValue instanceof Double ? ((Double)binsFieldValue).doubleValue() : ((Integer)binsFieldValue).doubleValue();
            for (HistogramChart histChart : this._histChartList) {
                histChart.setBinSize(this._binSize);
            }
            this._binSizeMin = 1.0E-4;
            this._binSizeMax = 1000000.0;
            this._binSizeStep = this._binSize / 10.0;
            this._spinnerModel = new SpinnerNumberModel(new Double(this._binSize), new Double(this._binSizeMin), new Double(this._binSizeMax), new Double(this._binSizeStep));
            this._binsField.setValue(new Double(this._binSize));
            this._binsField.setModel(this._spinnerModel);
        }
        for (HistogramChart histChart : this._histChartList) {
            histChart.setBinType(this._binType);
        }
    }

    protected void activateDistributionFitting(Boolean activate) {
        this._distributionType.setEnabled(activate);
        if (activate.booleanValue()) {
            this._distributionType.setSelectedIndex(0);
        } else {
            this._distributionType.setSelectedIndex(-1);
        }
        this._rdbtnSPMoments.setEnabled(activate);
        this._rdbtnLMoments.setEnabled(activate);
        this._rdbtnSPMoments.setSelected(true);
        this._rdbtnCDF.setEnabled(activate);
        this._rdbtnPDF.setEnabled(activate);
        this._rdbtnPP.setEnabled(activate);
        this._rdbtnQQ.setEnabled(activate);
        this._rdbtnPDF.setSelected(true);
    }

    public void histMinFieldAction() {
        this._Xmin = !this._histMinField.getText().equalsIgnoreCase("") ? Double.parseDouble(this._histMinField.getText()) : -3.4028234663852886E38;
        for (HistogramChart chart : this._histChartList) {
            chart.setXmin(this._Xmin);
        }
    }

    public void histMinFieldActionList() {
        this._Xmin = !this._histMinField.getText().equalsIgnoreCase("") ? Double.parseDouble(this._histMinField.getText()) : -3.4028234663852886E38;
        for (HistogramChart histChart : this._histChartList) {
            histChart.setXmin(this._Xmin);
        }
    }

    public void histMaxFieldAction() {
        this._Xmax = !this._histMaxField.getText().equalsIgnoreCase("") ? Double.parseDouble(this._histMaxField.getText()) : -3.4028234663852886E38;
        for (HistogramChart chart : this._histChartList) {
            chart.setXmax(this._Xmax);
        }
    }

    public void histMaxFieldActionList() {
        this._Xmax = !this._histMaxField.getText().equalsIgnoreCase("") ? Double.parseDouble(this._histMaxField.getText()) : -3.4028234663852886E38;
        for (HistogramChart histChart : this._histChartList) {
            histChart.setXmax(this._Xmax);
        }
    }

    private void updateHistChart() {
        this._histChart.update();
        this._nbins = this._histChart.getNumBins();
        this._binSize = this._histChart.getBinSize();
        this._hist = this._histChart.getHistogram();
        if (this._binsComboBox.getSelectedItem().equals("Number Of Bins")) {
            this._binsField.setValue(new Integer(this._nbins));
        } else if (this._binsComboBox.getSelectedItem().equals("Bin Size")) {
            this._binsField.setValue(new Double(this._binSize));
        } else {
            this._binsField.setValue(this._nbins);
        }
        this._histChart.setVisible(true);
    }

    private void updateHistChartList() {
        for (HistogramChart histChart : this._histChartList) {
            histChart.update();
            this._nbins = this._histChartList.get(0).getNumBins();
            this._binSize = this._histChartList.get(0).getBinSize();
            this._hist = this._histChartList.get(0).getHistogram();
        }
        if (this._binsComboBox.getSelectedItem().equals("Number Of Bins")) {
            this._binsField.setValue(new Integer(this._nbins));
        } else if (this._binsComboBox.getSelectedItem().equals("Bin Size")) {
            this._binsField.setValue(new Double(this._binSize));
        } else {
            this._binsField.setValue(this._nbins);
        }
        for (HistogramChart histChart : this._histChartList) {
            histChart.setVisible(true);
        }
    }

    private void reset() {
        this._histogramType = 1;
        this._binType = 0;
        this._histogramMinimumCB.setSelected(false);
        this._histogramMaximumCB.setSelected(false);
        this._histChart.setNumBins(this._hist.length() < this._nbinsDefault ? this._hist.length() : this._nbinsDefault);
        this._histChart.setHistogramType(this._histogramType);
        this._histChart.setBinType(this._binType);
        this._binsComboBox.setSelectedItem("Number Of Bins");
        this._binsField.setValue(this._histChart.getNumBins());
        this._Xmin = -3.4028234663852886E38;
        this._Xmax = -3.4028234663852886E38;
        this._histMinField.setEnabled(false);
        this._histMinField.setText(RMAIO.setPrecision2(this._hist.min(), 0));
        this._histMaxField.setEnabled(false);
        this._histMaxField.setText(RMAIO.setPrecision2(this._hist.max(), 0));
        this.histMinFieldAction();
        this.histMaxFieldAction();
    }

    @Override
    public void buttonCmdActionPerformed(ActionEvent e) {
        if (e.getID() == 8) {
            this.savePanel();
            this.setVisible(false);
        } else if (e.getID() == 4) {
            this.setModified(false);
            this.setVisible(false);
        }
    }

    public int getNumberOfBins() {
        return this._nbins;
    }

    public double getHistMin() {
        return this._Xmin;
    }

    public double getHistMax() {
        return this._Xmax;
    }

    public boolean getUseMinimumCheckbox() {
        return this._histogramMinimumCB.isSelected();
    }

    public void setUseMinimumCheckbox(boolean use) {
        this._histogramMinimumCB.setSelected(use);
        this._histMinField.setEnabled(use);
    }

    public boolean getUseMaximumCheckBox() {
        return this._histogramMaximumCB.isSelected();
    }

    public void setUseMaximumCheckBox(boolean use) {
        this._histogramMaximumCB.setSelected(use);
        this._histMaxField.setEnabled(use);
    }

    public double getMinimumValue() {
        return Double.parseDouble(this._histMinField.getText());
    }

    public void setMinimumValue(double d) {
        if (d < 0.0) {
            return;
        }
        this._histMinField.setValue(d);
    }

    public double getMaximumValue() {
        return Double.parseDouble(this._histMaxField.getText());
    }

    public void setMaximumValue(double d) {
        if (d < 0.0) {
            return;
        }
        this._histMaxField.setValue(d);
    }

    public void hideButtons() {
        this._autoZoomButton.setVisible(false);
        this._resetButton.setVisible(false);
    }
}

