/*
 * Decompiled with CFR 0.152.
 */
package hec.chart;

import hec.chart.ColorPanel;
import hec.chart.ColorWheel;
import hec.chart.DistributionPlotTypes;
import hec.chart.Histogram;
import hec.chart.HistogramChart;
import hec.chart.PrintPreview;
import hec.chart.SaveAsDialog;
import hec.statistics.DistributionTypes;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.print.Printable;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.editor.ChartEditor;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJFrame;
import rma.util.PrintUtilities;

public class HistogramPlotDialog
extends RmaJFrame {
    private JCheckBox _histMinCheckBox;
    private JCheckBox _histMaxCheckBox;
    private JComboBox _binComboBox;
    private RmaJDecimalField _histMinField;
    private RmaJDecimalField _histMaxField;
    protected HistogramChart _histChart;
    protected Histogram _hist;
    private JTextPane _statsPane;
    private ChartEditor _chartPropertiesEditor;
    protected int _histogramType = 1;
    protected int _binType = 0;
    private int _nbinsDefault = 20;
    private double _binSizeDefault = 1.0;
    private int _nbins = this._nbinsDefault;
    private double _binSize = this._binSizeDefault;
    private static final double UNDEFINED_DOUBLE = -3.4028234663852886E38;
    private double _Xmin = -3.4028234663852886E38;
    private double _Xmax = -3.4028234663852886E38;
    protected boolean chartCreated = false;
    private Color _seriesColor;
    private JFrame _colorFrame;
    private JPanel _colorPanel;
    private JColorChooser _colorChooser;
    protected JMenuBar _menuBar = new JMenuBar();
    private JMenu _fileMenu = new JMenu("File");
    private JMenu _viewMenu = new JMenu("View");
    private JMenu _editMenu = new JMenu("Edit");
    protected JMenu _helpMenu = new JMenu("Help");
    private ColorWheel cw;
    private ColorPanel cp;
    private SpinnerNumberModel _spinnerModel;
    private int _nbinsMin;
    private int _nbinsMax;
    private int _nbinsStep;
    private JSpinner _binsField;
    private double _binSizeMin;
    private double _binSizeMax;
    private double _binSizeStep;
    private final ButtonGroup plotTypesButtonGroup = new ButtonGroup();
    private final ButtonGroup fittingTypesButtonGroup = new ButtonGroup();
    private JCheckBox _distributionFittingCheckBox;
    private JComboBox distributionType;
    private JRadioButton rdbtnCDF;
    private JRadioButton rdbtnPDF;
    private JRadioButton rdbtnPP;
    private JRadioButton rdbtnQQ;
    private JRadioButton _rdbtnStandardProductMoments;
    private JRadioButton _rdbtnLmoments;
    private boolean _displayDistributionFittingPanel = true;
    protected DistributionPlotTypes _distributionPlotType;

    public HistogramPlotDialog(List Containers) {
        this.setTitle("Histogram Plotting Tool");
        this.setDefaultCloseOperation(2);
        this.updateData(Containers);
    }

    public HistogramPlotDialog(List Containers, boolean displayDistributionFittingPanel) {
        this.setTitle("Histogram Plotting Tool");
        this.setDefaultCloseOperation(2);
        this._displayDistributionFittingPanel = displayDistributionFittingPanel;
        this.updateData(Containers);
    }

    public HistogramPlotDialog(List Containers, DistributionPlotTypes distributionPlotType) {
        this.setTitle("Histogram Plotting Tool");
        this.setDefaultCloseOperation(2);
        this.setDistributionPlotType(distributionPlotType);
        this.updateData(Containers);
    }

    public HistogramPlotDialog(List Containers, DistributionPlotTypes distributionPlotType, boolean displayDistributionFittingPanel) {
        this.setTitle("Histogram Plotting Tool");
        this.setDefaultCloseOperation(2);
        this.setDistributionPlotType(distributionPlotType);
        this._displayDistributionFittingPanel = displayDistributionFittingPanel;
        this.updateData(Containers);
    }

    public HistogramPlotDialog(HistogramChart histogramChart, List Containers) {
        this.setTitle("Histogram Plotting Tool");
        this.setDefaultCloseOperation(2);
        this.setHistChart(histogramChart);
        this.updateData(Containers);
    }

    public HistogramPlotDialog(HistogramChart histogramChart, List Containers, boolean displayDistributionFittingPanel) {
        this.setTitle("Histogram Plotting Tool");
        this.setDefaultCloseOperation(2);
        this.setHistChart(histogramChart);
        this._displayDistributionFittingPanel = displayDistributionFittingPanel;
        this.updateData(Containers);
    }

    public void updateData(List Containers) {
        if (this._histChart == null) {
            this._histChart = new HistogramChart(Containers, this._histogramType, this._binType);
            this.chartCreated = false;
        } else {
            this._histChart.init(Containers, this._histogramType, this._binType);
        }
        this._histChart.plot();
        this._hist = this._histChart.getHistogram();
        if (!this.chartCreated) {
            this.initComponents();
            JMenu _seriesMenu = new JMenu("Series");
            JMenuItem _seriesColorItem = new JMenuItem("Color Selector");
            JMenuItem _colorWheelItem = new JMenuItem("Color Wheel");
            _seriesMenu.add(_seriesColorItem);
            _seriesMenu.add(_colorWheelItem);
            this._menuBar.add(_seriesMenu);
            this._menuBar.add(this._helpMenu);
            _seriesColorItem.addActionListener(evt -> this.colorChooser());
            _colorWheelItem.addActionListener(evt -> this.colorWheelChooser());
        }
        this.updateHistChart();
        this.pack();
        this.setVisible(true);
        this.chartCreated = true;
        this.reset();
    }

    public void setSeriesColor(Color c2) {
        this._seriesColor = c2;
    }

    public Color getSeriesColor() {
        return this._seriesColor;
    }

    public void colorChooser() {
        this._colorFrame = new JFrame();
        this._colorPanel = new JPanel();
        this._colorChooser = new JColorChooser();
        this._colorChooser.setColor(this._seriesColor);
        this._colorChooser.getSelectionModel().addChangeListener(arg0 -> {
            this.setSeriesColor(this._colorChooser.getColor());
            this._histChart.setSeriesColor();
        });
        this._colorPanel.add(this._colorChooser);
        this._colorFrame.getContentPane().add(this._colorPanel);
        this._colorFrame.pack();
        this._colorFrame.setVisible(true);
    }

    public void colorWheelChooser() {
        this.cw = new ColorWheel();
        this.cw.init();
        this.cp = this.cw.getColorPanel();
        this.setSeriesColor(this.cp.getSelectedColor());
        this.cp.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                HistogramPlotDialog.this.setSeriesColor(HistogramPlotDialog.this.cp.getSelectedColor());
                HistogramPlotDialog.this._histChart.setSeriesColor();
                if (HistogramPlotDialog.this._colorChooser != null) {
                    HistogramPlotDialog.this._colorChooser.setColor(HistogramPlotDialog.this._seriesColor);
                }
            }
        });
        this.cp.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                HistogramPlotDialog.this.setSeriesColor(HistogramPlotDialog.this.cp.getSelectedColor());
                HistogramPlotDialog.this._histChart.setSeriesColor();
                if (HistogramPlotDialog.this._colorChooser != null) {
                    HistogramPlotDialog.this._colorChooser.setColor(HistogramPlotDialog.this._seriesColor);
                }
            }
        });
    }

    private void initComponents() {
        JPanel _mainPanel = new JPanel();
        JPanel _optionsPanel = new JPanel();
        JButton _resetButton = new JButton();
        JPanel _bottomPanel = new JPanel();
        JMenuItem _saveAsMenuItem = new JMenuItem("Save As...");
        JMenuItem _printPreviewMenuItem = new JMenuItem("Print Preview");
        JMenuItem _printMenuItem = new JMenuItem("Print");
        JMenuItem _closeMenuItem = new JMenuItem("Close");
        JMenuItem _propertiesMenuItem = new JMenuItem("Properties");
        JMenuItem _aboutMenuItem = new JMenuItem("About");
        JMenuItem _viewStatsMenuItem = new JMenuItem("Summary Statistics");
        _mainPanel.setMinimumSize(new Dimension(0, 0));
        _mainPanel.setName("_mainPanel");
        _optionsPanel.setBorder(BorderFactory.createTitledBorder("Options"));
        _optionsPanel.setName("_optionsPanel");
        GroupLayout histChartLayout = new GroupLayout((Container)((Object)this._histChart));
        histChartLayout.setHorizontalGroup(histChartLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 607, Short.MAX_VALUE));
        histChartLayout.setVerticalGroup(histChartLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 396, Short.MAX_VALUE));
        _bottomPanel.setName("_bottomPanel");
        JSeparator bottomPanelSeparator = new JSeparator();
        bottomPanelSeparator.setName("bottomPanelSeparator");
        _resetButton.setText("Reset");
        _resetButton.setMinimumSize(new Dimension(0, 0));
        _resetButton.setName("_resetButton");
        _resetButton.addActionListener(evt -> this.reset());
        JButton autoZoom = new JButton();
        autoZoom.addActionListener(arg0 -> this._histChart.zoomToAll());
        autoZoom.setText("Auto Zoom");
        autoZoom.setName("_autoZoom");
        autoZoom.setMinimumSize(new Dimension(0, 0));
        GroupLayout bottomPanelLayout = new GroupLayout(_bottomPanel);
        bottomPanelLayout.setHorizontalGroup(bottomPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(bottomPanelLayout.createSequentialGroup().addContainerGap().addComponent(autoZoom, -2, 121, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(_resetButton, -2, 75, -2).addContainerGap(779, Short.MAX_VALUE)).addComponent(bottomPanelSeparator, GroupLayout.Alignment.TRAILING, -1, 991, Short.MAX_VALUE));
        bottomPanelLayout.setVerticalGroup(bottomPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(bottomPanelLayout.createSequentialGroup().addComponent(bottomPanelSeparator, -2, 2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(bottomPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(_resetButton, -2, -1, -2).addComponent(autoZoom, -2, -1, -2)).addContainerGap()));
        _bottomPanel.setLayout(bottomPanelLayout);
        int XX = (int)this._histChart.getPreferredSize().getWidth() + 200;
        int YY = (int)this._histChart.getPreferredSize().getHeight() + 50;
        GroupLayout mainPanelLayout = new GroupLayout(_mainPanel);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(_bottomPanel, GroupLayout.Alignment.TRAILING, -1, 981, Short.MAX_VALUE).addGroup(mainPanelLayout.createSequentialGroup().addComponent(_optionsPanel, -2, 285, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)((Object)this._histChart), -1, 700, Short.MAX_VALUE))).addContainerGap()));
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(_optionsPanel, -1, 633, Short.MAX_VALUE).addComponent((Component)((Object)this._histChart), GroupLayout.Alignment.TRAILING, -1, 633, Short.MAX_VALUE)).addGap(10).addComponent(_bottomPanel, -2, -1, -2).addGap(4)));
        GridBagLayout gbl__optionsPanel = new GridBagLayout();
        gbl__optionsPanel.columnWidths = new int[]{121, 120, 0};
        gbl__optionsPanel.rowHeights = new int[]{20, 24, 24, 207, 23, 0};
        gbl__optionsPanel.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gbl__optionsPanel.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        _optionsPanel.setLayout(gbl__optionsPanel);
        this._histMinCheckBox = new JCheckBox();
        this._histMinCheckBox.setText("Histogram Minimum");
        this._histMinCheckBox.setName("_histMinCheckBox");
        this._histMinCheckBox.setSelected(false);
        this._histMinCheckBox.addActionListener(evt -> {
            if (this._histMinCheckBox.isSelected()) {
                this._histMinField.setEnabled(true);
            } else {
                this._histMinField.setEnabled(false);
                this._histMinField.setValue(this._hist.min());
                this._Xmin = -3.4028234663852886E38;
                this.updateHistChart();
            }
        });
        this._binsField = new JSpinner();
        this._binsField.setName("_binsField");
        this._binsField.setValue(this._histChart.getNumBins());
        this._binsField.addChangeListener(arg0 -> this.binsFieldAction());
        this._binsField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent evt) {
                HistogramPlotDialog.this.binsFieldAction();
            }

            @Override
            public void focusLost(FocusEvent evt) {
                HistogramPlotDialog.this.binsFieldAction();
            }
        });
        this._binComboBox = new JComboBox();
        this._binComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Number of Bins", "Bin Size"}));
        this._binComboBox.setName("_binComboBox");
        this._binComboBox.setSelectedIndex(0);
        this._binComboBox.addActionListener(evt -> {
            if (this._binComboBox.getSelectedItem().equals("Number of Bins")) {
                this._binType = 0;
                this._nbins = this._histChart.getHistogram().getNumBins();
                this._binsField.setValue(this._nbins);
            } else if (this._binComboBox.getSelectedItem().equals("Bin Size")) {
                this._binType = 1;
                this._binSize = this._histChart.getHistogram().getBinSize();
                this._binsField.setValue(this._binSize);
            } else {
                this._binType = 0;
                this._nbins = this._histChart.getHistogram().getNumBins();
                this._binsField.setValue(this._nbins);
            }
            this.binsFieldAction();
        });
        GridBagConstraints gbc__binComboBox = new GridBagConstraints();
        gbc__binComboBox.anchor = 18;
        gbc__binComboBox.insets = new Insets(0, 0, 5, 5);
        gbc__binComboBox.gridx = 0;
        gbc__binComboBox.gridy = 0;
        _optionsPanel.add((Component)this._binComboBox, gbc__binComboBox);
        GridBagConstraints gbc__binsField = new GridBagConstraints();
        gbc__binsField.fill = 2;
        gbc__binsField.anchor = 11;
        gbc__binsField.insets = new Insets(0, 0, 5, 0);
        gbc__binsField.gridx = 1;
        gbc__binsField.gridy = 0;
        _optionsPanel.add((Component)this._binsField, gbc__binsField);
        GridBagConstraints gbc__histMinCheckBox = new GridBagConstraints();
        gbc__histMinCheckBox.anchor = 16;
        gbc__histMinCheckBox.insets = new Insets(0, 0, 5, 5);
        gbc__histMinCheckBox.gridx = 0;
        gbc__histMinCheckBox.gridy = 1;
        _optionsPanel.add((Component)this._histMinCheckBox, gbc__histMinCheckBox);
        if (this._displayDistributionFittingPanel) {
            JPanel panel = new JPanel();
            panel.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "Distribution Fitting:", 4, 2, null, null));
            GridBagLayout gbl_panel = new GridBagLayout();
            gbl_panel.columnWidths = new int[]{21, 142, 6, 0};
            gbl_panel.rowHeights = new int[]{21, 74, 56, 0};
            gbl_panel.columnWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
            gbl_panel.rowWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
            panel.setLayout(gbl_panel);
            this._distributionFittingCheckBox = new JCheckBox();
            this._distributionFittingCheckBox.setVerticalAlignment(1);
            this._distributionFittingCheckBox.addActionListener(arg0 -> this.activateDistributionFitting(this._distributionFittingCheckBox.isSelected()));
            this._distributionFittingCheckBox.setSelected(false);
            this._distributionFittingCheckBox.setName("_histMaxCheckBox");
            GridBagConstraints gbc_checkBox = new GridBagConstraints();
            gbc_checkBox.anchor = 18;
            gbc_checkBox.insets = new Insets(5, 0, 5, 5);
            gbc_checkBox.gridx = 0;
            gbc_checkBox.gridy = 0;
            panel.add((Component)this._distributionFittingCheckBox, gbc_checkBox);
            this.distributionType = new RmaJComboBox<DistributionTypes>(DistributionTypes.values());
            this.distributionType.setAlignmentX(0.0f);
            this.distributionType.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
            this.distributionType.setMaximumRowCount(16);
            GridBagConstraints gbc_distributionType = new GridBagConstraints();
            gbc_distributionType.fill = 2;
            gbc_distributionType.anchor = 11;
            gbc_distributionType.insets = new Insets(5, 0, 5, 0);
            gbc_distributionType.gridwidth = 2;
            gbc_distributionType.gridx = 1;
            gbc_distributionType.gridy = 0;
            panel.add((Component)this.distributionType, gbc_distributionType);
            this.distributionType.addActionListener(arg0 -> {
                this._rdbtnStandardProductMoments.setEnabled(this.distributionType.getSelectedIndex() > -1);
                this._rdbtnLmoments.setEnabled(this.distributionType.getSelectedIndex() > -1);
                this.rdbtnCDF.setEnabled(this.distributionType.getSelectedIndex() > -1);
                this.rdbtnPDF.setEnabled(this.distributionType.getSelectedIndex() > -1);
                this.rdbtnPP.setEnabled(this.distributionType.getSelectedIndex() > -1);
                this.rdbtnQQ.setEnabled(this.distributionType.getSelectedIndex() > -1);
                this.rdbtnPDF.setSelected(this.distributionType.getSelectedIndex() > -1);
                this._histChart.plot();
            });
            this.distributionType.setName("_histogramTypeComboBox");
            this.distributionType.setEnabled(false);
            JPanel panel_3 = new JPanel();
            panel_3.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "Fitting Methods", 4, 2, null, null));
            GridBagConstraints gbc_panel_3 = new GridBagConstraints();
            gbc_panel_3.fill = 2;
            gbc_panel_3.anchor = 11;
            gbc_panel_3.insets = new Insets(5, 0, 5, 0);
            gbc_panel_3.gridwidth = 3;
            gbc_panel_3.gridx = 0;
            gbc_panel_3.gridy = 1;
            panel.add((Component)panel_3, gbc_panel_3);
            GridBagLayout gbl_panel_3 = new GridBagLayout();
            gbl_panel_3.columnWidths = new int[]{155, 0};
            gbl_panel_3.rowHeights = new int[]{23, 0, 0};
            gbl_panel_3.columnWeights = new double[]{0.0, Double.MIN_VALUE};
            gbl_panel_3.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
            panel_3.setLayout(gbl_panel_3);
            this._rdbtnStandardProductMoments = new JRadioButton("Standard Product Moments");
            this._rdbtnStandardProductMoments.setEnabled(false);
            GridBagConstraints gbc_rdbtnStandardProductMoments = new GridBagConstraints();
            gbc_rdbtnStandardProductMoments.insets = new Insets(0, 0, 5, 0);
            gbc_rdbtnStandardProductMoments.fill = 2;
            gbc_rdbtnStandardProductMoments.anchor = 11;
            gbc_rdbtnStandardProductMoments.gridx = 0;
            gbc_rdbtnStandardProductMoments.gridy = 0;
            panel_3.add((Component)this._rdbtnStandardProductMoments, gbc_rdbtnStandardProductMoments);
            this._rdbtnLmoments = new JRadioButton("L-Moments");
            this._rdbtnLmoments.setEnabled(false);
            GridBagConstraints gbc_rdbtnLmoments = new GridBagConstraints();
            gbc_rdbtnLmoments.fill = 2;
            gbc_rdbtnLmoments.anchor = 11;
            gbc_rdbtnLmoments.gridx = 0;
            gbc_rdbtnLmoments.gridy = 1;
            panel_3.add((Component)this._rdbtnLmoments, gbc_rdbtnLmoments);
            this.fittingTypesButtonGroup.add(this._rdbtnStandardProductMoments);
            this._rdbtnStandardProductMoments.addActionListener(e -> this._histChart.plot());
            this.fittingTypesButtonGroup.add(this._rdbtnLmoments);
            this._rdbtnLmoments.addActionListener(e -> this._histChart.plot());
            JPanel panel_1 = new JPanel();
            panel_1.setBorder(new TitledBorder(null, "Plot Types", 4, 2, null, null));
            FlowLayout flowLayout_1 = (FlowLayout)panel_1.getLayout();
            flowLayout_1.setAlignment(0);
            GridBagConstraints gbc_panel_1 = new GridBagConstraints();
            gbc_panel_1.fill = 2;
            gbc_panel_1.insets = new Insets(5, 0, 5, 0);
            gbc_panel_1.anchor = 11;
            gbc_panel_1.gridwidth = 3;
            gbc_panel_1.gridx = 0;
            gbc_panel_1.gridy = 2;
            panel.add((Component)panel_1, gbc_panel_1);
            this.rdbtnCDF = new JRadioButton("CDF");
            panel_1.add(this.rdbtnCDF);
            this.rdbtnCDF.addActionListener(e -> this._histChart.plot());
            this.plotTypesButtonGroup.add(this.rdbtnCDF);
            this.rdbtnCDF.setEnabled(false);
            this.rdbtnPDF = new JRadioButton("PDF");
            panel_1.add(this.rdbtnPDF);
            this.rdbtnPDF.addActionListener(e -> this._histChart.plot());
            this.plotTypesButtonGroup.add(this.rdbtnPDF);
            this.rdbtnPDF.setEnabled(false);
            this.rdbtnPP = new JRadioButton("PP");
            panel_1.add(this.rdbtnPP);
            this.rdbtnPP.addActionListener(e -> this._histChart.plot());
            this.plotTypesButtonGroup.add(this.rdbtnPP);
            this.rdbtnPP.setEnabled(false);
            this.rdbtnQQ = new JRadioButton("QQ");
            this.rdbtnQQ.setMargin(new Insets(2, 2, 2, 15));
            panel_1.add(this.rdbtnQQ);
            this.rdbtnQQ.addActionListener(e -> this._histChart.plot());
            this.plotTypesButtonGroup.add(this.rdbtnQQ);
            this.rdbtnQQ.setEnabled(false);
            GridBagConstraints gbc_panel = new GridBagConstraints();
            gbc_panel.fill = 1;
            gbc_panel.insets = new Insets(0, 0, 5, 0);
            gbc_panel.gridwidth = 2;
            gbc_panel.gridx = 0;
            gbc_panel.gridy = 3;
            _optionsPanel.add((Component)panel, gbc_panel);
        }
        this._histMinField = new RmaJDecimalField();
        this._histMinField.setValue(this._hist.min());
        this._histMinField.setEnabled(false);
        this._histMinField.addActionListener(evt -> this.histMinFieldAction());
        this._histMinField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                HistogramPlotDialog.this.histMinFieldAction();
            }

            @Override
            public void focusLost(FocusEvent e) {
                HistogramPlotDialog.this.histMinFieldAction();
            }
        });
        GridBagConstraints gbc__histMinField = new GridBagConstraints();
        gbc__histMinField.anchor = 11;
        gbc__histMinField.fill = 2;
        gbc__histMinField.insets = new Insets(0, 0, 5, 0);
        gbc__histMinField.gridx = 1;
        gbc__histMinField.gridy = 1;
        _optionsPanel.add((Component)this._histMinField, gbc__histMinField);
        this._histMaxField = new RmaJDecimalField();
        this._histMaxField.setValue(this._hist.max());
        this._histMaxField.setEnabled(false);
        this._histMaxField.addActionListener(evt -> this.histMaxFieldAction());
        this._histMaxField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                HistogramPlotDialog.this.histMaxFieldAction();
            }

            @Override
            public void focusLost(FocusEvent e) {
                HistogramPlotDialog.this.histMaxFieldAction();
            }
        });
        this._histMaxCheckBox = new JCheckBox();
        this._histMaxCheckBox.setText("Histogram Maximum");
        this._histMaxCheckBox.setName("_histMaxCheckBox");
        this._histMaxCheckBox.setSelected(false);
        this._histMaxCheckBox.addActionListener(evt -> {
            if (this._histMaxCheckBox.isSelected()) {
                this._histMaxField.setEnabled(true);
            } else {
                this._histMaxField.setEnabled(false);
                this._histMaxField.setValue(this._hist.max());
                this._Xmax = -3.4028234663852886E38;
                this.updateHistChart();
            }
        });
        GridBagConstraints gbc__histMaxCheckBox = new GridBagConstraints();
        gbc__histMaxCheckBox.anchor = 16;
        gbc__histMaxCheckBox.insets = new Insets(0, 0, 5, 5);
        gbc__histMaxCheckBox.gridx = 0;
        gbc__histMaxCheckBox.gridy = 2;
        _optionsPanel.add((Component)this._histMaxCheckBox, gbc__histMaxCheckBox);
        GridBagConstraints gbc__histMaxField = new GridBagConstraints();
        gbc__histMaxField.anchor = 11;
        gbc__histMaxField.fill = 2;
        gbc__histMaxField.insets = new Insets(0, 0, 5, 0);
        gbc__histMaxField.gridx = 1;
        gbc__histMaxField.gridy = 2;
        _optionsPanel.add((Component)this._histMaxField, gbc__histMaxField);
        _mainPanel.setLayout(mainPanelLayout);
        _saveAsMenuItem.addActionListener(evt -> {
            Dimension size = this._histChart.getSize();
            JFreeChart jfchart = this._histChart.getChart();
            new SaveAsDialog(jfchart, size.height, size.width);
        });
        _printPreviewMenuItem.addActionListener(evt -> {
            JFreeChart jfchart = this._histChart.getChart();
            ChartPanel cp = new ChartPanel(jfchart);
            Dimension size = this._histChart.getSize();
            cp.setSize(size.width, size.height);
            new PrintPreview((Printable)cp);
        });
        _printMenuItem.addActionListener(evt -> PrintUtilities.printComponent((Component)((Object)this._histChart)));
        _closeMenuItem.addActionListener(evt -> {
            this.setVisible(false);
            this.dispose();
        });
        _viewStatsMenuItem.addActionListener(evt -> {
            this._statsPane = new JTextPane();
            this._statsPane.setEditable(false);
            JFrame myFrame = new JFrame("Summary Statistics");
            JPanel myPanel = new JPanel();
            myFrame.setPreferredSize(new Dimension(300, 300));
            myPanel.setLayout(new BorderLayout());
            myPanel.add((Component)this._statsPane, "Center");
            myFrame.getContentPane().add((Component)myPanel, "Center");
            this._statsPane.setText(this._hist.toString());
            myFrame.pack();
            myFrame.setVisible(true);
        });
        _propertiesMenuItem.addActionListener(evt -> HistogramPlotDialog.setMenuSelectedIndex(new ChartPanel(this._histChart.getChart()).getPopupMenu(), 1));
        if (this._binComboBox.getSelectedItem().equals("Number of Bins")) {
            this._binsField.setValue(this._nbins);
            this._nbins = this._histChart.getNumBins();
            this._nbinsMin = 1;
            this._nbinsMax = 1000000;
            this._nbinsStep = this._nbins / 10;
            if (this._nbinsStep < 1) {
                this._nbinsStep = 1;
            }
            this._spinnerModel = new SpinnerNumberModel(new Integer(this._nbins), new Integer(this._nbinsMin), new Integer(this._nbinsMax), new Integer(this._nbinsStep));
        } else {
            this._binsField.setValue(this._binSize);
            this._binSize = this._histChart.getNumBins();
            this._binSizeMin = 1.0E-4;
            this._binSizeMax = 1000000.0;
            this._binSizeStep = this._binSize / 10.0;
            this._spinnerModel = new SpinnerNumberModel(new Double(this._binSize), new Double(this._binSizeMin), new Double(this._binSizeMax), new Double(this._binSizeStep));
        }
        this._binsField.setModel(this._spinnerModel);
        this._histChart.setBorder(BorderFactory.createTitledBorder("Histogram"));
        this._histChart.setMinimumSize(new Dimension(0, 0));
        this._histChart.setName("_histChart");
        this._histChart.setPreferredSize(new Dimension(500, 400));
        this._histChart.requestFocusInWindow();
        this._histChart.setVisible(true);
        this._fileMenu.setName("_fileMenu");
        _saveAsMenuItem.setName("_saveAsMenuItem");
        _printPreviewMenuItem.setName("_printPreviewMenuItem");
        _printMenuItem.setName("_printMenuItem");
        _closeMenuItem.setName("_closeMenuItem");
        this._fileMenu.add(_saveAsMenuItem);
        this._fileMenu.add(_printPreviewMenuItem);
        this._fileMenu.add(_printMenuItem);
        this._fileMenu.add(_closeMenuItem);
        this._editMenu.setName("_editMenu");
        _propertiesMenuItem.setName("_propertiesMenuItem");
        this._editMenu.add(_propertiesMenuItem);
        this._viewMenu.setName("_viewMenu");
        _viewStatsMenuItem.setName("_viewStatsMenuItem");
        this._viewMenu.add(_viewStatsMenuItem);
        this._helpMenu.setName("_helpMenu");
        _aboutMenuItem.setName("_aboutMenuItem");
        this._helpMenu.add(_aboutMenuItem);
        this._menuBar.setName("_menuBar");
        this._menuBar.add(this._fileMenu);
        this._menuBar.add(this._editMenu);
        this._menuBar.add(this._viewMenu);
        this.setJMenuBar(this._menuBar);
        this.getContentPane().add(_mainPanel);
    }

    protected void activateDistributionFitting(Boolean activate) {
        this.distributionType.setEnabled(activate);
        if (activate.booleanValue()) {
            this.distributionType.setSelectedIndex(0);
        } else {
            this.distributionType.setSelectedIndex(-1);
        }
        this._rdbtnStandardProductMoments.setEnabled(activate);
        this._rdbtnLmoments.setEnabled(activate);
        this._rdbtnStandardProductMoments.setSelected(true);
        this.rdbtnCDF.setEnabled(activate);
        this.rdbtnPDF.setEnabled(activate);
        this.rdbtnPP.setEnabled(activate);
        this.rdbtnQQ.setEnabled(activate);
        this.rdbtnPDF.setSelected(true);
    }

    private void binsFieldAction() {
        Object binsFieldValue = this._binsField.getValue();
        if (this._binType == 0) {
            this._nbins = binsFieldValue instanceof Integer ? ((Integer)binsFieldValue).intValue() : ((Double)binsFieldValue).intValue();
            if (this._nbins < 1) {
                this._nbins = 1;
            }
            this._histChart.setNumBins(this._nbins);
            this._nbinsMin = 1;
            this._nbinsMax = 1000000;
            this._nbinsStep = this._nbins / 10;
            if (this._nbinsStep < 1) {
                this._nbinsStep = 1;
            }
            this._spinnerModel = new SpinnerNumberModel(new Integer(this._nbins), new Integer(this._nbinsMin), new Integer(this._nbinsMax), new Integer(this._nbinsStep));
            this._binsField.setModel(this._spinnerModel);
            this._binsField.setValue(new Integer(this._nbins));
        } else if (this._binType == 1) {
            this._binSize = binsFieldValue instanceof Double ? ((Double)binsFieldValue).doubleValue() : ((Integer)binsFieldValue).doubleValue();
            this._histChart.setBinSize(this._binSize);
            this._binSizeMin = 1.0E-4;
            this._binSizeMax = 1000000.0;
            this._binSizeStep = this._binSize / 10.0;
            this._spinnerModel = new SpinnerNumberModel(new Double(this._binSize), new Double(this._binSizeMin), new Double(this._binSizeMax), new Double(this._binSizeStep));
            this._binsField.setValue(new Double(this._binSize));
            this._binsField.setModel(this._spinnerModel);
        }
        this._histChart.setBinType(this._binType);
    }

    public void histMinFieldAction() {
        this._Xmin = !this._histMinField.getText().equalsIgnoreCase("") ? Double.parseDouble(this._histMinField.getText()) : -3.4028234663852886E38;
        this._histChart.setXmin(this._Xmin);
        this.updateHistChart();
    }

    public void histMaxFieldAction() {
        this._Xmax = !this._histMaxField.getText().equalsIgnoreCase("") ? Double.parseDouble(this._histMaxField.getText()) : -3.4028234663852886E38;
        this._histChart.setXmax(this._Xmax);
        this.updateHistChart();
    }

    protected void updateHistChart() {
        this._histChart.update();
        this._nbins = this._histChart.getNumBins();
        this._binSize = this._histChart.getBinSize();
        this._hist = this._histChart.getHistogram();
        if (this._binComboBox.getSelectedItem().equals("Number of Bins")) {
            this._binsField.setValue(new Integer(this._nbins));
        } else if (this._binComboBox.getSelectedItem().equals("Bin Size")) {
            this._binsField.setValue(new Double(this._binSize));
        } else {
            this._binsField.setValue(this._nbins);
        }
        this._histChart.setVisible(true);
    }

    public void setHistChart(HistogramChart histChart) {
        this._histChart = histChart;
    }

    protected void reset() {
        this._histogramType = 1;
        this._binType = 0;
        this._histMinCheckBox.setSelected(false);
        this._histMaxCheckBox.setSelected(false);
        this._histChart.setNumBins(this._nbinsDefault);
        this._histChart.setHistogramType(this._histogramType);
        this._histChart.setBinType(this._binType);
        this._binsField.setValue(this._histChart.getNumBins());
        this._binComboBox.setSelectedItem("Number of Bins");
        this._Xmin = -3.4028234663852886E38;
        this._Xmax = -3.4028234663852886E38;
        this._histMinField.setEnabled(false);
        this._histMinField.setValue(this._hist.min());
        this._histMaxField.setEnabled(false);
        this._histMaxField.setValue(this._hist.max());
        this.updateHistChart();
    }

    public static void setMenuSelectedIndex(JPopupMenu popupMenu, int index) {
        SwingUtilities.invokeLater(() -> {
            for (int i = 0; i < index + 1; ++i) {
                popupMenu.dispatchEvent(new KeyEvent(popupMenu, 401, 0L, 0, 40, '\u0000'));
            }
        });
    }

    public void setDistributionPlotType(DistributionPlotTypes distributionPlotType) {
        this._distributionPlotType = distributionPlotType;
    }
}

