/*
 * Decompiled with CFR 0.152.
 */
package hec.chart;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.border.BevelBorder;
import javax.swing.border.MatteBorder;

public class PrintPreview
extends JDialog {
    protected Printable m_target;
    protected JComboBox m_cbScale;
    protected PreviewContainer m_preview;
    protected PrinterJob _prnJob = PrinterJob.getPrinterJob();
    protected PageFormat _pageFormat = this._prnJob.defaultPage();
    private Window _parent;

    public PrintPreview(Printable target) {
        this.init(target, "Print Preview");
        this.setLocation(100, 100);
        this.setSize((int)(this._pageFormat.getWidth() + 16.0), (int)(this._pageFormat.getHeight() + 10.0));
        this.setVisible(true);
    }

    public PrintPreview(Dialog parent, Printable target, String title) {
        super(parent, parent.isModal());
        this._parent = parent;
        this.init(target, title);
        this.setLocation(100, 100);
        this.setSize((int)(this._pageFormat.getWidth() + 16.0), (int)(this._pageFormat.getHeight() + 10.0));
        this.setVisible(true);
    }

    public PrintPreview(Frame parent, Printable target, String title) {
        super(parent);
        this._parent = parent;
        this.init(target, title);
        this.setLocation(100, 100);
        this.setSize((int)(this._pageFormat.getWidth() + 16.0), (int)(this._pageFormat.getHeight() + 10.0));
        this.setVisible(true);
    }

    private void init(Printable target, String title) {
        this.setTitle(title);
        this.m_target = target;
        JToolBar tb = new JToolBar();
        JButton bt = new JButton("Print", new ImageIcon("print.gif"));
        bt.setSize(200, 100);
        this.getRootPane().setDefaultButton(bt);
        ActionListener lst = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    PrinterJob prnJob = PrinterJob.getPrinterJob();
                    if (!prnJob.printDialog()) {
                        return;
                    }
                    if (PrintPreview.this.m_target instanceof Pageable) {
                        prnJob.setPageable((Pageable)((Object)PrintPreview.this.m_target));
                    } else {
                        prnJob.setPrintable(PrintPreview.this.m_target);
                    }
                    PrintPreview.this.setCursor(Cursor.getPredefinedCursor(3));
                    prnJob.print();
                    PrintPreview.this.setCursor(Cursor.getPredefinedCursor(0));
                }
                catch (PrinterException ex) {
                    ex.printStackTrace();
                    System.err.println("Printing error: " + ex.toString());
                }
            }
        };
        bt.addActionListener(lst);
        bt.setAlignmentY(0.5f);
        bt.setMargin(new Insets(2, 6, 2, 6));
        bt.setSize(300, 200);
        tb.add(bt);
        bt = new JButton("Close");
        lst = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrintPreview.this.dispose();
            }
        };
        bt.addActionListener(lst);
        bt.setAlignmentY(0.5f);
        bt.setMargin(new Insets(2, 6, 2, 6));
        tb.add(bt);
        String[] scales = new String[]{"10 %", "25 %", "50 %", "100 %"};
        this.m_cbScale = new JComboBox<String>(scales);
        this.m_cbScale.setSelectedItem("100 %");
        lst = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Thread runner = new Thread(){

                    @Override
                    public void run() {
                        PrintPreview.this.setCursor(Cursor.getPredefinedCursor(3));
                        String str = PrintPreview.this.m_cbScale.getSelectedItem().toString();
                        if (str.endsWith("%")) {
                            str = str.substring(0, str.length() - 1);
                        }
                        str = str.trim();
                        int scale = 0;
                        try {
                            scale = Integer.parseInt(str);
                        }
                        catch (NumberFormatException ex) {
                            PrintPreview.this.setCursor(Cursor.getPredefinedCursor(0));
                            return;
                        }
                        int w = (int)PrintPreview.this._pageFormat.getWidth() * scale / 100;
                        int h = (int)PrintPreview.this._pageFormat.getHeight() * scale / 100;
                        Component[] comps = PrintPreview.this.m_preview.getComponents();
                        for (int k = 0; k < comps.length; ++k) {
                            if (!(comps[k] instanceof PagePreview)) continue;
                            PagePreview pp = (PagePreview)comps[k];
                            pp.setScaledSize(w, h);
                        }
                        PrintPreview.this.m_preview.doLayout();
                        PrintPreview.this.m_preview.getParent().getParent().validate();
                        PrintPreview.this.setCursor(Cursor.getPredefinedCursor(0));
                    }
                };
                runner.start();
            }
        };
        this.m_cbScale.addActionListener(lst);
        this.m_cbScale.setMaximumSize(this.m_cbScale.getPreferredSize());
        this.m_cbScale.setEditable(true);
        tb.addSeparator();
        tb.add(this.m_cbScale);
        this.getContentPane().add((Component)tb, "North");
        this.m_preview = new PreviewContainer();
        if (this._pageFormat.getHeight() == 0.0 || this._pageFormat.getWidth() == 0.0) {
            System.err.println("Unable to determine default page size");
            return;
        }
        int scale = 100;
        int w = (int)this._pageFormat.getWidth() * (2 * scale) / 100;
        int h = (int)this._pageFormat.getHeight() * (2 * scale) / 100;
        int pageIndex = 0;
        if (this._parent != null) {
            this._parent.setCursor(Cursor.getPredefinedCursor(3));
        }
        try {
            while (true) {
                if (target instanceof Pageable) {
                    this._pageFormat = ((Pageable)((Object)target)).getPageFormat(pageIndex);
                }
                BufferedImage img = new BufferedImage((int)this._pageFormat.getWidth(), (int)this._pageFormat.getHeight(), 1);
                Graphics g = img.getGraphics();
                g.setColor(Color.white);
                g.fillRect(0, 0, (int)this._pageFormat.getWidth(), (int)this._pageFormat.getHeight());
                if (target.print(g, this._pageFormat, pageIndex) == 0) {
                    PagePreview pp = new PagePreview((int)this._pageFormat.getWidth(), (int)this._pageFormat.getHeight(), img);
                    pp.setBorder(new BevelBorder(1));
                    this.m_preview.add(pp);
                    ++pageIndex;
                    continue;
                }
                break;
            }
        }
        catch (PrinterException e) {
            e.printStackTrace();
            System.err.println("Printing error: " + e.toString());
        }
        if (this._parent != null) {
            this._parent.setCursor(Cursor.getDefaultCursor());
        }
        JScrollPane ps = new JScrollPane(this.m_preview);
        this.getContentPane().add((Component)ps, "Center");
        this.setDefaultCloseOperation(2);
    }

    class PreviewContainer
    extends JPanel {
        protected int H_GAP = 16;
        protected int V_GAP = 10;
        boolean computed = false;

        PreviewContainer() {
        }

        @Override
        public Dimension getPreferredSize() {
            int n = this.getComponentCount();
            if (n == 0) {
                return new Dimension(this.H_GAP, this.V_GAP);
            }
            Component comp = this.getComponent(0);
            Dimension dc = comp.getPreferredSize();
            int w = dc.width;
            int h = dc.height;
            Dimension dp = this.getParent().getSize();
            int nCol = Math.max((dp.width - this.H_GAP) / (w + this.H_GAP), 1);
            int nRow = n / nCol;
            if (nRow * nCol < n) {
                ++nRow;
            }
            int ww = nCol * (w + this.H_GAP) + this.H_GAP;
            int hh = nRow * (h + this.V_GAP) + this.V_GAP;
            Insets ins = this.getInsets();
            return new Dimension(ww + ins.left + ins.right, hh + ins.top + ins.bottom);
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public void doLayout() {
            if (this.computed) {
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            Insets ins = this.getInsets();
            int x = ins.left + this.H_GAP;
            int y = ins.top + this.V_GAP;
            int n = this.getComponentCount();
            if (n == 0) {
                return;
            }
            Component comp = this.getComponent(0);
            Dimension dc = comp.getPreferredSize();
            int w = dc.width;
            int h = dc.height;
            Dimension dp = this.getParent().getSize();
            int nCol = Math.max((dp.width - this.H_GAP) / (w + this.H_GAP), 1);
            int nRow = n / nCol;
            if (nRow * nCol < n) {
                ++nRow;
            }
            int index = 0;
            for (int k = 0; k < nRow; ++k) {
                for (int m = 0; m < nCol; ++m) {
                    if (index >= n) {
                        return;
                    }
                    comp = this.getComponent(index++);
                    comp.setBounds(x, y, w, h);
                    x += w + this.H_GAP;
                }
                y += h + this.V_GAP;
                x = ins.left + this.H_GAP;
            }
            this.setCursor(Cursor.getDefaultCursor());
            this.computed = true;
        }
    }

    class PagePreview
    extends JPanel {
        protected int m_w;
        protected int m_h;
        protected Image m_source;
        protected Image m_img;

        public PagePreview(int w, int h, Image source) {
            this.m_w = w;
            this.m_h = h;
            this.m_source = source;
            this.m_img = this.m_source.getScaledInstance(this.m_w, this.m_h, 4);
            this.m_img.flush();
            this.setBackground(Color.white);
            this.setBorder(new MatteBorder(1, 1, 2, 2, Color.black));
        }

        public void setScaledSize(int w, int h) {
            this.m_w = w;
            this.m_h = h;
            this.m_img = this.m_source.getScaledInstance(this.m_w, this.m_h, 4);
            this.repaint();
        }

        @Override
        public Dimension getPreferredSize() {
            Insets ins = this.getInsets();
            return new Dimension(this.m_w + ins.left + ins.right, this.m_h + ins.top + ins.bottom);
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public void paint(Graphics g) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.drawImage(this.m_img, 0, 0, this);
            this.paintBorder(g);
        }
    }
}

