/*
 * Decompiled with CFR 0.152.
 */
package hec.chart;

import hec.chart.ImageChooser;
import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;

public class SaveAsDialog
extends JPanel {
    ImageChooser imageChooser;
    File fileOut;
    String outfile;

    public SaveAsDialog(JFreeChart jfchart, int hdim, int vdim) {
        if (this.imageChooser == null) {
            this.imageChooser = new ImageChooser();
        }
        if (!this.imageChooser.Cancelled) {
            FileFilter tmp = this.imageChooser.getFileFilter();
            String descr = tmp.getDescription();
            String ext = descr.substring(1).toLowerCase();
            this.outfile = this.imageChooser.outfile;
            if (!this.outfile.endsWith(ext)) {
                this.outfile = this.outfile + ext;
            }
            this.fileOut = new File(this.outfile);
            try {
                if (ext.equals(".png")) {
                    ChartUtilities.saveChartAsPNG((File)this.fileOut, (JFreeChart)jfchart, (int)vdim, (int)hdim);
                    JOptionPane.showMessageDialog(null, "File saved to " + this.outfile);
                } else if (ext.equals(".jpg") || ext.equals(".jpeg")) {
                    ChartUtilities.saveChartAsJPEG((File)this.fileOut, (JFreeChart)jfchart, (int)vdim, (int)hdim);
                    JOptionPane.showMessageDialog(null, "File saved to " + this.outfile);
                }
            }
            catch (IOException e) {
                System.out.println("Error writing pie chart!");
                e.printStackTrace();
            }
        }
    }
}

