/*
 * Decompiled with CFR 0.152.
 */
package hec.chart;

import hec.io.DataContainer;
import hec.io.PairedDataContainer;
import hec.io.TimeSeriesContainer;
import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import rma.util.RMAConst;

public final class ValidateDataContainer {
    private ValidateDataContainer() {
        throw new IllegalStateException("Validate Data Container Utility class");
    }

    public static DataContainer removeInvalidValues(DataContainer dc) {
        if (dc instanceof PairedDataContainer) {
            return ValidateDataContainer.removeInvalidValues((PairedDataContainer)dc);
        }
        return ValidateDataContainer.removeInvalidValues((TimeSeriesContainer)dc);
    }

    public static TimeSeriesContainer removeInvalidValues(TimeSeriesContainer tsc) {
        if (tsc == null) {
            return tsc;
        }
        TimeSeriesContainer validTSC = new TimeSeriesContainer();
        tsc.clone(validTSC);
        if (validTSC.values == null || validTSC.times == null) {
            return validTSC;
        }
        ArrayList valuesList = DoubleStream.of(validTSC.values).boxed().collect(Collectors.toCollection(ArrayList::new));
        ArrayList timesList = IntStream.of(validTSC.times).boxed().collect(Collectors.toCollection(ArrayList::new));
        for (int i = valuesList.size() - 1; i >= 0; --i) {
            if (RMAConst.isValidValue((Double)valuesList.get(i))) continue;
            valuesList.remove(i);
            timesList.remove(i);
        }
        validTSC.values = valuesList.stream().mapToDouble(value -> value).toArray();
        validTSC.times = timesList.stream().mapToInt(time -> time).toArray();
        validTSC.numberValues = validTSC.values.length;
        return validTSC;
    }

    public static PairedDataContainer removeInvalidValues(PairedDataContainer pdc) {
        if (pdc == null) {
            return pdc;
        }
        PairedDataContainer validPDC = new PairedDataContainer();
        pdc.clone(validPDC);
        if (validPDC.yOrdinates == null || validPDC.xOrdinates == null) {
            return pdc;
        }
        ArrayList yOrdinatesList = DoubleStream.of(validPDC.yOrdinates[0]).boxed().collect(Collectors.toCollection(ArrayList::new));
        ArrayList xOrdinatesList = DoubleStream.of(validPDC.xOrdinates).boxed().collect(Collectors.toCollection(ArrayList::new));
        for (int i = yOrdinatesList.size() - 1; i >= 0; --i) {
            if (RMAConst.isValidValue((Double)yOrdinatesList.get(i))) continue;
            yOrdinatesList.remove(i);
            xOrdinatesList.remove(i);
        }
        validPDC.yOrdinates[0] = yOrdinatesList.stream().mapToDouble(yOrdinate -> yOrdinate).toArray();
        validPDC.xOrdinates = xOrdinatesList.stream().mapToDouble(xOrdinate -> xOrdinate).toArray();
        validPDC.numberOrdinates = validPDC.xOrdinates.length;
        return validPDC;
    }
}

