/*
 * Decompiled with CFR 0.152.
 */
package hec.client;

import hec.gfx2d.DataTypeProperties;
import hec.gfx2d.G2dAxisPropertiesPanel;
import hec.gfx2d.G2dPropertiesDlg;
import hec.gfx2d.G2dScalePropertiesPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import rma.swing.DefaultJPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJDecimalField;
import rma.util.RMAIO;

public class DataTypePanel
extends DefaultJPanel {
    private DataTypeProperties _properties;
    private RmaJDecimalField maxAxisValueFld = new RmaJDecimalField();
    private RmaJDecimalField minAxisValueFld = new RmaJDecimalField();
    private RmaJDecimalField viewPortWeightFld = new RmaJDecimalField();
    private RmaJCheckBox jAutoMaxAxisValueCheck = new RmaJCheckBox("Maximum:");
    private RmaJCheckBox jAutoMinAxisValueCheck = new RmaJCheckBox("Minimum:");
    private RmaJCheckBox jAutoViewportWeightCheck = new RmaJCheckBox("Viewport Weight:");
    private RmaJCheckBox jReverseAxisCheck = new RmaJCheckBox("Reverse Axis");
    private JLabel jAutoLabel = new JLabel("Auto");
    private ActionListener _maxAl;
    private ActionListener _minAl;
    private ActionListener _weightAl;

    public DataTypePanel() {
        this.setLayout(new GridBagLayout());
        Insets ins = this.getInsets();
        this.setName("Scale");
        JPanel backPanel = new JPanel(new GridBagLayout());
        this.add((Component)backPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, RmaInsets.insets(0, 0, 0, 0), 0, 0));
        backPanel.add((Component)this.jAutoLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, RmaInsets.insets(5, 5, 0, 0), 0, 0));
        backPanel.add((Component)this.jAutoMaxAxisValueCheck, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, RmaInsets.insets(5, 5, 0, 0), 0, 0));
        backPanel.add((Component)this.jAutoMinAxisValueCheck, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, RmaInsets.insets(5, 5, 0, 0), 0, 0));
        backPanel.add((Component)this.jAutoViewportWeightCheck, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, RmaInsets.insets(5, 5, 0, 0), 0, 0));
        backPanel.add((Component)this.jReverseAxisCheck, new GridBagConstraints(0, 4, 2, 1, 1.0, 1.0, 18, 0, RmaInsets.insets(25, 5, 5, 0), 0, 0));
        backPanel.add((Component)this.maxAxisValueFld, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, RmaInsets.insets(5, 5, 0, 5), 0, 0));
        backPanel.add((Component)this.minAxisValueFld, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 2, RmaInsets.insets(5, 5, 0, 5), 0, 0));
        backPanel.add((Component)this.viewPortWeightFld, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 18, 2, RmaInsets.insets(5, 5, 0, 5), 0, 0));
        this.jAutoMaxAxisValueCheck.setMargin(RmaInsets.insets(0, 0, 0, 0));
        this.jAutoMinAxisValueCheck.setMargin(RmaInsets.insets(0, 0, 0, 0));
        this.jReverseAxisCheck.setMargin(RmaInsets.insets(0, 0, 0, 0));
        this._maxAl = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataTypePanel.this.maxAxisValueFld.setEnabled(!DataTypePanel.this.jAutoMaxAxisValueCheck.isSelected());
            }
        };
        this.jAutoMaxAxisValueCheck.addActionListener(this._maxAl);
        this._minAl = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataTypePanel.this.minAxisValueFld.setEnabled(!DataTypePanel.this.jAutoMinAxisValueCheck.isSelected());
            }
        };
        this.jAutoMinAxisValueCheck.addActionListener(this._minAl);
        this._weightAl = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataTypePanel.this.viewPortWeightFld.setEnabled(!DataTypePanel.this.jAutoViewportWeightCheck.isSelected());
            }
        };
        this.jAutoViewportWeightCheck.addActionListener(this._weightAl);
        Dimension d = this.getPreferredSize();
        this.setSize(d);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    public void fillPanel() {
        if (this._properties == null) {
            this.clearPanel();
            return;
        }
        this.maxAxisValueFld.setValue(this._properties.getDefaultMaxAxisValue());
        this.minAxisValueFld.setValue(this._properties.getDefaultMinAxisValue());
        this.viewPortWeightFld.setValue(this._properties.getViewportWeight());
        this.jAutoMaxAxisValueCheck.setSelected(!this._properties.hasDefaultMaxAxisValue());
        this.jAutoMinAxisValueCheck.setSelected(!this._properties.hasDefaultMinAxisValue());
        this.jReverseAxisCheck.setSelected(this._properties.isYAxisReversed());
        this.jAutoViewportWeightCheck.setSelected(!this._properties.hasViewportWeight());
        this._minAl.actionPerformed(null);
        this._maxAl.actionPerformed(null);
        this._weightAl.actionPerformed(null);
    }

    public void refresh() {
        this.fillPanel();
    }

    public boolean validatePanel() {
        if (this.minAxisValueFld.getValue() > this.maxAxisValueFld.getValue()) {
            RMAIO.postError(this, "The minimum axis value cannot be greater than the maximum axis value");
            return false;
        }
        if (this.viewPortWeightFld.getValue() == 0.0) {
            RMAIO.postError(this, "Viewport weight can not be 0");
            return false;
        }
        return true;
    }

    @Override
    public boolean savePanel() {
        if (this._properties == null) {
            return true;
        }
        if (!this.validatePanel()) {
            return false;
        }
        this._properties.setHasDefaultMaxAxisValue(!this.jAutoMaxAxisValueCheck.isSelected());
        this._properties.setHasDefaultMinAxisValue(!this.jAutoMinAxisValueCheck.isSelected());
        this._properties.setDefaultMaxAxisValue(this.maxAxisValueFld.getValue());
        this._properties.setDefaultMinAxisValue(this.minAxisValueFld.getValue());
        this._properties.setYAxisReversed(this.jReverseAxisCheck.isSelected());
        this._properties.setHasViewportWeight(!this.jAutoViewportWeightCheck.isSelected());
        this._properties.setViewportWeight(this.viewPortWeightFld.getValue());
        return true;
    }

    public void setData(DataTypeProperties props) {
        this._properties = props;
    }

    public DataTypeProperties getData() {
        return this._properties;
    }

    public static void main(String[] args) {
        G2dPropertiesDlg dialog = new G2dPropertiesDlg((Frame)null, false, "", new DefaultJPanel[]{new G2dAxisPropertiesPanel(), new G2dScalePropertiesPanel()});
        dialog.setVisible(true);
    }

    public void clearPanel() {
        this.maxAxisValueFld.clearPerformed();
        this.minAxisValueFld.clearPerformed();
        this.viewPortWeightFld.clearPerformed();
        this.viewPortWeightFld.setValue(1.0);
    }
}

