/*
 * Decompiled with CFR 0.152.
 */
package hec.client;

import hec.appInterface.AppDaddy;
import hec.gui.AbstractFileChooserField;
import hec.lang.ClientAppCheck;
import java.io.File;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.text.Document;
import rma.swing.text.PathnameDocument;
import rma.util.RMAIO;

public class FileChooserFld
extends AbstractFileChooserField {
    private JFileChooser _fileChooserDialog;

    public FileChooserFld() {
    }

    public FileChooserFld(String fullpath) {
        super(fullpath);
    }

    public FileChooserFld(String fullpath, int cols) {
        super(fullpath, cols);
    }

    @Override
    public boolean displayFileChooserDialog() {
        if (!this.isEditable() || !this.isEnabled()) {
            return false;
        }
        if (ClientAppCheck.haveClientApp()) {
            return this.displayFileChooserDialogForCWMS();
        }
        return this.displayFileChooserDialogForStandalone();
    }

    @Override
    protected Document createDefaultModel() {
        Document doc = super.createDefaultModel();
        if (doc instanceof PathnameDocument) {
            PathnameDocument pd = (PathnameDocument)doc;
            pd.setAllowWindowsPath(true);
            pd.addAllowableChar('\\', -1);
        }
        return doc;
    }

    private boolean displayFileChooserDialogForStandalone() {
        String path = this.getPath();
        String filename = null;
        if (this.getDefaultPath() == null) {
            this.setDefaultPath(FileSystemView.getFileSystemView().getDefaultDirectory().getAbsolutePath());
        }
        if (path == null || path.trim().length() < 1) {
            path = this.getDefaultPath();
        } else {
            filename = RMAIO.getFileFromPath(path);
            String newPath = RMAIO.getDirectoryFromPath(path);
            path = path.equals(newPath) ? this.getDefaultPath() : newPath;
        }
        return this.displayFileChooserDialog(path, filename);
    }

    protected boolean displayFileChooserDialog(String path, String filename) {
        int canceled;
        if (this._fileChooserDialog == null) {
            this._fileChooserDialog = new JFileChooser(path);
        }
        if (this.getChooserTitle() != null) {
            this._fileChooserDialog.setDialogTitle(this.getChooserTitle());
        }
        if (filename != null) {
            File f = new File(path + File.separator + filename);
            this._fileChooserDialog.setSelectedFile(f);
        }
        if (this.getFilters() != null) {
            List filters = this.getFilters();
            for (int i = 0; i < filters.size(); ++i) {
                if (!(filters.get(i) instanceof FileFilter)) continue;
                FileFilter filter = (FileFilter)filters.get(i);
                this._fileChooserDialog.addChoosableFileFilter(filter);
            }
        } else {
            this._fileChooserDialog.setAcceptAllFileFilterUsed(true);
        }
        if (this.isOpening()) {
            if (this.getOpenType() == 0) {
                this._fileChooserDialog.setFileSelectionMode(0);
            } else {
                this._fileChooserDialog.setFileSelectionMode(1);
            }
            canceled = this._fileChooserDialog.showOpenDialog(SwingUtilities.windowForComponent(this));
        } else {
            this._fileChooserDialog.setDialogType(1);
            canceled = this._fileChooserDialog.showSaveDialog(SwingUtilities.windowForComponent(this));
        }
        if (canceled != 0) {
            return false;
        }
        File f = this._fileChooserDialog.getSelectedFile();
        if (f != null) {
            this.setText(f.getPath());
            this.setModified(true);
            this.fireFileChosen();
        } else {
            this.setText("");
        }
        return true;
    }

    private boolean displayFileChooserDialogForCWMS() {
        String path = this.getPath();
        String filename = null;
        if (this.getDefaultPath() == null) {
            if (AppDaddy.getWorkspace() != null) {
                this.setDefaultPath(AppDaddy.getWorkspace().getWorkspacePath());
            } else {
                this.setDefaultPath(FileSystemView.getFileSystemView().getDefaultDirectory().getAbsolutePath());
            }
        }
        if (path == null || path.trim().length() < 1) {
            path = this.getDefaultPath();
        } else {
            filename = RMAIO.getFileFromPath(path);
            String newPath = RMAIO.getDirectoryFromPath(path);
            path = path.equals(newPath) ? this.getDefaultPath() : newPath;
        }
        return this.displayFileChooserDialog(path, filename);
    }
}

