/*
 * Decompiled with CFR 0.152.
 */
package hec.client;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJDialog;
import rma.swing.RmaJTextField;

public class FindTextJDialog
extends RmaJDialog {
    public static final int PREV = 0;
    public static final int NEXT = 1;
    public static final int NONE = -1;
    private boolean _canceled = true;
    private int _searchDirection = -1;
    private RmaJTextField _searchText;
    private RmaJCheckBox _matchCaseCB;
    private RmaJCheckBox _wrapAroundCB;
    private JButton _nextButton;
    private JButton _prevButton;
    private JButton _cancelButton;

    public FindTextJDialog(JDialog parent, boolean modal) {
        super((Dialog)parent, true);
        this.buildControls();
    }

    public FindTextJDialog(Frame parent, boolean modal) {
        super(parent, true);
        this.buildControls();
    }

    private void buildControls() {
        this.setTitle("Find");
        this.setSize(300, 110);
        this.setLocation();
        Insets insets = new Insets(5, 5, 0, 0);
        this.getContentPane().setLayout(new GridBagLayout());
        JLabel label = new JLabel("Find what:");
        label.setDisplayedMnemonic('f');
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = insets;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        this.getContentPane().add((Component)label, gbc);
        this._searchText = new RmaJTextField();
        label.setLabelFor(this._searchText);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = insets;
        gbc.weightx = 5.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        this.getContentPane().add((Component)this._searchText, gbc);
        this._matchCaseCB = new RmaJCheckBox("Match Case");
        this._matchCaseCB.setMnemonic('m');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.insets = insets;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        this.getContentPane().add((Component)this._matchCaseCB, gbc);
        this._wrapAroundCB = new RmaJCheckBox("Wrap around");
        this._wrapAroundCB.setMnemonic('w');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.insets = insets;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        this.getContentPane().add((Component)this._wrapAroundCB, gbc);
        label = new JLabel("");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.insets = insets;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        this.getContentPane().add((Component)label, gbc);
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = insets;
        gbc.gridheight = 4;
        gbc.anchor = 18;
        gbc.fill = 1;
        this.getContentPane().add((Component)buttonPanel, gbc);
        this._nextButton = new JButton("Next");
        this._nextButton.setMnemonic('n');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = insets;
        gbc.weightx = 1.0;
        gbc.anchor = 12;
        gbc.fill = 2;
        buttonPanel.add((Component)this._nextButton, gbc);
        this._prevButton = new JButton("Previous");
        this._prevButton.setMnemonic('v');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = insets;
        gbc.weightx = 1.0;
        gbc.anchor = 12;
        gbc.fill = 2;
        buttonPanel.add((Component)this._prevButton, gbc);
        this._cancelButton = new JButton("Cancel");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.insets = insets;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 12;
        gbc.fill = 2;
        buttonPanel.add((Component)this._cancelButton, gbc);
        this._cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindTextJDialog.this._canceled = true;
                FindTextJDialog.this._searchDirection = -1;
                FindTextJDialog.this.setVisible(false);
            }
        });
        this._nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindTextJDialog.this._searchDirection = 1;
                FindTextJDialog.this._canceled = false;
                FindTextJDialog.this.setVisible(false);
            }
        });
        this._prevButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindTextJDialog.this._searchDirection = 0;
                FindTextJDialog.this._canceled = false;
                FindTextJDialog.this.setVisible(false);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                FindTextJDialog.this._canceled = false;
                FindTextJDialog.this._searchDirection = -1;
            }

            @Override
            public void windowOpened(WindowEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FindTextJDialog.this._searchText.requestFocus();
                    }
                });
            }

            @Override
            public void windowActivated(WindowEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FindTextJDialog.this._searchText.requestFocus();
                    }
                });
            }
        });
        this._searchText.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                FindTextJDialog.this._searchText.selectAll();
            }
        });
        this.getRootPane().setDefaultButton(this._nextButton);
        this.registerEnterKey(true);
        this.registerEscapeKey(true);
    }

    public int getSearchDirection() {
        return this._searchDirection;
    }

    public boolean isCanceled() {
        return this._canceled;
    }

    public boolean isMatchCase() {
        return this._matchCaseCB.isSelected();
    }

    public boolean isWrapAround() {
        return this._wrapAroundCB.isSelected();
    }

    public void setMatchCase(boolean b) {
        this._matchCaseCB.setSelected(b);
    }

    public void setWrapAround(boolean b) {
        this._wrapAroundCB.setSelected(b);
    }

    public String getSearchText() {
        if (this._canceled) {
            return "";
        }
        return this._searchText.getText();
    }

    public void setSearchText(String s) {
        this._searchText.setText(s);
    }

    public void setWrapAroundEnabled(boolean enabled) {
        this._wrapAroundCB.setEnabled(enabled);
    }

    public void setMatchCaseEnabled(boolean enabled) {
        this._matchCaseCB.setEnabled(enabled);
    }

    public static void main(String[] args) {
        new FindTextJDialog(new Frame(), false).setVisible(true);
    }
}

