/*
 * Decompiled with CFR 0.152.
 */
package hec.client;

import hec.chart.HistogramChart;
import hec.chart.PrintPreview;
import hec.gui.SelectorPanel;
import hec.io.DataContainer;
import hec.io.PairedDataContainer;
import hec.model.OutputVariable;
import hec.model.RunTimeWindow;
import hec.model.ScalarOutputVariable;
import hec.model.ScalarOutputter;
import hec.model.ScalarOutputterContainer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.print.Printable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import mil.army.usace.hec.metadata.resourceservices.ParameterLookup;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJFrame;
import rma.swing.list.RmaListModel;
import rma.util.PrintUtilities;

public class HistogramPlotDialog
extends RmaJFrame {
    private static final Logger logger = Logger.getLogger(HistogramPlotDialog.class.getName());
    private JPanel _topPanel;
    private JLabel _varTypeLabel;
    private Map<String, List<OutputVariable>> _ovMap = new HashMap<String, List<OutputVariable>>();
    private RmaJComboBox _varTypeCombo;
    protected SelectorPanel _selectorPanel;
    private HistogramChart _plot;
    private JCheckBoxMenuItem _byNumBinsMenuItem;
    private JCheckBoxMenuItem _byBinSizeMenuItem;
    private JCheckBoxMenuItem _byCountMenuItem;
    private JCheckBoxMenuItem _byFreqMenuItem;
    private List<OutputVariable> _ovList;
    private JPanel _plotPanel;
    private int _binType;
    private int _histType;
    private List<JPanel> _scalarOutputPanels = new ArrayList<JPanel>();
    private RunTimeWindow _rtw;
    private JPanel _scalarPanel;

    public HistogramPlotDialog(List<OutputVariable> ovList, RunTimeWindow rtw) {
        this._rtw = rtw;
        this.setSize(400, 400);
        this.buildControls();
        this.buildMenus();
        this.addListeners();
        this.buildOvMap(ovList);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    public HistogramPlotDialog(List<OutputVariable> ovList) {
        this(ovList, null);
    }

    protected void buildControls() {
        this.setTitle("Histogram Display");
        this.getContentPane().setLayout(new GridBagLayout());
        this._topPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._topPanel, gbc);
        this._varTypeLabel = new JLabel("Variable Type:");
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this._topPanel.add((Component)this._varTypeLabel, gbc);
        this._varTypeCombo = new RmaJComboBox();
        this._varTypeLabel.setLabelFor(this._varTypeCombo);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this._topPanel.add((Component)this._varTypeCombo, gbc);
        this._selectorPanel = new SelectorPanel(1);
        this._selectorPanel.setNameLabel("Variable:");
        this._selectorPanel.setDescriptionPanelVisible(false);
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS0000;
        this._topPanel.add((Component)this._selectorPanel, gbc);
        this._plotPanel = new JPanel(new BorderLayout());
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._plotPanel, gbc);
        this._plot = new HistogramChart();
        this._plotPanel.add((Component)((Object)this._plot), "Center");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 6;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5555;
        this._scalarPanel = new JPanel(new GridBagLayout());
        this.getContentPane().add((Component)this._scalarPanel, gbc);
    }

    protected void buildMenus() {
        JMenuBar mbar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        mbar.add(fileMenu);
        JMenuItem printPreviewMenuItem = new JMenuItem("Print Preview");
        printPreviewMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JFreeChart jfchart = HistogramPlotDialog.this._plot.getChart();
                ChartPanel cp = new ChartPanel(jfchart);
                Dimension size = HistogramPlotDialog.this._plot.getSize();
                cp.setSize(size.width, size.height);
                new PrintPreview((Printable)cp);
            }
        });
        fileMenu.add(printPreviewMenuItem);
        JMenuItem printMenuItem = new JMenuItem("Print");
        printMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrintUtilities.printComponent((Component)((Object)HistogramPlotDialog.this._plot));
            }
        });
        fileMenu.add(printMenuItem);
        JMenuItem closeMenuItem = new JMenuItem("Close");
        closeMenuItem.setAccelerator(KeyStroke.getKeyStroke("control W"));
        closeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HistogramPlotDialog.this.closeWindowAction();
            }
        });
        fileMenu.addSeparator();
        fileMenu.add(closeMenuItem);
        JMenu editMenu = new JMenu("Edit");
        mbar.add(editMenu);
        JMenu viewMenu = new JMenu("View");
        mbar.add(viewMenu);
        JMenuItem alwaysOnTopMenuItem = new JMenuItem("Always On Top");
        alwaysOnTopMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HistogramPlotDialog.this.alwaysOnTopAction();
            }
        });
        viewMenu.add(alwaysOnTopMenuItem);
        JMenuItem zoomToAllMenuItem = new JMenuItem("Zoom To All");
        zoomToAllMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HistogramPlotDialog.this.zoomToAllAction();
            }
        });
        viewMenu.add(zoomToAllMenuItem);
        JMenu histTypeMenu = new JMenu("Histogram Type");
        viewMenu.add(histTypeMenu);
        this._byCountMenuItem = new JCheckBoxMenuItem("Count");
        histTypeMenu.add(this._byCountMenuItem);
        this._byFreqMenuItem = new JCheckBoxMenuItem("Frequencies", true);
        histTypeMenu.add(this._byFreqMenuItem);
        JMenu binTypeMenu = new JMenu("Bin Type");
        this._byNumBinsMenuItem = new JCheckBoxMenuItem("Number of Bins", true);
        binTypeMenu.add(this._byNumBinsMenuItem);
        this._byBinSizeMenuItem = new JCheckBoxMenuItem("Bin Size");
        binTypeMenu.add(this._byBinSizeMenuItem);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this._byBinSizeMenuItem);
        bg.add(this._byNumBinsMenuItem);
        bg = new ButtonGroup();
        bg.add(this._byCountMenuItem);
        bg.add(this._byFreqMenuItem);
        this._binType = 0;
        this._histType = 1;
        this.setJMenuBar(mbar);
    }

    protected void histTypeAction() {
        this._histType = this._byCountMenuItem.isSelected() ? 0 : 1;
        this.updatePlot();
    }

    protected void binTypeAction() {
        this._binType = this._byBinSizeMenuItem.isSelected() ? 1 : 0;
        this.updatePlot();
    }

    private void updatePlot() {
        this._plot.setBinType(this._binType);
        this._plot.setHistogramType(this._histType);
        this._plot.update();
        this._plot.setVisible(true);
        this._plot.getHistogram();
        this.pack();
        this.setVisible(true);
    }

    protected void buildOvMap(List<OutputVariable> origOvList) {
        this._ovMap.clear();
        if (origOvList == null) {
            RmaListModel newModel = new RmaListModel(true);
            this._varTypeCombo.setModel(newModel);
            return;
        }
        for (int i = 0; i < origOvList.size(); ++i) {
            OutputVariable ov = origOvList.get(i);
            List<String> displayErrors = this.getDisplayErrors(ov);
            if (displayErrors == null || displayErrors.isEmpty()) {
                String type = ov.getType();
                List<OutputVariable> ovList = this._ovMap.get(type);
                if (ovList == null) {
                    ovList = new ArrayList<OutputVariable>();
                    this._ovMap.put(type, ovList);
                }
                ovList.add(ov);
                continue;
            }
            logger.warning("OutputVariable:" + ov.toString() + " had the following errors and will not be displayable:" + displayErrors);
        }
        Set<String> keySet = this._ovMap.keySet();
        RmaListModel<Object> newModel = new RmaListModel<Object>(true, keySet.toArray());
        this._varTypeCombo.setModel(newModel);
        if (newModel.size() > 0) {
            this._varTypeCombo.setSelectedIndex(0);
        }
    }

    protected void zoomToAllAction() {
        this._plot.zoomToAll();
    }

    protected void alwaysOnTopAction() {
        this.setAlwaysOnTop(!this.isAlwaysOnTop());
    }

    protected void closeWindowAction() {
        this.setVisible(false);
    }

    private void addListeners() {
        this._varTypeCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 2) {
                    return;
                }
                HistogramPlotDialog.this.typeComboChanged();
            }
        });
        this._selectorPanel.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 2) {
                    return;
                }
                HistogramPlotDialog.this.selectorPanelChanged();
            }
        });
        this._byBinSizeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HistogramPlotDialog.this.binTypeAction();
            }
        });
        this._byNumBinsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HistogramPlotDialog.this.binTypeAction();
            }
        });
        this._byCountMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HistogramPlotDialog.this.histTypeAction();
            }
        });
        this._byFreqMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HistogramPlotDialog.this.histTypeAction();
            }
        });
    }

    protected void typeComboChanged() {
        String type = (String)this._varTypeCombo.getSelectedItem();
        this._ovList = type != null ? this._ovMap.get(type) : new ArrayList<OutputVariable>();
        new RmaListModel<OutputVariable>(true, (Collection<OutputVariable>)this._ovList);
        this._selectorPanel.setSelectionList(this._ovList);
    }

    protected void selectorPanelChanged() {
        this.fillPanel(this.getSelectedVariable());
    }

    private void fillPanel(OutputVariable ov) {
        this.clearScalarPanels();
        if (ov == null) {
            this.fillPlot(null, null, null, null, null);
        } else {
            ScalarOutputterContainer so;
            String xLabel;
            List<? extends DataContainer> pdcList = this.filter(ov.getPairedDataList());
            int paramId = ov.getParamId();
            String param = ParameterLookup.getParamString((int)paramId);
            String units = ov.getUnits();
            String string = xLabel = ParameterLookup.isValid((String)param) ? param + "(" + units + ")" : "";
            if (ov instanceof ScalarOutputVariable) {
                ScalarOutputVariable sov = (ScalarOutputVariable)ov;
                double[] analyticX = sov.getAnalyticX();
                double[] analyticY = sov.getAnalyticY();
                this.fillPlot(pdcList, sov.getName(), xLabel, analyticX, analyticY);
                this._plot.setBinType(sov.getBinType());
                if (sov.getNumBins() > 0) {
                    this._plot.setNumBins(sov.getNumBins());
                }
                if (sov.getBinSize() > 0.0) {
                    this._plot.setBinSize(sov.getBinSize());
                }
            }
            if (ov instanceof ScalarOutputterContainer && (so = (ScalarOutputterContainer)((Object)ov)).hasScalarOutputters()) {
                this.addScalarPanels(ov);
            }
        }
    }

    private void fillPlot(List<? extends DataContainer> pdcList, String title, String xLabel, double[] analyticX, double[] analyticY) {
        if (pdcList == null) {
            this._plot.init((List<? extends DataContainer>)null, this._histType, this._binType);
        } else {
            this._plot.init(pdcList, this._histType, this._binType);
        }
        String yLabel = "";
        yLabel = this._byCountMenuItem.isSelected() ? "Counts" : "Frequency";
        this._plot.setAnalyticData(analyticX, analyticY);
        this._plot.setPlotAnalytic(analyticX != null && analyticY != null);
        this._plot.plot(title, "Sample", xLabel, yLabel);
    }

    private void addScalarPanels(OutputVariable ov) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = -1;
        gbc.weightx = 0.1;
        gbc.weighty = 0.1;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS0000;
        if (ov instanceof ScalarOutputterContainer) {
            ScalarOutputterContainer so = (ScalarOutputterContainer)((Object)ov);
            List<ScalarOutputter> outputters = so.getScalarOutputters(this._rtw);
            for (ScalarOutputter scalarOutputter : outputters) {
                Map.Entry<String, Double> scalar = scalarOutputter.getScalar(ov);
                JPanel panel = this.getNameValuePanel(scalar.getKey(), scalar.getValue());
                this._scalarOutputPanels.add(panel);
                this._scalarPanel.add((Component)panel, gbc);
            }
        }
    }

    private void clearScalarPanels() {
        if (this._scalarOutputPanels != null && !this._scalarOutputPanels.isEmpty()) {
            for (JPanel panel : this._scalarOutputPanels) {
                this._scalarPanel.remove(panel);
            }
            this._scalarOutputPanels.clear();
        }
    }

    private JPanel getNameValuePanel(String key, Double value) {
        JPanel retval = new JPanel(new GridBagLayout());
        JLabel label = new JLabel(key);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        retval.add((Component)label, gbc);
        RmaJDecimalField valueField = new RmaJDecimalField();
        valueField.setEditable(false);
        valueField.setValue(value);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        retval.add((Component)valueField, gbc);
        return retval;
    }

    public String getSelectedType() {
        String type = (String)this._varTypeCombo.getSelectedItem();
        return type;
    }

    public OutputVariable getSelectedVariable() {
        OutputVariable retval = null;
        Object obj = this._selectorPanel.getSelectedItem();
        if (obj instanceof OutputVariable) {
            retval = (OutputVariable)obj;
        }
        return retval;
    }

    public void setSelectedType(String newType) {
        String currectlySelectedType = this.getSelectedType();
        if (currectlySelectedType != null && !currectlySelectedType.equals(newType)) {
            this._varTypeCombo.setSelectedIndex(-1);
            for (int i = 0; i < this._varTypeCombo.getItemCount(); ++i) {
                Object object = this._varTypeCombo.getItemAt(i);
                if (!object.toString().equals(newType)) continue;
                this._varTypeCombo.setSelectedIndex(i);
                break;
            }
            this.typeComboChanged();
        }
    }

    public void setSelectedVariable(OutputVariable selectedVariable) {
        OutputVariable currentlySelectedVariable = this.getSelectedVariable();
        if (currentlySelectedVariable != null && !currentlySelectedVariable.equals(selectedVariable)) {
            this._selectorPanel.setSelectedIndex(-1);
            List selectorItems = this._selectorPanel.getSelectorItems();
            for (Object object : selectorItems) {
                if (!object.equals(selectedVariable)) continue;
                this._selectorPanel.setSelectedItem(object);
                break;
            }
            this.selectorPanelChanged();
        }
    }

    public void addViewMenuItem(JMenuItem item) {
        JMenuBar jmenuBar = this.getJMenuBar();
        JMenu viewMenu = null;
        for (int i = 0; i < jmenuBar.getMenuCount(); ++i) {
            JMenu menu = jmenuBar.getMenu(i);
            if (!"View".equals(menu.getText())) continue;
            viewMenu = menu;
            break;
        }
        if (viewMenu != null) {
            String itemText = item.getText();
            boolean alreadyExists = false;
            for (int i = 0; i < viewMenu.getItemCount(); ++i) {
                JMenuItem menuItem = viewMenu.getItem(i);
                if (!itemText.equals(menuItem.getLabel())) continue;
                alreadyExists = true;
                break;
            }
            if (!alreadyExists) {
                viewMenu.add(item);
            }
        }
    }

    private List<? extends DataContainer> filter(List<? extends DataContainer> pdcList) {
        ArrayList<DataContainer> retval = null;
        if (pdcList != null) {
            retval = new ArrayList<DataContainer>();
            for (DataContainer dataContainer : pdcList) {
                List<String> errorMsgs = this.getDisplayErrors(dataContainer);
                if (errorMsgs == null || errorMsgs.isEmpty()) {
                    retval.add(dataContainer);
                    continue;
                }
                logger.info("The following DataContainer cannot be displayed by HistogramPlotDialog:" + dataContainer.toString() + " because of the following reasons:" + errorMsgs);
            }
        }
        return retval;
    }

    private List<String> getDisplayErrors(OutputVariable ov) {
        ArrayList<String> retval = new ArrayList<String>();
        if (ov == null) {
            retval.add("Supplied OutputVariable was null");
        } else {
            List<PairedDataContainer> pdList = ov.getPairedDataList();
            if (pdList != null && !pdList.isEmpty()) {
                for (PairedDataContainer pdc : pdList) {
                    List<String> displayErrors = this.getDisplayErrors(pdc);
                    if (displayErrors == null || displayErrors.isEmpty()) continue;
                    retval.addAll(displayErrors);
                }
            }
        }
        return retval;
    }

    private List<String> getDisplayErrors(DataContainer dc) {
        ArrayList<String> retval = new ArrayList<String>();
        if (dc == null) {
            retval.add("Supplied DataContainer was null");
        } else if (dc instanceof PairedDataContainer) {
            PairedDataContainer pdc = (PairedDataContainer)dc;
            if (pdc.yOrdinates == null) {
                retval.add("PDC.yOrdinates==null");
            } else if (pdc.yOrdinates.length <= 0) {
                retval.add("PDC.yOrdinates.length, " + pdc.yOrdinates.length + "<=0 ");
            }
            if (pdc.labelsUsed) {
                if (pdc.numberCurves > 0 && pdc.labels == null) {
                    retval.add("PDC labelsUsed but PDC.numberCurves > 0 and labels array was null.");
                } else if (pdc.numberCurves > 0 && pdc.labels.length < pdc.numberCurves) {
                    retval.add("PDC.labelsUsed but labels array smaller than numberCurves.");
                }
            }
        }
        return retval;
    }

    public SelectorPanel getSelectorPanel() {
        return this._selectorPanel;
    }
}

