/*
 * Decompiled with CFR 0.152.
 */
package hec.client;

import hec.properties.LoginProperties;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Window;
import javax.swing.JOptionPane;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import rma.util.RMAIO;

public class LookAndFeel {
    private static Color lightGray = new Color(200, 200, 200);

    private LookAndFeel() {
    }

    public static void setLookAndFeel() {
        try {
            int javaType = RMAIO.getJavaVersion();
            int osType = RMAIO.getOSType();
            UIManager.put("ComboBox.disabledForeground", Color.black);
            UIManager.put("TextField.disabledBackground", UIManager.get("TextField.inactiveBackground"));
            String s = null;
            try {
                LoginProperties props = new LoginProperties();
                s = props.getProp("UserUI.font");
            }
            catch (Exception props) {
                // empty catch block
            }
            Font userFont = null;
            userFont = s != null ? Font.decode(s) : new Font("Dialog", 0, 12);
            if (osType == 0 || osType == 1) {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                String javaVersion = System.getProperty("java.version");
                if (javaVersion != null && javaVersion.startsWith("1.6.0")) {
                    UIManager.put("PopupMenu.consumeEventOnClose", false);
                }
                if (userFont != null) {
                    UIManager.getDefaults().put("Button.font", userFont);
                    UIManager.getDefaults().put("CheckBox.font", userFont);
                    UIManager.getDefaults().put("ComboBox.font", userFont);
                    UIManager.getDefaults().put("Label.font", userFont);
                    UIManager.getDefaults().put("PasswordField.font", userFont);
                    UIManager.getDefaults().put("ProgressBar.font", userFont);
                    UIManager.getDefaults().put("RadioButton.font", userFont);
                    UIManager.getDefaults().put("TabbedPane.font", userFont);
                    UIManager.getDefaults().put("Table.font", userFont);
                    UIManager.getDefaults().put("TableHeader.font", userFont);
                    UIManager.getDefaults().put("TextField.font", userFont);
                    UIManager.getDefaults().put("TitledBorder.font", userFont);
                    UIManager.getDefaults().put("ToggleButton.font", userFont);
                    UIManager.getDefaults().put("Tree.font", userFont);
                    UIManager.getDefaults().put("List.font", userFont);
                }
                UIManager.getDefaults().put("TextArea.font", UIManager.getDefaults().get("TextField.font"));
                PopupFactory.setSharedInstance(new PopupFactory(){

                    @Override
                    public Popup getPopup(Component owner, Component contents, int x, int y) {
                        Window win = SwingUtilities.getWindowAncestor(owner);
                        if (win.isActive()) {
                            return super.getPopup(owner, contents, x, y);
                        }
                        return super.getPopup(JOptionPane.getRootFrame(), contents, x, y);
                    }
                });
            } else if (osType == 2) {
                UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
                Font f = UIManager.getFont("TextField.font");
                f = userFont == null ? new Font("timesroman", 0, 10) : userFont;
                UIManager.put("Menu.font", f);
                UIManager.put("MenuItem.font", f);
                UIManager.put("CheckBoxMenuItem.font", f);
                UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
                UIManager.put("TextField.font", f);
                UIManager.put("TextArea.font", f);
                UIManager.put("TextPane.font", f);
                UIManager.put("Table.font", f);
                UIManager.put("Menu.font", f);
                UIManager.put("MenuItem.font", f);
                UIManager.put("CheckBoxMenuItem.font", f);
                UIManager.put("text", new Color(0xC0C0C0));
                UIManager.put("Button.font", f);
                UIManager.put("Label.font", f);
                UIManager.put("TitledBorder.font", f);
                UIManager.put("TableHeader.font", f);
                UIManager.put("List.font", f);
                UIManager.put("Button.background", MetalLookAndFeel.getMenuBackground());
                UIManager.put("ComboBox.font", f);
                UIManager.put("Panel.background", MetalLookAndFeel.getMenuBackground());
                UIManager.put("CheckBox.font", f);
                UIManager.put("TabbedPane.font", f);
                UIManager.put("RadioButton.font", f);
            }
        }
        catch (Exception e) {
            System.out.println("Failed to set look and feel");
        }
    }
}

