/*
 * Decompiled with CFR 0.152.
 */
package hec.client;

import hec.properties.LoginProperties;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import rma.swing.DefaultJPanel;
import rma.swing.FontChooserPanel;
import rma.swing.RmaInsets;
import rma.util.RMAUtil;

public class OptionsFontPanel
extends DefaultJPanel {
    private JTabbedPane _tabbedPane;
    private JLabel _label;
    private JButton _button;
    private JRadioButton _radioButton;
    private JCheckBox _checkBox;
    private JComboBox _comboBox;
    private JTextField _textField;
    private FontChooserPanel _chooserPanel;

    public OptionsFontPanel() {
        this.buildControls();
    }

    protected void buildControls() {
        this.setLayout(new GridBagLayout());
        JLabel label = new JLabel("Sample Components");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 11;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        this.add((Component)label, gbc);
        this._tabbedPane = new JTabbedPane();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        this.add((Component)this._tabbedPane, gbc);
        JPanel panel = new JPanel(new GridBagLayout());
        this._tabbedPane.addTab("A Tab", panel);
        this._label = new JLabel("A Label");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        panel.add((Component)this._label, gbc);
        this._button = new JButton("A Button");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        panel.add((Component)this._button, gbc);
        this._comboBox = new JComboBox<String>(new String[]{"Item One", "Item Two"});
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        panel.add((Component)this._comboBox, gbc);
        this._textField = new JTextField("A TextField");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        panel.add((Component)this._textField, gbc);
        this._radioButton = new JRadioButton("A RadioButton");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        panel.add((Component)this._radioButton, gbc);
        this._checkBox = new JCheckBox("A Checkbox");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        panel.add((Component)this._checkBox, gbc);
        this._chooserPanel = new FontChooserPanel(null);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.gridheight = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        this.add((Component)this._chooserPanel, gbc);
        JButton setTheFont = new JButton("Set Font Selection");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        this.add((Component)setTheFont, gbc);
        JButton resetTheFont = new JButton("Reset Font Selection");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        this.add((Component)resetTheFont, gbc);
        setTheFont.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionsFontPanel.this.updateFont();
            }
        });
        resetTheFont.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionsFontPanel.this._chooserPanel.setSelectedFont(new Font("Dialog", 0, 12));
                OptionsFontPanel.this.updateFont();
            }
        });
    }

    private void updateFont() {
        Font f = this._chooserPanel.getSelectedFont();
        this._tabbedPane.setFont(f);
        this._label.setFont(f);
        this._button.setFont(f);
        this._radioButton.setFont(f);
        this._checkBox.setFont(f);
        this._comboBox.setFont(f);
        this._textField.setFont(f);
        this.setModified(true);
    }

    @Override
    public void fillPanel() {
        LoginProperties props = new LoginProperties();
        String s = props.getProp("UserUI.font");
        if (s != null) {
            Font f = Font.decode(s);
            this._chooserPanel.setSelectedFont(f);
        }
        this.setModified(false);
    }

    @Override
    public boolean savePanel() {
        if (!this.isModified()) {
            return true;
        }
        Font font = this._label.getFont();
        JOptionPane.showMessageDialog(this, "Font changes will take effect when the application is restarted");
        String s = RMAUtil.getFontString(font);
        LoginProperties props = new LoginProperties();
        props.setProp("UserUI.font", s);
        props.saveProperties();
        return true;
    }
}

