/*
 * Decompiled with CFR 0.152.
 */
package hec.client;

import hec.client.HistogramPlotDialog;
import hec.client.ScalarOutputDialog;
import hec.model.OutputVariable;
import hec.model.RunTimeWindow;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import rma.swing.RmaJFrame;

public class OutputResultsContainer {
    ScalarOutputDialog _scalarDialog;
    HistogramPlotDialog _histogramDialog;
    Object closingLock = new Object();
    boolean closing = false;
    private OutputVariable _selectedOutputVariable;

    private RmaJFrame getSelected() {
        RmaJFrame retval = this._scalarDialog;
        if (this._histogramDialog.isVisible() && !this._scalarDialog.isVisible()) {
            retval = this._histogramDialog;
        }
        return retval;
    }

    private RmaJFrame getNotSelected() {
        RmaJFrame retval = this._histogramDialog;
        if (this._histogramDialog.isVisible() && !this._scalarDialog.isVisible()) {
            retval = this._scalarDialog;
        }
        return retval;
    }

    public ScalarOutputDialog getScalarOutputDialog() {
        return this._scalarDialog;
    }

    public HistogramPlotDialog getHistogramOutputDialog() {
        return this._histogramDialog;
    }

    public OutputResultsContainer(List<OutputVariable> ovList, RunTimeWindow rtw) {
        WindowAdapter listener = this.buildListener();
        this._scalarDialog = new ScalarOutputDialog(ovList, rtw);
        this._scalarDialog.setDefaultCloseOperation(2);
        this._scalarDialog.addWindowListener(listener);
        this._histogramDialog = new HistogramPlotDialog(ovList, rtw);
        this._histogramDialog.setDefaultCloseOperation(2);
        this._histogramDialog.addWindowListener(listener);
        JMenuItem asScalar = this.getScalarMenuItem();
        this._histogramDialog.addViewMenuItem(asScalar);
        JMenuItem asHistogram = this.getHistogramMenuItem();
        this._scalarDialog.addViewMenuItem(asHistogram);
    }

    private WindowAdapter buildListener() {
        return new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                OutputResultsContainer.this.windowsClosing(e);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void windowsClosing(WindowEvent e) {
        if (!this.closing) {
            Object object = this.closingLock;
            synchronized (object) {
                this.closing = true;
                if (this._histogramDialog != null) {
                    this._histogramDialog.setSelectedType(null);
                    this.sendWindowClosingEvent(this._histogramDialog);
                    this._histogramDialog.dispose();
                    this._histogramDialog = null;
                }
                if (this._scalarDialog != null) {
                    this._scalarDialog.setSelectedType(null);
                    this.sendWindowClosingEvent(this._scalarDialog);
                    this._scalarDialog.dispose();
                    this._scalarDialog = null;
                }
            }
        }
    }

    private void sendWindowClosingEvent(JFrame frame) {
        WindowEvent windowClosing = new WindowEvent(frame, 201);
        Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(windowClosing);
    }

    private JMenuItem getHistogramMenuItem() {
        JMenuItem asHistogram = new JMenuItem("As Histogram Plot");
        asHistogram.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OutputResultsContainer.this.showHistogram();
            }
        });
        return asHistogram;
    }

    private JMenuItem getScalarMenuItem() {
        JMenuItem asScalar = new JMenuItem("As Scalar Plot");
        asScalar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OutputResultsContainer.this.showScalar();
            }
        });
        return asScalar;
    }

    public void showHistogram() {
        if (this._scalarDialog.isVisible()) {
            this.switchDialogs();
        }
        if (this._selectedOutputVariable != null) {
            this._histogramDialog.setSelectedVariable(this._selectedOutputVariable);
        }
        if (!this._histogramDialog.isVisible()) {
            this._histogramDialog.setVisible(true);
        }
    }

    public void showScalar() {
        if (this._histogramDialog.isVisible()) {
            this.switchDialogs();
        }
        if (!this._scalarDialog.isVisible()) {
            this._scalarDialog.setVisible(true);
        }
    }

    public void switchDialogs() {
        RmaJFrame selected = this.getSelected();
        RmaJFrame unselected = this.getNotSelected();
        this.syncBounds();
        this.syncCombos();
        unselected.setVisible(true);
        selected.setVisible(false);
    }

    private void syncBounds() {
        RmaJFrame unselected;
        RmaJFrame selected = this.getSelected();
        Rectangle bounds = null;
        if (selected != null) {
            bounds = selected.getBounds();
        }
        if ((unselected = this.getNotSelected()) != null) {
            Rectangle currentBounds = unselected.getBounds();
            if (bounds != null && !bounds.equals(currentBounds)) {
                unselected.setBounds(bounds);
            }
        }
    }

    private void syncCombos() {
        RmaJFrame selected = this.getSelected();
        if (selected == this._scalarDialog) {
            this.pushSelectionsToHistogram();
        } else if (selected == this._histogramDialog) {
            this.pushSelectionsToScalar();
        }
    }

    private void pushSelectionsToScalar() {
        String selectedType = this._histogramDialog.getSelectedType();
        this._scalarDialog.setSelectedType(selectedType);
        OutputVariable selectedVariable = this._histogramDialog.getSelectedVariable();
        this._scalarDialog.setSelectedVariable(selectedVariable);
    }

    private void pushSelectionsToHistogram() {
        String selectedType = this._scalarDialog.getSelectedType();
        this._histogramDialog.setSelectedType(selectedType);
        OutputVariable selectedVariable = this._scalarDialog.getSelectedVariable();
        this._histogramDialog.setSelectedVariable(selectedVariable);
    }

    public void setSelectedOutputVariable(OutputVariable ov) {
        this._selectedOutputVariable = ov;
    }
}

