/*
 * Decompiled with CFR 0.152.
 */
package hec.client;

import hec.client.LookAndFeel;
import hec.io.PasswordFile;
import hec.lang.PasswordFileEntry;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import rma.swing.RmaInsets;
import rma.swing.RmaJFrame;
import rma.swing.RmaJPasswordField;
import rma.swing.RmaJTable;
import rma.swing.RmaJTextField;
import rma.swing.event.ReflectMultiListener;
import rma.swing.table.AbstractRmaTableModel;

public class PasswordFileEditor
extends RmaJFrame {
    public static final int ADD = 0;
    public static final int REPLACE = 1;
    RmaJTextField _filenameTxt;
    RmaJTable _passwordTable;
    ReflectMultiListener _listener = new ReflectMultiListener();
    PasswordFile _pwf;
    PasswordFileTableModel _passwordTableModel;

    public PasswordFileEditor() {
        this.buildControls();
    }

    public PasswordFileEditor(String fileName) {
        this();
        this.openFile(fileName);
    }

    protected void buildControls() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.buildMenus();
        LookAndFeel.setLookAndFeel();
        JLabel label = new JLabel("Filename:");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        this.getContentPane().add((Component)label, gbc);
        this._filenameTxt = new RmaJTextField();
        this._filenameTxt.setEditable(false);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        this.getContentPane().add((Component)this._filenameTxt, gbc);
        this._passwordTable = new RmaJTable((Component)this, (Object[])new String[]{"ID", "User"});
        this._passwordTable.setSelectionMode(0);
        this._passwordTableModel = new PasswordFileTableModel();
        this._passwordTable.setModel(this._passwordTableModel);
        this._passwordTable.setCellSelectionEnabled(false);
        this._passwordTable.setColumnSelectionAllowed(false);
        this._passwordTable.setRowSelectionAllowed(true);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        this.getContentPane().add((Component)this._passwordTable.getScrollPane(), gbc);
        this.pack();
        this.setLocation();
        this.setDefaultCloseOperation(0);
    }

    protected void buildMenus() {
        JMenuBar mbar = new JMenuBar();
        this.setJMenuBar(mbar);
        JMenu menu = new JMenu("File");
        menu.setMnemonic('F');
        mbar.add(menu);
        JMenuItem menuItem = new JMenuItem("New...", 78);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(78, 2, false));
        menuItem.addActionListener(this._listener.add(this, menuItem, "newFile"));
        menu.add(menuItem);
        menuItem = new JMenuItem("Open...", 79);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2, false));
        menuItem.addActionListener(this._listener.add(this, menuItem, "openFile"));
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Exit", 120);
        menuItem.addActionListener(this._listener.add(this, menuItem, "exitApp"));
        menu.add(menuItem);
        menu = new JMenu("Edit");
        menu.setMnemonic('E');
        mbar.add(menu);
        menuItem = new JMenuItem("Add Entry...", 65);
        menuItem.addActionListener(this._listener.add(this, menuItem, "addEntry"));
        menu.add(menuItem);
        menuItem = new JMenuItem("Delete Entry", 68);
        menuItem.addActionListener(this._listener.add(this, menuItem, "deleteEntry"));
        menu.add(menuItem);
        menuItem = new JMenuItem("Update Entry...", 85);
        menuItem.addActionListener(this._listener.add(this, menuItem, "updateEntry"));
        menu.add(menuItem);
    }

    protected void newFile() {
        JFileChooser chooser = new JFileChooser(System.getProperty("user.dir"));
        chooser.setApproveButtonText("New");
        chooser.showDialog(this, null);
        File f = chooser.getSelectedFile();
        if (f == null) {
            return;
        }
        if (f.exists()) {
            JOptionPane.showMessageDialog(this, "File " + f.getPath() + " already exists", "Unable to create new File", 0);
            return;
        }
        this.newFile(f.getPath());
    }

    protected void newFile(String path) {
        if (path == null || path.length() == 0) {
            return;
        }
        try {
            if (this._pwf != null) {
                this._pwf.close();
            }
            this._pwf = new PasswordFile(path, true);
            Vector v = this._pwf.getEntries();
            this._passwordTableModel.setData(v);
            this.setTitle("Contents of " + path);
            this._filenameTxt.setText(path);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void openFile() {
        JFileChooser chooser = new JFileChooser(System.getProperty("user.dir"));
        chooser.showOpenDialog(this);
        File f = chooser.getSelectedFile();
        if (f == null) {
            return;
        }
        this.openFile(f.getPath());
    }

    protected void openFile(String path) {
        if (path == null || path.length() == 0) {
            return;
        }
        try {
            if (this._pwf != null) {
                this._pwf.close();
            }
            this._pwf = new PasswordFile(path, true);
            Vector v = this._pwf.getEntries();
            this._passwordTableModel.setData(v);
            this.setTitle("Contents of " + path);
            this._filenameTxt.setText(path);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void updateEntry() {
        int row = this._passwordTable.getSelectedRow();
        if (row < 0) {
            return;
        }
        PasswordFileEntry pwe = this._passwordTableModel.getPasswordFileEntry(row);
        EnterPasswordDialog dialog = new EnterPasswordDialog(pwe, 1);
        dialog.setVisible(true);
        if (dialog.wasFormSaved()) {
            this._passwordTableModel.setPasswordFileEntry(row, dialog.getPasswordFileEntry());
        }
    }

    private void addEntry() {
        EnterPasswordDialog dialog = new EnterPasswordDialog(null, 0);
        dialog.setVisible(true);
        if (dialog.wasFormSaved()) {
            this._passwordTableModel.addEntry(dialog.getPasswordFileEntry());
        }
    }

    private void deleteEntry() {
        int row = this._passwordTable.getSelectedRow();
        if (row < 0) {
            return;
        }
        String id = (String)this._passwordTable.getValueAt(row, 0);
        int opt = JOptionPane.showConfirmDialog(this, "OK to delete " + id + " from file?", "Confirm Removal", 0);
        if (opt == 0) {
            this._pwf.delete(id);
            this._passwordTableModel.removeEntry(row);
        }
    }

    protected void exitApp() {
        if (this._pwf != null) {
            this._pwf.close();
        }
        System.exit(0);
    }

    public static void main(String[] args) {
        PasswordFileEditor pfe = args.length > 0 ? new PasswordFileEditor(args[0]) : new PasswordFileEditor();
        pfe.setVisible(true);
    }

    class PasswordFileTableModel
    extends AbstractRmaTableModel {
        Vector _data = null;

        PasswordFileTableModel() {
            this.m_columnNames = new String[]{"ID", "User"};
        }

        public void setData(Vector data) {
            if (this._data != null) {
                this._data.clear();
            }
            if (data == null) {
                return;
            }
            int size = data.size();
            if (this._data == null) {
                this._data = new Vector(size);
            }
            for (int i = 1; i < size; ++i) {
                this._data.add(data.get(i));
            }
            super.fireTableDataChanged();
        }

        public void removeEntry(int row) {
            if (row < 0 || row >= this._data.size()) {
                return;
            }
            this._data.remove(row);
            this.fireTableRowsDeleted(row, row);
        }

        public void addEntry(PasswordFileEntry pfe) {
            if (pfe == null) {
                return;
            }
            this._data.add(pfe);
            this.fireTableRowsInserted(this._data.size() - 1, this._data.size() - 1);
        }

        public Vector getData() {
            if (this._data == null) {
                return null;
            }
            int size = this._data.size();
            Vector data = new Vector(size);
            for (int i = 0; i < size; ++i) {
                data.add(this._data.get(i));
            }
            return data;
        }

        @Override
        public void clearAll() {
            if (this._data != null) {
                this._data.clear();
                super.fireTableDataChanged();
            }
        }

        @Override
        public void deleteRow(int index) {
            if (this._data == null || index >= this._data.size() || index < 0) {
                return;
            }
            this._data.remove(index);
        }

        @Override
        public void insertRow(int row, Vector rowData) {
            if (row < 0 || this._data == null) {
                return;
            }
        }

        @Override
        public void addRow(Vector newRow) {
            if (this._data == null) {
                this._data = new Vector();
            }
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        public boolean isCellEnabled(int row, int col) {
            return true;
        }

        @Override
        public int getRowCount() {
            if (this._data == null) {
                return 0;
            }
            return this._data.size();
        }

        @Override
        public void setValueAt(Object obj, int row, int col) {
            if (this._data == null) {
                return;
            }
            if (row >= this._data.size()) {
                return;
            }
            PasswordFileEntry pfe = (PasswordFileEntry)this._data.get(row);
            switch (col) {
                case 0: {
                    pfe.setId(obj.toString());
                    break;
                }
            }
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (this._data == null || row < 0 || row >= this._data.size()) {
                return null;
            }
            switch (col) {
                case 0: {
                    return ((PasswordFileEntry)this._data.elementAt(row)).getId();
                }
                case 1: {
                    return ((PasswordFileEntry)this._data.elementAt(row)).getUserName();
                }
            }
            return null;
        }

        public void clearTable() {
            if (this._data == null) {
                return;
            }
            int size = this._data.size();
            if (size == 0) {
                return;
            }
            this._data.removeAllElements();
            super.fireTableRowsDeleted(0, size - 1);
        }

        public PasswordFileEntry getPasswordFileEntry(int row) {
            return (PasswordFileEntry)this._data.get(row);
        }

        public void setPasswordFileEntry(int row, PasswordFileEntry pwe) {
            this._data.set(row, pwe);
            this.fireTableRowsUpdated(row, row);
        }
    }

    class EnterPasswordDialog
    extends JDialog {
        private JTextField _idFld;
        private JTextField _userName;
        private JPasswordField _password1;
        private JPasswordField _password2;
        private boolean _formFilled;
        private String _originalPassword;
        private PasswordFileEntry _pwe;
        private int _mode;
        private boolean _formSaved;

        EnterPasswordDialog(PasswordFileEntry pwe, int mode) {
            super((Frame)PasswordFileEditor.this, true);
            this._formFilled = false;
            this._originalPassword = null;
            this._formSaved = false;
            this._mode = mode;
            this._pwe = pwe;
            this.buildControls();
        }

        private void buildControls() {
            this.getContentPane().setLayout(new GridBagLayout());
            JLabel label = new JLabel("ID:");
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.getContentPane().add((Component)label, gbc);
            this._idFld = new RmaJTextField("", 20);
            this._idFld.setEditable(this._mode == 0);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.getContentPane().add((Component)this._idFld, gbc);
            label = new JLabel("User:");
            label.setDisplayedMnemonic('U');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.getContentPane().add((Component)label, gbc);
            this._userName = new RmaJTextField();
            label.setLabelFor(this._userName);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.getContentPane().add((Component)this._userName, gbc);
            label = new JLabel("Password:");
            label.setDisplayedMnemonic('P');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.getContentPane().add((Component)label, gbc);
            this._password1 = new RmaJPasswordField();
            label.setLabelFor(this._password1);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 2;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.getContentPane().add((Component)this._password1, gbc);
            label = new JLabel("Re-Enter Password:");
            label.setDisplayedMnemonic('R');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 3;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.getContentPane().add((Component)label, gbc);
            this._password2 = new RmaJPasswordField();
            label.setLabelFor(this._password2);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 3;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.getContentPane().add((Component)this._password2, gbc);
            JPanel panel = new JPanel(new GridBagLayout());
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 4;
            gbc.gridwidth = 2;
            gbc.weightx = 1.0;
            gbc.anchor = 15;
            gbc.fill = 2;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.getContentPane().add((Component)panel, gbc);
            JButton okBtn = new JButton("OK");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.anchor = 14;
            gbc.fill = 0;
            gbc.insets = new Insets(0, 5, 0, 5);
            panel.add((Component)okBtn, gbc);
            JButton cancelBtn = new JButton("Cancel");
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.anchor = 14;
            gbc.fill = 0;
            gbc.insets = new Insets(0, 5, 0, 5);
            panel.add((Component)cancelBtn, gbc);
            okBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (EnterPasswordDialog.this.saveForm()) {
                        EnterPasswordDialog.this._formSaved = true;
                        EnterPasswordDialog.this.setVisible(false);
                        return;
                    }
                    EnterPasswordDialog.this._formSaved = false;
                }
            });
            cancelBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EnterPasswordDialog.this.setVisible(false);
                    EnterPasswordDialog.this._formSaved = false;
                }
            });
            if (!this.fillForm()) {
                throw new RuntimeException("Failed to fill Connection Information Dialog");
            }
            this.pack();
            this.setLocationRelativeTo(this.getParent());
        }

        boolean wasFormSaved() {
            return this._formSaved;
        }

        private void clearForm() {
            this._formFilled = false;
            this._userName.setText("");
            this._password1.setText("");
            this._password2.setText("");
            this._idFld.setText("");
        }

        private boolean fillForm() {
            this.clearForm();
            if (this._mode == 1) {
                if (this._pwe == null) {
                    this._userName.setEnabled(false);
                    this._password1.setEnabled(false);
                    this._password2.setEnabled(false);
                    return this._formFilled;
                }
                this._idFld.setText(this._pwe.getId());
                this._userName.setText(this._pwe.getUserName());
                this._originalPassword = this._pwe.getPassword();
            }
            this._formFilled = true;
            return this._formFilled;
        }

        private boolean saveForm() {
            JTextField comp = null;
            String msg = null;
            if (this._mode == 0 && this._idFld.getText().length() == 0) {
                msg = "Please enter an ID";
                comp = this._idFld;
            }
            if (this._userName.getText().length() == 0) {
                msg = "Please enter a User Name";
                comp = this._userName;
            } else if (this._password1.getText().length() == 0) {
                msg = "The Password can not be empty";
                comp = this._password1;
            } else if (!this._password1.getText().equals(this._password2.getText())) {
                msg = "The Passwords don't match. Please Re-Enter.";
                comp = this._password1;
            }
            if (msg != null) {
                JOptionPane.showMessageDialog(this, msg);
                comp.requestFocus();
                return false;
            }
            this._pwe = new PasswordFileEntry(this._userName.getText(), this._password1.getText().trim());
            this._pwe.setId(this._idFld.getText());
            if (this._mode == 0) {
                return PasswordFileEditor.this._pwf.add(this._pwe.getId(), this._pwe.getUserName(), this._pwe.getPassword());
            }
            if (this._mode == 1) {
                return PasswordFileEditor.this._pwf.replace(this._pwe.getId(), this._pwe.getUserName(), this._pwe.getPassword());
            }
            return false;
        }

        public PasswordFileEntry getPasswordFileEntry() {
            return this._pwe;
        }

        @Override
        public void setVisible(boolean b) {
            if (b) {
                EnterOriginalPasswordDialog dialog;
                if (!this._formFilled) {
                    return;
                }
                if (this._mode == 1 && !(dialog = new EnterOriginalPasswordDialog()).passwordsMatched()) {
                    return;
                }
            }
            super.setVisible(b);
        }

        class EnterOriginalPasswordDialog
        extends JDialog {
            private JPasswordField _passwordFld;
            private int _cnt;
            private int _maxTryCnt;
            private boolean _passwordsMatched;

            EnterOriginalPasswordDialog() {
                super((Frame)PasswordFileEditor.this, true);
                this._cnt = 0;
                this._maxTryCnt = 3;
                this._passwordsMatched = false;
                this.buildControls();
            }

            private void buildControls() {
                this.getContentPane().setLayout(new GridBagLayout());
                this.setTitle("Enter Password for " + EnterPasswordDialog.this._pwe.getId());
                JLabel label = new JLabel("Enter Existing Password:");
                label.setDisplayedMnemonic('E');
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 0;
                gbc.gridwidth = 1;
                gbc.anchor = 18;
                gbc.fill = 0;
                gbc.insets = new Insets(5, 5, 0, 5);
                this.getContentPane().add((Component)label, gbc);
                this._passwordFld = new JPasswordField();
                this._passwordFld.setColumns(20);
                label.setLabelFor(this._passwordFld);
                gbc = new GridBagConstraints();
                gbc.gridx = 1;
                gbc.gridy = 0;
                gbc.gridwidth = 1;
                gbc.weightx = 1.0;
                gbc.anchor = 18;
                gbc.fill = 2;
                gbc.insets = new Insets(5, 5, 0, 5);
                this.getContentPane().add((Component)this._passwordFld, gbc);
                JPanel panel = new JPanel(new GridBagLayout());
                gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 4;
                gbc.gridwidth = 2;
                gbc.weighty = 1.0;
                gbc.anchor = 15;
                gbc.fill = 2;
                gbc.insets = new Insets(5, 5, 0, 5);
                this.getContentPane().add((Component)panel, gbc);
                JButton okBtn = new JButton("OK");
                gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 0;
                gbc.gridwidth = 1;
                gbc.anchor = 14;
                gbc.fill = 0;
                gbc.insets = new Insets(0, 5, 0, 5);
                panel.add((Component)okBtn, gbc);
                JButton cancelBtn = new JButton("Cancel");
                gbc = new GridBagConstraints();
                gbc.gridx = 1;
                gbc.gridy = 0;
                gbc.gridwidth = 1;
                gbc.anchor = 14;
                gbc.fill = 0;
                gbc.insets = new Insets(0, 5, 0, 5);
                panel.add((Component)cancelBtn, gbc);
                okBtn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (EnterOriginalPasswordDialog.this._cnt > EnterOriginalPasswordDialog.this._maxTryCnt) {
                            JOptionPane.showMessageDialog(EnterOriginalPasswordDialog.this, "Too many incorrect trys");
                            EnterOriginalPasswordDialog.this._passwordsMatched = false;
                            EnterOriginalPasswordDialog.this.setVisible(false);
                            return;
                        }
                        if (EnterOriginalPasswordDialog.this._passwordFld.getText().equals(EnterPasswordDialog.this._originalPassword)) {
                            EnterOriginalPasswordDialog.this._passwordsMatched = true;
                            EnterOriginalPasswordDialog.this.setVisible(false);
                        } else {
                            JOptionPane.showMessageDialog(EnterOriginalPasswordDialog.this, "Invalid Password");
                            ++EnterOriginalPasswordDialog.this._cnt;
                        }
                    }
                });
                cancelBtn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        EnterOriginalPasswordDialog.this._passwordsMatched = false;
                        EnterOriginalPasswordDialog.this.setVisible(false);
                    }
                });
                this.getRootPane().setDefaultButton(okBtn);
                this.pack();
                this.setLocationRelativeTo(this.getParent());
                this.setVisible(true);
            }

            boolean passwordsMatched() {
                return this._passwordsMatched;
            }
        }
    }
}

