/*
 * Decompiled with CFR 0.152.
 */
package hec.client;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import rma.util.WildCardFileFilter;

public class PlugInLoader {
    private static final String MAIN_CLASS_KEY = "MainClass";
    static String MANIFEST_MF = "MANIFEST.MF";
    static String META_INF = "META-INF";

    public static void loadPlugIns() {
        String pluginDirectory = System.getProperty("PLUGINS");
        if (pluginDirectory == null) {
            pluginDirectory = "jar/ext";
        }
        String[] pluginDirectoryPaths = new String[]{pluginDirectory};
        if (pluginDirectory.contains(File.pathSeparator)) {
            pluginDirectoryPaths = pluginDirectory.split(File.pathSeparator);
        }
        for (String pluginDir : pluginDirectoryPaths) {
            File f = new File(pluginDir);
            WildCardFileFilter filter = new WildCardFileFilter("*.jar");
            filter.setAcceptDirectories(false);
            File[] jarFiles = f.listFiles(filter);
            if (jarFiles == null || jarFiles.length == 0) continue;
            for (int i = 0; i < jarFiles.length; ++i) {
                File jar = jarFiles[i];
                System.out.println("loadPlugIns: found jar " + jar);
                PlugInLoader.loadPlugIn(jar);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean loadPlugIn(File jar) {
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(jar));
        }
        catch (FileNotFoundException nfe) {
            System.out.println("loadPlugIn: ERROR failed to find file " + jar);
            return false;
        }
        ZipInputStream zin = null;
        try {
            ZipEntry zipentry;
            zin = new ZipInputStream(in);
            while ((zipentry = zin.getNextEntry()) != null) {
                BufferedReader bufferedreader;
                String[] mainClasses;
                if (!zipentry.getName().equalsIgnoreCase(META_INF + "/" + MANIFEST_MF) || (mainClasses = PlugInLoader.getMainClasses(bufferedreader = new BufferedReader(new InputStreamReader(zin)))) == null) continue;
                for (int i = 0; i < mainClasses.length; ++i) {
                    System.out.println("Main Class = " + mainClasses[i]);
                    PlugInLoader.loadClass(mainClasses[i]);
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception ioe) {
            System.out.println("loadPlugIn: ERROR reading " + jar + " Error:" + ioe);
            ioe.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (zin != null) {
                    zin.close();
                }
            }
            catch (IOException ioe) {
                System.out.println("loadPlugIn:ERROR closing " + jar + " " + ioe);
            }
        }
    }

    private static String[] getMainClasses(BufferedReader reader) {
        String s1 = null;
        ArrayList<String> classes = new ArrayList<String>();
        try {
            while ((s1 = reader.readLine()) != null) {
                int idx;
                if (!s1.startsWith(MAIN_CLASS_KEY) || (idx = s1.indexOf(":")) <= -1) continue;
                StringTokenizer tokenizer = new StringTokenizer(s1.substring(s1.indexOf(":") + 1).trim(), ",; ");
                while (tokenizer.hasMoreTokens()) {
                    classes.add(tokenizer.nextToken());
                }
            }
            if (classes.size() == 0) {
                return null;
            }
            String[] clsArray = new String[classes.size()];
            clsArray = classes.toArray(clsArray);
            return clsArray;
        }
        catch (IOException ioexception) {
            System.out.println("Error reading manifest file: " + ioexception);
            return null;
        }
    }

    private static void loadClass(String theClass) {
        Class<?> cls;
        if (theClass == null) {
            return;
        }
        try {
            cls = Class.forName(theClass);
        }
        catch (ClassNotFoundException e) {
            System.out.println("loadClass: failed to find class " + theClass);
            System.out.println("loadClass:classpath=" + System.getProperty("java.class.path"));
            String resource = theClass.replace('.', '/');
            return;
        }
        catch (NoClassDefFoundError cdf) {
            System.out.println("loadClass: failed to find class " + theClass);
            System.out.println("loadClass:classpath=" + System.getProperty("java.class.path"));
            String resource = theClass.replace('.', '/');
            cdf.printStackTrace(System.out);
            return;
        }
        Class[] argsCls = new Class[]{String[].class};
        Object[] args = new Object[]{new String[0]};
        try {
            Method mainMethod = cls.getMethod("main", argsCls);
            System.out.println("loadClass: found main method " + mainMethod);
            mainMethod.invoke(null, args);
        }
        catch (SecurityException e1) {
            e1.printStackTrace(System.out);
        }
        catch (NoSuchMethodException e1) {
            e1.printStackTrace(System.out);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace(System.out);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace(System.out);
        }
        catch (InvocationTargetException e) {
            Throwable ee = e.getTargetException();
            ee.printStackTrace(System.out);
        }
    }

    public static void main(String[] args) {
        PlugInLoader.loadPlugIns();
    }
}

