/*
 * Decompiled with CFR 0.152.
 */
package hec.client;

import hec.map.MapPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.KeyStroke;

public class PreviewDialog
extends JDialog {
    MapPanel mapPanel;

    public PreviewDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.buildControls();
    }

    public PreviewDialog(Dialog parent, boolean modal) {
        super(parent, modal);
        this.buildControls();
    }

    protected void buildControls() {
        int iy;
        this.setSize(300, 300);
        this.setTitle("Preview");
        Rectangle bounds = this.getParent().getBounds();
        Rectangle abounds = this.getBounds();
        int ix = bounds.x + (bounds.width - abounds.width) / 2;
        if (ix < 10) {
            ix = 10;
        }
        if ((iy = bounds.y + (bounds.height - abounds.height) / 2) < 10) {
            iy = 10;
        }
        this.setLocation(ix, iy);
        this.getContentPane().setLayout(new GridBagLayout());
        this.mapPanel = new MapPanel(false);
        this.mapPanel.setBackground(Color.white);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.ipadx = 200;
        gbc.ipady = 200;
        gbc.insets = new Insets(5, 5, 0, 5);
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.getContentPane().add((Component)this.mapPanel, gbc);
        JButton closeButton = new JButton("Close");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 10;
        gbc.insets = new Insets(5, 0, 0, 0);
        gbc.anchor = 15;
        gbc.fill = 0;
        this.getContentPane().add((Component)closeButton, gbc);
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreviewDialog.this.setVisible(false);
            }
        });
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreviewDialog.this.getMapPanel().paintMap();
            }
        }, KeyStroke.getKeyStroke(116, 0, true), 1);
    }

    public MapPanel getMapPanel() {
        return this.mapPanel;
    }
}

