/*
 * Decompiled with CFR 0.152.
 */
package hec.client;

import hec.gfx2d.G2dDialog;
import hec.gfx2d.PairedDataSet;
import hec.gui.SelectorPanel;
import hec.io.PairedDataContainer;
import hec.model.OutputVariable;
import hec.model.RunTimeWindow;
import hec.model.ScalarOutputter;
import hec.model.ScalarOutputterContainer;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDecimalField;
import rma.swing.list.RmaListModel;

public class ScalarOutputDialog
extends G2dDialog {
    private RmaJComboBox _varTypeCombo;
    private SelectorPanel _selectorPanel;
    private Map<String, List<OutputVariable>> _ovMap = new HashMap<String, List<OutputVariable>>();
    private List<OutputVariable> _ovList;
    private RunTimeWindow _rtw;
    private List<JPanel> _scalarOutputPanels = new ArrayList<JPanel>();
    private JPanel _scalarPanel;

    public ScalarOutputDialog(List<OutputVariable> ovList, RunTimeWindow rtw) {
        this._rtw = rtw;
        this.buildControls();
        this.addListeners();
        this.buildOvMap(ovList);
        this.setSize(this.getWidth() + 100, this.getHeight());
        this.setLocationRelativeTo(this.getParent());
    }

    public ScalarOutputDialog(List<OutputVariable> ovList) {
        this(ovList, null);
    }

    protected void buildControls() {
        this.setTitle("Scalar Display");
        JPanel topPanel = new JPanel(new GridBagLayout());
        this.getContentPane().add((Component)topPanel, "North");
        JLabel label = new JLabel("Variable Type:");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        topPanel.add((Component)label, gbc);
        this._varTypeCombo = new RmaJComboBox();
        label.setLabelFor(this._varTypeCombo);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5005;
        topPanel.add((Component)this._varTypeCombo, gbc);
        this._selectorPanel = new SelectorPanel(1);
        this._selectorPanel.setNameLabel("Variable:");
        this._selectorPanel.setDescriptionPanelVisible(false);
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS0505;
        topPanel.add((Component)this._selectorPanel, gbc);
        this._scalarPanel = new JPanel(new GridBagLayout());
        this.getContentPane().add((Component)this._scalarPanel, "South");
    }

    protected void addListeners() {
        this._varTypeCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 2) {
                    return;
                }
                ScalarOutputDialog.this.typeComboChanged();
            }
        });
        this._selectorPanel.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 2) {
                    return;
                }
                ScalarOutputDialog.this.selectorPanelChanged();
            }
        });
    }

    public SelectorPanel getSelectorPanel() {
        return this._selectorPanel;
    }

    protected void buildOvMap(List<OutputVariable> origOvList) {
        this._ovMap.clear();
        if (origOvList == null) {
            RmaListModel newModel = new RmaListModel(true);
            this._varTypeCombo.setModel(newModel);
            return;
        }
        for (int i = 0; i < origOvList.size(); ++i) {
            OutputVariable ov = origOvList.get(i);
            String type = ov.getType();
            List<OutputVariable> ovList = this._ovMap.get(type);
            if (ovList == null) {
                ovList = new ArrayList<OutputVariable>();
                this._ovMap.put(type, ovList);
            }
            ovList.add(ov);
        }
        Set<String> keySet = this._ovMap.keySet();
        RmaListModel<Object> newModel = new RmaListModel<Object>(true, keySet.toArray());
        this._varTypeCombo.setModel(newModel);
        if (newModel.size() > 0) {
            this._varTypeCombo.setSelectedIndex(0);
        }
    }

    protected void selectorPanelChanged() {
        Object obj = this._selectorPanel.getSelectedItem();
        if (obj instanceof OutputVariable) {
            this.fillPanel((OutputVariable)obj);
        } else {
            this.fillPanel(null);
        }
    }

    private void fillPanel(OutputVariable ov) {
        if (ov == null) {
            this.fillPlot(null);
        } else {
            ScalarOutputterContainer so;
            List<PairedDataContainer> pdcList = ov.getPairedDataList();
            this.fillPlot(pdcList);
            this.clearScalarPanels();
            if (ov instanceof ScalarOutputterContainer && (so = (ScalarOutputterContainer)((Object)ov)).hasScalarOutputters()) {
                this.addScalarPanels(so);
            }
        }
    }

    private void clearScalarPanels() {
        if (this._scalarOutputPanels != null && !this._scalarOutputPanels.isEmpty()) {
            for (JPanel panel : this._scalarOutputPanels) {
                this._scalarPanel.remove(panel);
            }
            this._scalarOutputPanels.clear();
        }
    }

    private void addScalarPanels(ScalarOutputterContainer ov) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = -1;
        gbc.weightx = 0.1;
        gbc.weighty = 0.1;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS0000;
        List<ScalarOutputter> outputters = ov.getScalarOutputters(this._rtw);
        for (ScalarOutputter scalarOutputter : outputters) {
            Map.Entry<String, Double> scalar = scalarOutputter.getScalar((OutputVariable)((Object)ov));
            JPanel panel = this.getNameValuePanel(scalar.getKey(), scalar.getValue());
            this._scalarOutputPanels.add(panel);
            this._scalarPanel.add((Component)panel, gbc);
        }
    }

    private JPanel getNameValuePanel(String key, Double value) {
        JPanel retval = new JPanel(new GridBagLayout());
        JLabel label = new JLabel(key);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        retval.add((Component)label, gbc);
        RmaJDecimalField valueField = new RmaJDecimalField();
        valueField.setEditable(false);
        valueField.setValue(value);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        retval.add((Component)valueField, gbc);
        return retval;
    }

    private void fillPlot(List<PairedDataContainer> pdcList) {
        Vector<PairedDataSet> plotData = new Vector<PairedDataSet>();
        if (pdcList != null) {
            for (int i = 0; i < pdcList.size(); ++i) {
                PairedDataSet pds = new PairedDataSet(pdcList.get(i));
                plotData.add(pds);
            }
        }
        this.getPlotpanel().buildComponents(plotData);
        this.updateUnitSystem(this.getPlotpanel());
        this.getPlotpanel().paintGfx();
    }

    protected void typeComboChanged() {
        String type = (String)this._varTypeCombo.getSelectedItem();
        this._ovList = type != null ? this._ovMap.get(type) : new ArrayList<OutputVariable>();
        RmaListModel<OutputVariable> newModel = new RmaListModel<OutputVariable>(true, (Collection<OutputVariable>)this._ovList);
        this._selectorPanel.setSelectionList(this._ovList);
    }

    public void setSelectedVariable(OutputVariable selectedVariable) {
        OutputVariable currentlySelectedVariable = this.getSelectedVariable();
        if (currentlySelectedVariable != null && !currentlySelectedVariable.equals(selectedVariable)) {
            this._selectorPanel.setSelectedIndex(-1);
            List selectorItems = this._selectorPanel.getSelectorItems();
            for (Object object : selectorItems) {
                if (!object.equals(selectedVariable)) continue;
                this._selectorPanel.setSelectedItem(object);
                break;
            }
            this.selectorPanelChanged();
        }
    }

    public void setSelectedType(String newType) {
        String currectlySelectedType = this.getSelectedType();
        if (currectlySelectedType != null && !currectlySelectedType.equals(newType)) {
            this._varTypeCombo.setSelectedIndex(-1);
            for (int i = 0; i < this._varTypeCombo.getItemCount(); ++i) {
                Object object = this._varTypeCombo.getItemAt(i);
                if (!object.toString().equals(newType)) continue;
                this._varTypeCombo.setSelectedIndex(i);
                break;
            }
            this.typeComboChanged();
        }
    }

    public String getSelectedType() {
        String type = (String)this._varTypeCombo.getSelectedItem();
        return type;
    }

    public OutputVariable getSelectedVariable() {
        OutputVariable retval = null;
        Object obj = this._selectorPanel.getSelectedItem();
        if (obj instanceof OutputVariable) {
            retval = (OutputVariable)obj;
        }
        return retval;
    }

    public void addViewMenuItem(JMenuItem item) {
        JMenuBar jmenuBar = this.getJMenuBar();
        JMenu viewMenu = null;
        for (int i = 0; i < jmenuBar.getMenuCount(); ++i) {
            JMenu menu = jmenuBar.getMenu(i);
            if (!"View".equals(menu.getText())) continue;
            viewMenu = menu;
            break;
        }
        if (viewMenu != null) {
            String itemText = item.getText();
            boolean alreadyExists = false;
            for (int i = 0; i < viewMenu.getItemCount(); ++i) {
                JMenuItem menuItem = viewMenu.getItem(i);
                if (!itemText.equals(menuItem.getLabel())) continue;
                alreadyExists = true;
                break;
            }
            if (!alreadyExists) {
                viewMenu.add(item);
            }
        }
    }
}

