/*
 * Decompiled with CFR 0.152.
 */
package hec.client;

import hec.gui.AbstractEditorPanel;
import hec.gui.SelectorPanel;
import hec.lang.NamedType;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import rma.swing.RmaInsets;

public class SelectorEditorPanel
extends AbstractEditorPanel {
    protected SelectorPanel _selectorPanel = null;
    protected AbstractEditorPanel _editPanel = null;
    protected NamedType _selectedItem;

    public SelectorEditorPanel(AbstractEditorPanel editorPanel) {
        this._editPanel = editorPanel;
        this.buildControls();
    }

    public SelectorEditorPanel(SelectorPanel selPanel, AbstractEditorPanel editorPanel) {
        this._selectorPanel = selPanel;
        this._editPanel = editorPanel;
        this.buildControls();
    }

    private void buildControls() {
        if (this._selectorPanel == null) {
            this._selectorPanel = new SelectorPanel();
        }
        this.setLayout(new GridBagLayout());
        this.add((Component)this._selectorPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, RmaInsets.insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this._editPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 16, 1, RmaInsets.insets(5, 5, 5, 5), 0, 0));
        this._selectorPanel.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 2) {
                    return;
                }
                Object obj = SelectorEditorPanel.this._selectorPanel.getSelectedItem();
                if (obj instanceof NamedType) {
                    SelectorEditorPanel.this.fillPanel((NamedType)obj);
                }
            }
        });
    }

    @Override
    public void fillPanel(NamedType nt) {
        this._selectedItem = nt;
        this._selectorPanel.setSelectedItem(nt);
        if (nt != null) {
            this._selectorPanel.setDescription(nt.getDescription());
        }
        this._editPanel.fillPanel(nt);
    }

    public void undoAllChanges() {
        Object obj = this._selectorPanel.getSelectedItem();
        if (obj instanceof NamedType) {
            this.fillPanel((NamedType)obj);
        }
    }

    public void setNavPanelVisible(boolean b) {
        this._selectorPanel.setNavPanelVisible(b);
    }

    public boolean isNavPanelVisible() {
        return this._selectorPanel.isNavPanelVisible();
    }

    public void setSelectionList(Collection list) {
        this._selectorPanel.setSelectionList(list);
        this._selectorPanel.setSelectedIndex(-1);
    }

    public void setSelectionList(Object[] list) {
        this._selectorPanel.setSelectionList(list);
        this._selectorPanel.setSelectedIndex(-1);
    }

    @Override
    public boolean savePanel(NamedType dobj) {
        NamedType namedType = null;
        namedType = dobj == null ? this._selectedItem : dobj;
        if (namedType != null) {
            namedType.setDescription(this._selectorPanel.getDescription());
        }
        this._editPanel.savePanel(namedType);
        return true;
    }

    public SelectorPanel getSelectorPanel() {
        return this._selectorPanel;
    }

    @Override
    public String getTabname() {
        return "";
    }
}

