/*
 * Decompiled with CFR 0.152.
 */
package hec.client;

import hec.gui.WizardPanel;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.text.html.HTMLDocument;
import rma.swing.RmaInsets;
import rma.swing.print.DocumentRenderer;

public class SummaryWizardPanel
extends WizardPanel {
    public static final String PANEL_NAME = "Summary";
    private JLabel _panelTitle;
    private JEditorPane _summaryTxt;
    private JButton _copyButton;
    private JButton _printButton;

    public SummaryWizardPanel() {
        super(new GridBagLayout());
        this.buildControls();
    }

    protected void buildControls() {
        this._panelTitle = new JLabel(PANEL_NAME);
        Font f = this._panelTitle.getFont();
        this._panelTitle.setFont(new Font(f.getName(), 1, f.getSize()));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets(4, 4, 4, 4);
        this.add((Component)this._panelTitle, gbc);
        this._summaryTxt = new JEditorPane();
        this._summaryTxt.setContentType("text/html");
        this._summaryTxt.setEditable(false);
        this._summaryTxt.setBorder(UIManager.getBorder("TextArea.border"));
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets(4, 4, 4, 4);
        this.add((Component)new JScrollPane(this._summaryTxt), gbc);
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 15;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5555;
        this.add((Component)buttonPanel, gbc);
        this._copyButton = new JButton("Copy");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 10;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS0005;
        buttonPanel.add((Component)this._copyButton, gbc);
        this._printButton = new JButton("Print");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 10;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS0500;
        buttonPanel.add((Component)this._printButton, gbc);
        this._copyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SummaryWizardPanel.this._summaryTxt.copy();
            }
        });
        this._printButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SummaryWizardPanel.this.printSummaryAction();
            }
        });
    }

    protected void printSummaryAction() {
        DocumentRenderer renderer = new DocumentRenderer();
        renderer.print((HTMLDocument)this._summaryTxt.getDocument());
    }

    public void setSummaryText(String text) {
        this._summaryTxt.setText(text);
        this._summaryTxt.setCaretPosition(0);
    }

    public void setPanelTitle(String title) {
        this._panelTitle.setText(title);
    }

    @Override
    public String getPanelName() {
        return PANEL_NAME;
    }

    @Override
    public boolean isValidPanel() {
        return true;
    }
}

