/*
 * Decompiled with CFR 0.152.
 */
package hec.client;

import hec.io.HecFile;
import hec.io.Identifier;
import hec.lang.ClientAppCheck;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import rma.swing.AbstractTextEditorPanel;
import rma.swing.FontChooser;
import rma.swing.RmaInsets;
import rma.swing.RmaJTextField;
import rma.util.RMAIO;
import rma.util.RMAUtil;

public class TextEditorPanel
extends JPanel {
    private static final String FONT_PROP = "textFileEditor.font";
    private static final String WINDOW_SIZE_PROP = "textFileEditor.size";
    private static final String WORD_WRAP_PROP = "textFileEditor.wordWrap";
    private static final String BACKGROUND_PROP = "textFileEditor.background";
    private static final String FOREGROUND_PROP = "textFileEditor.foreground";
    private EditorPanel _editorPanel;
    private Identifier _identifier;
    private RmaJTextField _statusLine;
    private RmaJTextField _timeStampLine;
    private RmaJTextField _positionLine;
    private RmaJTextField _insertLine;

    public TextEditorPanel(Identifier id, boolean editable) {
        super(new GridBagLayout());
        this.setSize(400, 600);
        this.buildControls(false);
        this.fillForm(id);
        this._editorPanel.setEditable(editable);
    }

    public TextEditorPanel(Identifier id, boolean editable, boolean canSaveAs) {
        super(new GridBagLayout());
        this.setSize(400, 600);
        this.buildControls(canSaveAs);
        this.fillForm(id);
        this._editorPanel.setEditable(editable);
    }

    protected void buildControls(boolean canSaveAs) {
        JPanel statusPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 16;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.insets = RmaInsets.insets(0, 0, 0, 0);
        this.add((Component)statusPanel, gbc);
        this._statusLine = new RmaJTextField(80);
        this._statusLine.setEditable(false);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 0.8;
        gbc.weighty = 0.0;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        statusPanel.add((Component)this._statusLine, gbc);
        this._timeStampLine = new RmaJTextField(12);
        this._timeStampLine.setEditable(false);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 0.5;
        gbc.weighty = 0.0;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        statusPanel.add((Component)this._timeStampLine, gbc);
        this._positionLine = new RmaJTextField(10);
        this._positionLine.setHorizontalAlignment(0);
        this._positionLine.setEditable(false);
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 0.2;
        gbc.weighty = 0.0;
        gbc.insets = RmaInsets.insets(5, 0, 0, 5);
        statusPanel.add((Component)this._positionLine, gbc);
        this._insertLine = new RmaJTextField(10);
        this._insertLine.setEditable(false);
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 0.2;
        gbc.weighty = 0.0;
        gbc.insets = RmaInsets.insets(5, 0, 0, 5);
        statusPanel.add((Component)this._insertLine, gbc);
        this._editorPanel = new EditorPanel(canSaveAs);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        this.add((Component)new JScrollPane(this._editorPanel), gbc);
    }

    public void closeAction() {
        this._editorPanel.closeAction();
    }

    public void createMenus() {
        this._editorPanel.createMenus();
    }

    public void init() {
        if (this._identifier == null) {
            return;
        }
        Window w = SwingUtilities.windowForComponent(this);
        if (w instanceof JDialog) {
            ((JDialog)w).setTitle(RMAIO.getFileFromPath(this._identifier.getPath()));
        } else if (w instanceof JFrame) {
            ((JFrame)w).setTitle(RMAIO.getFileFromPath(this._identifier.getPath()));
        }
    }

    public boolean reloadForm() {
        return this.fillForm(this._identifier);
    }

    public boolean setIdentifier(Identifier id) {
        this._identifier = id;
        if (id == null || id.getFile() == null) {
            this._editorPanel.setText("");
            return false;
        }
        Window w = SwingUtilities.windowForComponent(this);
        if (w instanceof JDialog) {
            ((JDialog)w).setTitle(RMAIO.getFileFromPath(this._identifier.getPath()));
        } else if (w instanceof JFrame) {
            ((JFrame)w).setTitle(RMAIO.getFileFromPath(this._identifier.getPath()));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fillForm(Identifier id) {
        if (!this.setIdentifier(id)) {
            return false;
        }
        HecFile file = id.getFile();
        StringBuffer buffer = new StringBuffer((int)file.length());
        BufferedReader reader = file.getBufferedReader();
        if (reader != null) {
            String localSep = "\n";
            this._timeStampLine.setVisible(true);
            try {
                String line;
                System.out.println("fillForm:reading:" + file.getPath());
                while ((line = reader.readLine()) != null) {
                    buffer.append(line);
                    buffer.append(localSep);
                }
            }
            catch (IOException ioe) {
                System.out.println("fillForm: Error reading " + id.getPath() + " Error:" + ioe);
                boolean bl = false;
                return bl;
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            long lastMod = file.lastModified();
            Date d = new Date(lastMod);
            SimpleDateFormat fmt = new SimpleDateFormat("MM/dd/yyyy HH:mm aa");
            this._timeStampLine.setText(fmt.format(d));
            this._editorPanel.setText(buffer.toString());
        }
        return true;
    }

    public void fillForm(String text) {
        this._timeStampLine.setVisible(false);
        if (text == null) {
            this._editorPanel.setText("");
            return;
        }
        this._editorPanel.setText(text);
    }

    public String getSelectionBlock() {
        return this._editorPanel.getSelectionBlock();
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!visible) {
            Dimension size = this.getSize();
            this._editorPanel.saveProp(WINDOW_SIZE_PROP, size.width + "," + size.height);
        }
    }

    public void saveAsAction() {
    }

    public boolean saveAction(HecFile file) {
        return this._editorPanel.saveAction(file);
    }

    public boolean canCreateMenus() {
        return true;
    }

    public void setEditorFont(Font f) {
        this._editorPanel.setEditorFont(f);
    }

    public Font getEditorFont() {
        return this._editorPanel.getEditorFont();
    }

    public JTextArea getTextArea() {
        return this._editorPanel.getTextArea();
    }

    private class EditorPanel
    extends AbstractTextEditorPanel {
        private JCheckBoxMenuItem _wordWrapMenuItem;
        private boolean _canSaveAs;

        EditorPanel(boolean canSaveAs) {
            this._canSaveAs = canSaveAs;
            this._txtArea.addCaretListener(new CaretListener(){

                @Override
                public void caretUpdate(CaretEvent e) {
                    try {
                        int pos = EditorPanel.this._txtArea.getCaretPosition();
                        int line = EditorPanel.this._txtArea.getLineOfOffset(pos);
                        int col = pos - EditorPanel.this._txtArea.getLineStartOffset(line);
                        TextEditorPanel.this._positionLine.setText(String.valueOf(line + 1) + ":" + (col + 1));
                    }
                    catch (Exception ee) {
                        System.out.println(ee);
                        TextEditorPanel.this._positionLine.setText("");
                    }
                    int start = EditorPanel.this._txtArea.getSelectionStart();
                    int end = EditorPanel.this._txtArea.getSelectionEnd();
                    if (start > -1 && end > -1) {
                        TextEditorPanel.this._insertLine.setText(EditorPanel.this.getLineColumn(start) + ".." + EditorPanel.this.getLineColumn(end));
                    } else {
                        TextEditorPanel.this._insertLine.setText("");
                    }
                }
            });
        }

        protected String getLineColumn(int position) {
            try {
                int line = this._txtArea.getLineOfOffset(position);
                int col = position - this._txtArea.getLineStartOffset(line);
                return String.valueOf(line + 1) + ":" + (col + 1);
            }
            catch (Exception ee) {
                System.out.println(ee);
                return "";
            }
        }

        public String getSelectionBlock() {
            return TextEditorPanel.this._insertLine.getText();
        }

        protected void saveAsAction() {
            TextEditorPanel.this.saveAsAction();
        }

        @Override
        protected boolean canCreateMenus() {
            return TextEditorPanel.this.canCreateMenus();
        }

        @Override
        public boolean canSaveAs() {
            return this._canSaveAs;
        }

        @Override
        public JMenuBar createMenus() {
            JMenuBar mbar = super.createMenus();
            if (mbar != null) {
                JMenu formatMenu = new JMenu("Format");
                formatMenu.setMnemonic('o');
                mbar.add(formatMenu);
                this._wordWrapMenuItem = new JCheckBoxMenuItem("Word Wrap");
                this._wordWrapMenuItem.setMnemonic('W');
                this._wordWrapMenuItem.addActionListener(this._listener.add(this, this._wordWrapMenuItem, "wordWrapAction"));
                formatMenu.add(this._wordWrapMenuItem);
                JMenuItem menuItem = new JMenuItem("Font...", 70);
                menuItem.addActionListener(this._listener.add(this, menuItem, "fontAction"));
                formatMenu.add(menuItem);
            }
            return mbar;
        }

        public void wordWrapAction() {
            boolean wrapIt = this._wordWrapMenuItem.isSelected();
            this.setWordWrap(wrapIt);
            this.saveProp(TextEditorPanel.WORD_WRAP_PROP, String.valueOf(wrapIt));
        }

        public void setWordWrap(boolean wrapIt) {
            this._txtArea.setLineWrap(wrapIt);
            this._txtArea.setWrapStyleWord(wrapIt);
            if (this._wordWrapMenuItem != null && this._wordWrapMenuItem.isSelected() != wrapIt) {
                this._wordWrapMenuItem.setSelected(wrapIt);
            }
        }

        public void fontAction() {
            Window w = SwingUtilities.windowForComponent(this);
            FontChooser chooser = null;
            if (w instanceof JDialog) {
                chooser = new FontChooser((Dialog)((JDialog)w), "Select Font", true, this._txtArea.getFont());
            } else if (w instanceof JFrame) {
                chooser = new FontChooser((Frame)((JFrame)w), "Select Font", true, this._txtArea.getFont());
            }
            Font f = chooser.getSelectedFont();
            if (f == null) {
                return;
            }
            this._txtArea.setFont(f);
            this.saveProp(TextEditorPanel.FONT_PROP, RMAUtil.getFontString(f));
        }

        void saveProp(String propKey, String propValue) {
            if (!ClientAppCheck.haveClientApp()) {
                return;
            }
        }

        @Override
        public boolean saveAction() {
            if (TextEditorPanel.this._identifier == null) {
                return true;
            }
            return this.saveAction(TextEditorPanel.this._identifier.getFile());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean saveAction(HecFile file) {
            String localSep;
            if (file == null) {
                return false;
            }
            BufferedWriter writer = file.getBufferedWriter();
            String text = this.getText();
            boolean replaceSep = false;
            String lineSep = file.getLineSeparator();
            boolean bl = replaceSep = !lineSep.equals(localSep = System.getProperty("line.separator"));
            if (replaceSep) {
                text = RMAIO.replace(text, localSep, lineSep);
            }
            try {
                writer.write(text);
            }
            catch (IOException ioe) {
                System.out.println("saveAction: Error writing " + TextEditorPanel.this._identifier.getPath() + " Error:" + ioe);
                boolean bl2 = false;
                return bl2;
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return true;
        }

        public void setEditorFont(Font f) {
            this._txtArea.setFont(f);
        }

        public Font getEditorFont() {
            return this._txtArea.getFont();
        }

        @Override
        public JTextArea getTextArea() {
            return super.getTextArea();
        }
    }
}

