/*
 * Decompiled with CFR 0.152.
 */
package hec.data;

import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.data.Units;
import hec.lang.NamedType;
import hec.util.BaseXMLUtilities;
import hec.util.XMLUtilities;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Element;
import rma.util.RMAConst;

public abstract class AbstractJDomDataObject
extends NamedType {
    public static final String YYYY = "yyyy";
    public static final String MM_MYYYY = "MMMyyyy";
    public static final String DD_MM_MYYYY = "ddMMMyyyy";
    public static final String DD_MM_MYYYY_HHMM = "ddMMMyyyy HH:mm";
    public static final String DD_MM_MYYYY_HHMMZ = "ddMMMyyyy HH:mmZ";
    private static final String[] DATE_FORMATS = new String[]{"ddMMMyyyy", "MMMyyyy", "yyyy", "ddMMMyyyy HH:mm"};
    private static final Logger logger = Logger.getLogger(AbstractJDomDataObject.class.getName());
    public static final String UNIT = "unit";

    public abstract void buildElement(Element var1);

    protected int parseInt(Element parentElement, String childElementName, String[] units, int defaultValue) {
        int val = defaultValue;
        Element child = parentElement.getChild(childElementName);
        if (child != null) {
            val = XMLUtilities.getContentAsInt(child, defaultValue);
            if (units != null) {
                units[0] = child.getAttributeValue(UNIT);
            }
        }
        return val;
    }

    protected double parseFormattedDouble(Element parentElement, String childElementName, String[] units, double defaultValue) {
        DecimalFormat df = (DecimalFormat)DecimalFormat.getNumberInstance();
        double val = defaultValue;
        try {
            Element child = parentElement.getChild(childElementName);
            if (child != null) {
                val = df.parse(child.getText()).doubleValue();
            }
        }
        catch (ParseException e) {
            logger.warning("parseFormattedDouble:Caught ParseException.\n" + e.getLocalizedMessage());
        }
        return val;
    }

    protected double parseDouble(Element parentElement, String childElementName, String[] units, double defaultValue) {
        double val = defaultValue;
        Element child = parentElement.getChild(childElementName);
        if (child != null) {
            val = XMLUtilities.getContentAsDouble(child, defaultValue);
            if (units != null) {
                units[0] = child.getAttributeValue(UNIT);
            }
        }
        return val;
    }

    public static String camelCaseToLowerUnderbar(String word) {
        if (word != null) {
            Pattern pattern = Pattern.compile("([A-Z]|[a-z])[a-z]*");
            ArrayList<Object> tokens = new ArrayList<Object>();
            Matcher matcher = pattern.matcher(word);
            Object acronym = "";
            while (matcher.find()) {
                String found = matcher.group();
                if (found.matches("^[A-Z]$")) {
                    acronym = (String)acronym + found;
                    continue;
                }
                if (((String)acronym).length() > 0) {
                    tokens.add(acronym);
                    acronym = "";
                }
                tokens.add(found);
            }
            if (((String)acronym).length() > 0) {
                tokens.add(acronym);
            }
            if (!tokens.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append((String)tokens.remove(0));
                for (String string : tokens) {
                    sb.append('_');
                    sb.append(string);
                }
                return sb.toString().toLowerCase();
            }
        }
        return word;
    }

    private static String removePrefix(String in, String prefix) {
        if (in.startsWith(prefix)) {
            return in.substring(prefix.length());
        }
        return in;
    }

    private static String removeSuffix(String in, String suffix) {
        if (in.endsWith(suffix)) {
            return in.substring(0, in.length() - suffix.length());
        }
        return in;
    }

    protected String getDefaultElementName() {
        String className = this.getClass().getName();
        String justClassName = className.substring(className.lastIndexOf(46) + 1);
        String middlePart = AbstractJDomDataObject.removeSuffix(AbstractJDomDataObject.removePrefix(justClassName, "JDom"), "Impl");
        return AbstractJDomDataObject.camelCaseToLowerUnderbar(middlePart);
    }

    public String toXmlString() {
        String retval = null;
        Element element = new Element(this.getDefaultElementName());
        this.buildElement(element);
        try {
            retval = BaseXMLUtilities.toXmlString(element);
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "toXmlString:Caught IOException.", ex);
        }
        return retval;
    }

    public static double getXmlValue(ParamDouble paramDouble, Element parent, String childElementName, int paramId) {
        String xmlUnit = XMLUtilities.getChildElementAttribute(parent, childElementName, UNIT);
        double value = XMLUtilities.getChildElementAsDouble(parent, childElementName, Double.NEGATIVE_INFINITY);
        if (xmlUnit == null || RMAConst.isUndefinedValue(value)) {
            return value;
        }
        int xmlUnitSys = Units.getUnitSystemForUnits(xmlUnit);
        if (!Units.isValidUnitsSystem(xmlUnitSys)) {
            logger.severe("Could not find a valid unit system for unit:" + xmlUnit);
        }
        paramDouble.setValue(value);
        paramDouble.setParameterId(paramId);
        paramDouble.setUnitSystem(xmlUnitSys);
        value = paramDouble.convertToUnitSystem(2);
        return value;
    }

    public static void setXmlValue(ParamDouble paramDouble, Element parent, String childElementName, Double value, int paramId) {
        Element child = XMLUtilities.getOrCreateChild(parent, childElementName);
        if (value == null || RMAConst.isUndefinedValue(value)) {
            child.setText("");
        } else {
            String xmlUnit = child.getAttributeValue(UNIT);
            if (xmlUnit != null && paramId != -1) {
                int xmlUnitSys = Units.getUnitSystemForUnits(xmlUnit);
                if (!Units.isValidUnitsSystem(xmlUnitSys)) {
                    logger.severe("Units system " + xmlUnitSys + " is not a valid unit system");
                }
                paramDouble.setParameterId(paramId);
                paramDouble.setUnitSystem(2);
                paramDouble.setValue(value);
                value = paramDouble.convertToUnitSystem(xmlUnitSys);
            } else {
                String paramUnit = Parameter.getUnitsStringForSystem(paramId, 2);
                if (paramUnit != null) {
                    child.setAttribute(UNIT, paramUnit);
                }
            }
            child.setText(Double.toString(value));
        }
    }

    public static Date getXmlDate(Element parent, String childElementName, String dateFormat) {
        if (parent == null || childElementName == null) {
            return null;
        }
        String dateString = parent.getChildText(childElementName);
        if (dateString != null && !dateString.isEmpty()) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
                sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
                Date date = sdf.parse(dateString);
                return date;
            }
            catch (ParseException e) {
                for (int ii = 0; ii < DATE_FORMATS.length; ++ii) {
                    try {
                        dateFormat = DATE_FORMATS[ii];
                        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
                        Date date = sdf.parse(dateString);
                        return date;
                    }
                    catch (ParseException parseException) {
                        continue;
                    }
                }
                logger.log(Level.FINE, "Error parsing " + childElementName + " date " + dateString + " as " + dateFormat);
            }
        }
        return null;
    }

    public static void setXmlDate(Element element, String childElementName, String dateFormat, Date date) {
        String dateString = "";
        if (date != null) {
            SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
            sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
            dateString = sdf.format(date);
        }
        Element child = XMLUtilities.getOrCreateChild(element, childElementName);
        child.setText(dateString);
    }

    protected Element buildElementOrRemove(Element element, String childElementName, AbstractJDomDataObject jdom) {
        Element child = XMLUtilities.getOrCreateChild(element, childElementName);
        if (jdom != null) {
            jdom.buildElement(child);
        } else {
            child.removeContent();
        }
        return child;
    }
}

