/*
 * Decompiled with CFR 0.152.
 */
package hec.data;

import hec.data.AbstractDataSet;
import hec.data.DataSetIllegalArgumentException;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import mil.army.usace.hec.metadata.DurationFactory;

@Deprecated
public class Duration
extends AbstractDataSet
implements Serializable {
    private static final long serialVersionUID = -7756414144362179395L;
    private mil.army.usace.hec.metadata.Duration _duration;

    public Duration() throws DataSetIllegalArgumentException {
        this(0, true);
    }

    public Duration(int minutes) throws DataSetIllegalArgumentException {
        this(minutes, true);
    }

    public Duration(String durationName) throws DataSetIllegalArgumentException {
        this(durationName.endsWith("BOP") ? durationName.replace("BOP", "") : durationName, !durationName.endsWith("BOP"));
    }

    public Duration(String durationName, String durationPosition) throws DataSetIllegalArgumentException {
        block5: {
            if (durationName.startsWith("~")) {
                throw new DataSetIllegalArgumentException("~ is not a valid duration prefix" + durationPosition);
            }
            try {
                if ("BOP".equalsIgnoreCase(durationPosition)) {
                    this._duration = (mil.army.usace.hec.metadata.Duration)DurationFactory.findAny(DurationFactory.equalsName((String)durationName).and(DurationFactory.isBOP())).orElseThrow(() -> new mil.army.usace.hec.metadata.DataSetIllegalArgumentException("Interval not found in the standard set of durations: " + durationName));
                    break block5;
                }
                if ("EOP".equalsIgnoreCase(durationPosition)) {
                    this._duration = (mil.army.usace.hec.metadata.Duration)DurationFactory.findAny(DurationFactory.equalsName((String)durationName).and(DurationFactory.isEOP())).orElseThrow(() -> new mil.army.usace.hec.metadata.DataSetIllegalArgumentException("Interval not found in the standard set of durations: " + durationName));
                    break block5;
                }
                throw new DataSetIllegalArgumentException("Duration Position (BOP, EOP) is not valid: " + durationPosition);
            }
            catch (mil.army.usace.hec.metadata.DataSetIllegalArgumentException e) {
                throw new DataSetIllegalArgumentException((Exception)((Object)e));
            }
        }
    }

    public Duration(int minutes, String durationPosition) throws DataSetIllegalArgumentException {
        block4: {
            try {
                if ("BOP".equalsIgnoreCase(durationPosition)) {
                    this._duration = (mil.army.usace.hec.metadata.Duration)DurationFactory.findAny(DurationFactory.equalsMinutes((int)minutes).and(DurationFactory.isBOP())).orElseThrow(() -> new mil.army.usace.hec.metadata.DataSetIllegalArgumentException("Interval not found in the standard set of durations: " + minutes + " minutes"));
                    break block4;
                }
                if ("EOP".equalsIgnoreCase(durationPosition)) {
                    this._duration = (mil.army.usace.hec.metadata.Duration)DurationFactory.findAny(DurationFactory.equalsMinutes((int)minutes).and(DurationFactory.isEOP())).orElseThrow(() -> new mil.army.usace.hec.metadata.DataSetIllegalArgumentException("Interval not found in the standard set of durations: " + minutes + " minutes"));
                    break block4;
                }
                throw new DataSetIllegalArgumentException("Duration Position (BOP, EOP) is not valid: " + durationPosition);
            }
            catch (mil.army.usace.hec.metadata.DataSetIllegalArgumentException e) {
                throw new DataSetIllegalArgumentException((Exception)((Object)e));
            }
        }
    }

    public Duration(String durationName, boolean isEndOfPeriod) throws DataSetIllegalArgumentException {
        if (durationName.startsWith("~")) {
            throw new DataSetIllegalArgumentException("~ is not a valid duration prefix");
        }
        try {
            Predicate durationPredicate = DurationFactory.equalsName((String)durationName);
            durationPredicate = isEndOfPeriod ? durationPredicate.and(DurationFactory.isEOP()) : durationPredicate.and(DurationFactory.isBOP());
            this._duration = (mil.army.usace.hec.metadata.Duration)DurationFactory.findAny(durationPredicate).orElseThrow(() -> new mil.army.usace.hec.metadata.DataSetIllegalArgumentException("Interval not found in the standard set of durations: " + durationName));
        }
        catch (mil.army.usace.hec.metadata.DataSetIllegalArgumentException e) {
            throw new DataSetIllegalArgumentException((Exception)((Object)e));
        }
    }

    public Duration(int minutes, boolean isEndOfPeriod) throws DataSetIllegalArgumentException {
        try {
            Predicate durationPredicate = DurationFactory.equalsMinutes((int)minutes);
            durationPredicate = isEndOfPeriod ? durationPredicate.and(DurationFactory.isEOP()) : durationPredicate.and(DurationFactory.isBOP());
            this._duration = (mil.army.usace.hec.metadata.Duration)DurationFactory.findAny(durationPredicate).orElseThrow(() -> new mil.army.usace.hec.metadata.DataSetIllegalArgumentException("Interval not found in the standard set of durations: " + minutes + " minutes"));
        }
        catch (mil.army.usace.hec.metadata.DataSetIllegalArgumentException e) {
            throw new DataSetIllegalArgumentException((Exception)((Object)e));
        }
    }

    public Duration(Duration duration) {
        this._duration = duration._duration;
    }

    public boolean isEndOfPeriod() {
        return this._duration.isEndOfPeriod();
    }

    public String toString() {
        return this._duration.toString();
    }

    public static String[] getAvailableDurations() {
        return (String[])DurationFactory.findAll(i -> true).stream().sorted(Comparator.comparing(mil.army.usace.hec.metadata.Duration::getMinutes).thenComparing(mil.army.usace.hec.metadata.Duration::isEndOfPeriod)).map(mil.army.usace.hec.metadata.Duration::toString).toArray(String[]::new);
    }

    public int getSeconds() {
        return this._duration.getSeconds();
    }

    public int getMillis() {
        return (int)TimeUnit.SECONDS.toMillis(this._duration.getSeconds());
    }

    public mil.army.usace.hec.metadata.Duration getMetaDataDuration() {
        return this._duration;
    }

    public void setDuration(String intervalName) throws DataSetIllegalArgumentException {
        try {
            Predicate durationPredicate = DurationFactory.equalsName((String)intervalName);
            durationPredicate = this.isEndOfPeriod() ? durationPredicate.and(DurationFactory.isEOP()) : durationPredicate.and(DurationFactory.isBOP());
            this._duration = (mil.army.usace.hec.metadata.Duration)DurationFactory.findAny(durationPredicate).orElseThrow(() -> new mil.army.usace.hec.metadata.DataSetIllegalArgumentException("Interval not found in the standard set of durations: " + intervalName));
        }
        catch (mil.army.usace.hec.metadata.DataSetIllegalArgumentException e) {
            throw new DataSetIllegalArgumentException((Exception)((Object)e));
        }
    }

    public void setDuration(int minutes) throws DataSetIllegalArgumentException {
        try {
            Predicate durationPredicate = DurationFactory.equalsMinutes((int)minutes);
            durationPredicate = this.isEndOfPeriod() ? durationPredicate.and(DurationFactory.isEOP()) : durationPredicate.and(DurationFactory.isBOP());
            this._duration = (mil.army.usace.hec.metadata.Duration)DurationFactory.findAny(durationPredicate).orElseThrow(() -> new mil.army.usace.hec.metadata.DataSetIllegalArgumentException("Interval not found in the standard set of durations: " + minutes + " minutes"));
        }
        catch (mil.army.usace.hec.metadata.DataSetIllegalArgumentException e) {
            throw new DataSetIllegalArgumentException((Exception)((Object)e));
        }
    }

    public int hashCode() {
        return this._duration.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Duration other = (Duration)obj;
        return Objects.equals(this._duration, other._duration);
    }

    public int getMinutes() {
        return (int)TimeUnit.SECONDS.toMinutes(this.getSeconds());
    }
}

