/*
 * Decompiled with CFR 0.152.
 */
package hec.data;

import hec.data.AbstractDataSet;
import hec.data.DataSetIllegalArgumentException;
import hec.data.IntervalOffset;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import java.util.TimeZone;
import java.util.function.Predicate;
import java.util.logging.Logger;
import mil.army.usace.hec.metadata.IntervalFactory;

@Deprecated
public class Interval
extends AbstractDataSet
implements Serializable {
    private static final Logger LOGGER = Logger.getLogger(Interval.class.getName());
    private static final long serialVersionUID = -8511673889338772969L;
    public static final int SECONDS_IN_DAY = 86400;
    public static final long MILLIS_IN_DAY = 86400000L;
    public static final int YEAR_SECONDS = 31536000;
    public static final int MONTH_SECONDS = 2592000;
    public static final int WEEK_SECONDS = 604800;
    public static final int DAY_SECONDS = 86400;
    public static final int HOUR_SECONDS = 3600;
    public static final int MINUTE_SECONDS = 60;
    private mil.army.usace.hec.metadata.Interval _interval;

    public Interval(String intervalName) throws DataSetIllegalArgumentException {
        this.setInterval(intervalName);
    }

    public Interval(mil.army.usace.hec.metadata.Interval interval) {
        this._interval = interval;
    }

    public Interval(int minutes) throws DataSetIllegalArgumentException {
        this.setInterval(minutes);
    }

    protected Interval(String intervalName, String exceptName) throws DataSetIllegalArgumentException {
        this.setInterval(intervalName);
    }

    protected Interval(int minutes, String exceptName) throws DataSetIllegalArgumentException {
        this.setInterval(minutes);
    }

    public Interval(Interval anotherInterval) {
        this._interval = anotherInterval._interval;
    }

    public int hashCode() {
        int hash = 5;
        hash = 89 * hash + this._interval.hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Interval other = (Interval)obj;
        return Objects.equals(this._interval, other._interval);
    }

    public String toString() {
        return this._interval.toString();
    }

    public String getInterval() {
        return this._interval.getInterval();
    }

    public void setInterval(String intervalName) throws DataSetIllegalArgumentException {
        this.parseIntervalName(intervalName);
    }

    public void setInterval(int minutes) throws DataSetIllegalArgumentException {
        try {
            this._interval = minutes == IntervalFactory.irregular().getMinutes() ? IntervalFactory.irregular() : (mil.army.usace.hec.metadata.Interval)IntervalFactory.findAny(IntervalFactory.equalsMinutes((int)minutes).and(IntervalFactory.isRegular())).orElseThrow(() -> new mil.army.usace.hec.metadata.DataSetIllegalArgumentException("Interval not found in the standard set of intervals: " + minutes + " minutes"));
        }
        catch (mil.army.usace.hec.metadata.DataSetIllegalArgumentException e) {
            throw new DataSetIllegalArgumentException((Exception)((Object)e));
        }
    }

    public static String[] getAvailableIntervals() {
        return (String[])IntervalFactory.findAll(i -> true).stream().sorted(Comparator.comparing(i -> !i.equals(IntervalFactory.irregular())).thenComparing(i -> !i.isRegular()).thenComparing(interval -> Math.abs(interval.getMinutes()))).map(mil.army.usace.hec.metadata.Interval::getInterval).distinct().toArray(String[]::new);
    }

    public int getSeconds() {
        return this._interval.getSeconds();
    }

    @Deprecated
    public static long getTimeAtTopOfIntervalOnOrBefore(long time, String intervalName, TimeZone timeZone) throws DataSetIllegalArgumentException {
        return Interval.getTimeOnPreviousInterval(time, new Interval(intervalName), null, timeZone);
    }

    public static long getTimeOnPreviousInterval(long time, Interval interval, IntervalOffset intervalOffset, TimeZone timeZone) throws DataSetIllegalArgumentException {
        try {
            mil.army.usace.hec.metadata.IntervalOffset intervalOffsetMetaData = null;
            if (intervalOffset != null) {
                intervalOffsetMetaData = intervalOffset.getIntervalOffsetMetaData();
            }
            return interval._interval.getTimeOnPreviousOrCurrentInterval(time, intervalOffsetMetaData, timeZone);
        }
        catch (mil.army.usace.hec.metadata.DataSetIllegalArgumentException e) {
            throw new DataSetIllegalArgumentException((Exception)((Object)e));
        }
    }

    @Deprecated
    public static long getTimeAtTopOfIntervalOnOrAfter(long time, String intervalName, TimeZone timeZone) throws DataSetIllegalArgumentException {
        return Interval.getTimeOnNextInterval(time, new Interval(intervalName), null, timeZone);
    }

    public static long getTimeOnNextInterval(long time, Interval interval, IntervalOffset intervalOffset, TimeZone timeZone) throws DataSetIllegalArgumentException {
        try {
            mil.army.usace.hec.metadata.IntervalOffset intervalOffsetMetaData = null;
            if (intervalOffset != null) {
                intervalOffsetMetaData = intervalOffset.getIntervalOffsetMetaData();
            }
            return interval._interval.getTimeOnNextOrCurrentInterval(time, intervalOffsetMetaData, timeZone);
        }
        catch (mil.army.usace.hec.metadata.DataSetIllegalArgumentException e) {
            throw new DataSetIllegalArgumentException((Exception)((Object)e));
        }
    }

    public boolean isLessThanDecade() {
        return this._interval.isLessThanDecade();
    }

    public boolean isLessThanYearly() {
        return this._interval.isLessThanYearly();
    }

    public boolean isLessThanMonthly() {
        return this._interval.isLessThanMonthly();
    }

    public boolean isLessThanWeekly() {
        return this._interval.isLessThanWeekly();
    }

    public boolean isLessThanDaily() {
        return this._interval.isLessThanDaily();
    }

    public boolean isLessThanHourly() {
        return this._interval.isLessThanHourly();
    }

    @Deprecated
    public static long getTimeAtNextInterval(long time, String intervalName, TimeZone timeZone) throws DataSetIllegalArgumentException {
        Interval tempInterval = new Interval(intervalName);
        return Interval.getNextIntervalTime(time, tempInterval, timeZone);
    }

    public static long getNextIntervalTime(long time, Interval interval, TimeZone timeZone) throws DataSetIllegalArgumentException {
        try {
            return interval._interval.getNextIntervalTime(time, timeZone);
        }
        catch (mil.army.usace.hec.metadata.DataSetIllegalArgumentException e) {
            throw new DataSetIllegalArgumentException((Exception)((Object)e));
        }
    }

    public static long getPreviousIntervalTime(long time, Interval interval, TimeZone timeZone) throws DataSetIllegalArgumentException {
        try {
            return interval._interval.getPreviousIntervalTime(time, timeZone);
        }
        catch (mil.army.usace.hec.metadata.DataSetIllegalArgumentException e) {
            throw new DataSetIllegalArgumentException((Exception)((Object)e));
        }
    }

    public static long calcNumberOfIntervals(Date startTime, Date endTime, Interval interval, IntervalOffset intervalOffset, TimeZone timeZone) throws DataSetIllegalArgumentException {
        try {
            mil.army.usace.hec.metadata.IntervalOffset intervalOffsetMetaData = null;
            if (intervalOffset != null) {
                intervalOffsetMetaData = intervalOffset.getIntervalOffsetMetaData();
            }
            return interval._interval.calcNumberOfIntervals(startTime, endTime, intervalOffsetMetaData, timeZone);
        }
        catch (mil.army.usace.hec.metadata.DataSetIllegalArgumentException e) {
            throw new DataSetIllegalArgumentException((Exception)((Object)e));
        }
    }

    public long getMillis() {
        return this._interval.getMillis();
    }

    public int getMinutes() {
        return this._interval.getMinutes();
    }

    public boolean isRegular() {
        return this._interval.isRegular();
    }

    public boolean isNotRegular() {
        return !this._interval.isRegular();
    }

    public boolean isHourly() {
        return this._interval.isHourly();
    }

    public boolean isDaily() {
        return this._interval.isDaily();
    }

    public boolean isWeekly() {
        return this._interval.isWeekly();
    }

    public boolean isMonthly() {
        return this._interval.isMonthly();
    }

    public boolean isYearly() {
        return this._interval.isYearly();
    }

    public static int parseForInterval(String intervalName) throws DataSetIllegalArgumentException {
        return Interval.parseIntervalStringName(intervalName).getSeconds();
    }

    private static mil.army.usace.hec.metadata.Interval parseIntervalStringName(String intervalName) throws DataSetIllegalArgumentException {
        try {
            Optional regularOrPseudoRegular = IntervalFactory.findAny(IntervalFactory.equalsName((String)intervalName).and(IntervalFactory.isIrregular().or(IntervalFactory.isRegular())));
            if (regularOrPseudoRegular.isPresent()) {
                return (mil.army.usace.hec.metadata.Interval)regularOrPseudoRegular.get();
            }
            return (mil.army.usace.hec.metadata.Interval)IntervalFactory.findAny((Predicate)IntervalFactory.equalsName((String)intervalName)).orElseThrow(() -> new mil.army.usace.hec.metadata.DataSetIllegalArgumentException("Interval not found in the standard set of intervals: " + intervalName));
        }
        catch (mil.army.usace.hec.metadata.DataSetIllegalArgumentException e) {
            throw new DataSetIllegalArgumentException((Exception)((Object)e));
        }
    }

    protected void parseIntervalName(String intervalName) throws DataSetIllegalArgumentException {
        this._interval = Interval.parseIntervalStringName(intervalName);
    }

    public static boolean isRegular(int intervalMinutes) {
        return IntervalFactory.findAny(IntervalFactory.isRegular().and(IntervalFactory.equalsMinutes((int)intervalMinutes))).isPresent();
    }

    public int getCalendarField() {
        if (this.isLessThanHourly()) {
            return 12;
        }
        if (this.isLessThanDaily()) {
            return 10;
        }
        if (this.isLessThanWeekly()) {
            return 5;
        }
        if (this.isLessThanMonthly()) {
            return 3;
        }
        if (this.isLessThanYearly()) {
            return 2;
        }
        if (this.isLessThanDecade()) {
            return 1;
        }
        return 1;
    }

    public int getCalendarAmount() {
        return this._interval.getCalendarAmount();
    }

    public mil.army.usace.hec.metadata.Interval getMetaDataInterval() {
        return this._interval;
    }
}

