/*
 * Decompiled with CFR 0.152.
 */
package hec.data;

import hec.data.DataSetIllegalArgumentException;
import hec.data.IllegalIntervalOffsetException;
import hec.data.Interval;
import hec.data.IntervalOffsetPart;
import java.util.List;
import java.util.stream.Collectors;

@Deprecated
public class IntervalOffset {
    private mil.army.usace.hec.metadata.IntervalOffset _intervalOffset = mil.army.usace.hec.metadata.IntervalOffset.zeroOffset();
    private int _intervalSeconds = Integer.MIN_VALUE;

    public IntervalOffset() {
    }

    public IntervalOffset(int offsetSeconds, int intervalSeconds) throws IllegalIntervalOffsetException {
        this.validate(offsetSeconds, intervalSeconds);
        this._intervalSeconds = intervalSeconds;
        this._intervalOffset = mil.army.usace.hec.metadata.IntervalOffset.fromSeconds((int)offsetSeconds);
    }

    public IntervalOffset(IntervalOffset intervalOffset) {
        this._intervalSeconds = intervalOffset._intervalSeconds;
        this._intervalOffset = mil.army.usace.hec.metadata.IntervalOffset.fromSeconds((int)intervalOffset.getOffsetSeconds());
    }

    public mil.army.usace.hec.metadata.IntervalOffset getIntervalOffsetMetaData() {
        return this._intervalOffset;
    }

    private void validate(int offsetSeconds, int intervalSeconds) throws IllegalIntervalOffsetException {
        Interval interval;
        if (intervalSeconds == Integer.MIN_VALUE) {
            return;
        }
        if (intervalSeconds == 0) {
            if (offsetSeconds == Integer.MIN_VALUE) {
                return;
            }
            String error = "Interval offset for Irregular interval must be set to, " + IntervalOffset.getIntervalOffsetString(Integer.MIN_VALUE) + ".";
            throw new IllegalIntervalOffsetException(error);
        }
        if (mil.army.usace.hec.metadata.IntervalOffset.isNoOffset((int)offsetSeconds)) {
            String error = "Interval offset for non-irregular interval cannot be set to, " + IntervalOffset.getIntervalOffsetString(Integer.MIN_VALUE) + ". Interval: " + intervalSeconds;
            throw new IllegalIntervalOffsetException(error);
        }
        if (offsetSeconds == Integer.MAX_VALUE) {
            return;
        }
        try {
            interval = new Interval(intervalSeconds / 60);
        }
        catch (DataSetIllegalArgumentException e) {
            throw new IllegalIntervalOffsetException(e);
        }
        if (Math.abs(offsetSeconds) >= intervalSeconds) {
            String error = "Interval offset, " + IntervalOffset.getIntervalOffsetString(offsetSeconds) + ", must be less than the Interval, " + interval + ".";
            throw new IllegalIntervalOffsetException(error);
        }
    }

    public void setPartsList(List<IntervalOffsetPart> partsList) throws IllegalIntervalOffsetException {
        int partsOffset = mil.army.usace.hec.metadata.IntervalOffset.computeIntervalOffset(partsList);
        this.validate(partsOffset, this._intervalSeconds);
        this._intervalOffset = mil.army.usace.hec.metadata.IntervalOffset.fromSeconds((int)partsOffset);
    }

    public List<IntervalOffsetPart> getPartsList() {
        return this._intervalOffset.buildPartsList(this._intervalOffset.getOffsetSeconds()).stream().map(IntervalOffsetPart::new).collect(Collectors.toList());
    }

    public void setInterval(Interval interval) throws IllegalIntervalOffsetException {
        this.setIntervalSeconds(interval.getSeconds());
    }

    public void setIntervalSeconds(int seconds) throws IllegalIntervalOffsetException {
        this.validate(this.getOffset(), seconds);
        this._intervalSeconds = seconds;
    }

    public int getIntervalSeconds() {
        return this._intervalSeconds;
    }

    public Interval getInterval() throws DataSetIllegalArgumentException {
        return new Interval(this._intervalSeconds / 60);
    }

    public void setOffset(int offset) throws IllegalIntervalOffsetException {
        this.validate(offset, this._intervalSeconds);
        this._intervalOffset = mil.army.usace.hec.metadata.IntervalOffset.fromSeconds((int)offset);
    }

    public int getOffset() {
        return this._intervalOffset.getOffsetSeconds();
    }

    public String getIntervalOffsetString() {
        return this._intervalOffset.getIntervalOffsetString();
    }

    public String toString() {
        return this._intervalOffset.toString();
    }

    public static String getIntervalOffsetString(int offsetSeconds) {
        return mil.army.usace.hec.metadata.IntervalOffset.getIntervalOffsetString((int)offsetSeconds);
    }

    public void setIntervalOffset(String offsetString) throws IllegalIntervalOffsetException {
        try {
            if (offsetString.equalsIgnoreCase("N/A")) {
                this._intervalSeconds = 0;
            } else if (offsetString.equalsIgnoreCase("UNDEFINED")) {
                this._intervalSeconds = Integer.MIN_VALUE;
            }
            mil.army.usace.hec.metadata.IntervalOffset newOffset = mil.army.usace.hec.metadata.IntervalOffset.fromString((String)offsetString);
            this.validate(newOffset.getOffsetSeconds(), this._intervalSeconds);
            this._intervalOffset = newOffset;
        }
        catch (mil.army.usace.hec.metadata.IllegalIntervalOffsetException e) {
            throw new IllegalIntervalOffsetException((Exception)((Object)e));
        }
    }

    public long getOffsetMillis() {
        return this._intervalOffset.getOffsetMillis();
    }

    public int getOffsetSeconds() {
        return this._intervalOffset.getOffsetSeconds();
    }

    public boolean isDefined() {
        return this._intervalOffset.isDefined();
    }

    public static boolean isDefined(int offsetSeconds) {
        return mil.army.usace.hec.metadata.IntervalOffset.fromSeconds((int)offsetSeconds).isDefined();
    }
}

