/*
 * Decompiled with CFR 0.152.
 */
package hec.data;

import hec.data.IllegalTimeException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Iso8601Time {
    static final String timePattern = "\\s*((-)?\\d{4})-(\\d{2})-(\\d{2})T(\\d{2}):(\\d{2})(:(\\d{2})([.](\\d+))?)?(([-+]\\d{2}):(\\d{2})|Z)?\\s*";
    static final Pattern re = Pattern.compile("\\s*((-)?\\d{4})-(\\d{2})-(\\d{2})T(\\d{2}):(\\d{2})(:(\\d{2})([.](\\d+))?)?(([-+]\\d{2}):(\\d{2})|Z)?\\s*", 2);
    long time;
    boolean set = false;

    public static long parseTimeString(String timeString) throws IllegalTimeException {
        int tzMinute;
        int tzHour;
        int fraction;
        int second;
        int minute;
        int hour;
        int day;
        int month;
        int year;
        long time = 0L;
        Matcher m = re.matcher(timeString);
        if (m.matches()) {
            year = m.group(1) == null ? 0 : Integer.parseInt(m.group(1));
            month = m.group(3) == null ? 0 : Integer.parseInt(m.group(3));
            day = m.group(4) == null ? 0 : Integer.parseInt(m.group(4));
            hour = m.group(5) == null ? 0 : Integer.parseInt(m.group(5));
            minute = m.group(6) == null ? 0 : Integer.parseInt(m.group(6));
            second = m.group(8) == null ? 0 : Integer.parseInt(m.group(8));
            fraction = m.group(10) == null ? 0 : Integer.parseInt(m.group(10));
            tzHour = m.group(12) == null ? 0 : Integer.parseInt(m.group(12));
            int n = tzMinute = m.group(13) == null ? 0 : Integer.parseInt(m.group(13));
            if (year == 0) {
                throw new IllegalTimeException("Year cannot be zero.");
            }
            if (year < 0) {
                ++year;
            }
            if (fraction != 0) {
                int len;
                int i;
                for (i = len = m.group(10).length(); i < 3; ++i) {
                    fraction *= 10;
                }
                for (i = 3; i < len; ++i) {
                    fraction /= 10;
                }
            }
        } else {
            throw new IllegalTimeException("Time string \"" + timeString + "\" is not in ISO 8601 format.");
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.printf("GMT%+02d:%02d", tzHour, tzMinute);
        GregorianCalendar cal = new GregorianCalendar();
        cal.clear();
        cal.setTimeZone(TimeZone.getTimeZone(sw.toString()));
        cal.set(year, month - 1, day, hour, minute, second);
        cal.set(14, fraction);
        time = cal.getTimeInMillis();
        return time;
    }

    public static String toString(long time) {
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSz G");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        date.setTime(time);
        Object timeStr = sdf.format(date).replaceAll("UTC", "Z").replaceAll("\\.000", "").replaceAll(" AD", "");
        if (((String)timeStr).endsWith(" BC")) {
            timeStr = "-" + ((String)timeStr).substring(0, ((String)timeStr).length() - 3);
        }
        return timeStr;
    }

    public Iso8601Time() {
    }

    public Iso8601Time(long time) {
        this();
        this.set(time);
    }

    public Iso8601Time(String timeStr) throws IllegalTimeException {
        this();
        this.set(timeStr);
    }

    protected void set(long time) {
        this.time = time;
        this.set = true;
    }

    protected void set(String timeStr) throws IllegalTimeException {
        this.set(Iso8601Time.parseTimeString(timeStr));
    }

    public void setTime(long time) {
        this.set(time);
    }

    public void setTime(String timeStr) throws IllegalTimeException {
        this.set(timeStr);
    }

    public long getTime() throws IllegalTimeException {
        if (!this.set) {
            throw new IllegalTimeException("Time value has never been set.");
        }
        return this.time;
    }

    public String getTimeString() {
        return this.toString();
    }

    public String toString() {
        try {
            long ltime = this.getTime();
            return Iso8601Time.toString(ltime);
        }
        catch (IllegalTimeException e) {
            return e.getMessage();
        }
    }

    public boolean equals(long time) throws IllegalTimeException {
        return this.getTime() == time;
    }

    public boolean equals(Iso8601Time other) {
        long otime;
        long ltime;
        try {
            ltime = this.getTime();
        }
        catch (IllegalTimeException e) {
            return false;
        }
        try {
            otime = other.getTime();
        }
        catch (IllegalTimeException e) {
            return false;
        }
        return ltime == otime;
    }

    public boolean equals(Object other) {
        return other instanceof Iso8601Time ? this.equals((Iso8601Time)other) : false;
    }

    public static void main(String[] args) {
        String[] timeStrings;
        for (String timeString : timeStrings = new String[]{"2008-01-13T10:38:45.1-05:00", "0000-05-13T10:38:45.1-05:00", "-2008-05-13T10:38:45.12-05:00", "2008-05-13T10:38:45.123-05:00", "2008-05-13T10:38:45.1234-05:00", "2008-05-13T10:38:45-05:00", "2008-05-13T10:38-05:00", "2008-05-13T10-05:00", "2008-05-13-05:00", "2008-05-13T10:38:45.1", "0000-05-13T10:38:45.1", "-2008-05-13T10:38:45.12", "2008-05-13T10:38:45.123", "2008-05-13T10:38:45.1234", "2008-05-13T10:38:45", "2008-05-13T10:38", "2008-05-13T10", "2008-05-13", "2000-12-31T21:00"}) {
            try {
                System.out.print(timeString + " ");
                Iso8601Time t1 = new Iso8601Time(timeString);
                Iso8601Time t2 = new Iso8601Time(t1.getTime());
                System.out.println("== " + t2 + ": " + t1.equals(t2));
            }
            catch (Exception e) {
                System.out.println();
                System.out.println("\t" + e);
            }
        }
    }
}

