/*
 * Decompiled with CFR 0.152.
 */
package hec.data;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.xpath.XPath;

public class JDomDataObjectFactory<T1> {
    static final Logger logger = Logger.getLogger(JDomDataObjectFactory.class.getName());
    private Class<? extends T1> _objectClass;

    public JDomDataObjectFactory(Class<? extends T1> objectClass) {
        this._objectClass = objectClass;
    }

    public T1 newDataObject() throws NoSuchMethodException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Constructor<T1> constructor = this._objectClass.getConstructor(new Class[0]);
        T1 instance = constructor.newInstance(new Object[0]);
        return instance;
    }

    public List<T1> buildDataObjectList(String xmlString) throws JDOMException, IOException, SecurityException, IllegalArgumentException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Reader reader = JDomDataObjectFactory.getDocumentReader(xmlString);
        return this.buildDataObjectList(reader, null);
    }

    public static Reader getDocumentReader(String xmlString) {
        StringReader reader = new StringReader(xmlString);
        return reader;
    }

    public static Element getRootElement(Reader reader) throws JDOMException, IOException {
        SAXBuilder builder = new SAXBuilder();
        Document document = builder.build(reader);
        Element rootElement = document.getRootElement();
        return rootElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element getRootElement(String xmlString) {
        Reader documentReader = JDomDataObjectFactory.getDocumentReader(xmlString);
        Element rootElement = null;
        try {
            rootElement = JDomDataObjectFactory.getRootElement(documentReader);
        }
        catch (JDOMException e) {
            logger.log(Level.FINE, "Error parsing xml string", e);
        }
        catch (IOException e) {
            logger.log(Level.FINE, "Error parsing xml string", e);
        }
        finally {
            try {
                documentReader.close();
            }
            catch (IOException e) {}
        }
        return rootElement;
    }

    public List<T1> buildDataObjectList(Reader reader, String xpathString) throws JDOMException, IOException, SecurityException, IllegalArgumentException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Element rootElement = JDomDataObjectFactory.getRootElement(reader);
        List children = null;
        children = xpathString != null ? XPath.selectNodes((Object)rootElement, (String)xpathString) : rootElement.getChildren();
        return this.buildDataObjectList(children);
    }

    public List<T1> buildDataObjectList(Reader reader) throws JDOMException, IOException, SecurityException, IllegalArgumentException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        return this.buildDataObjectList(reader, null);
    }

    public List<T1> buildDataObjectList(List<Element> children) throws InstantiationException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchMethodException {
        Constructor<? extends T1> constructor = this._objectClass.getConstructor(Element.class);
        ArrayList<T1> instanceList = new ArrayList<T1>();
        for (int ii = 0; ii < children.size(); ++ii) {
            Element child = children.get(ii);
            T1 instance = this.buildDataObject(constructor, child);
            if (instance == null) continue;
            instanceList.add(instance);
        }
        return instanceList;
    }

    public T1 buildDataObject(Reader reader) throws JDOMException, IOException, IllegalArgumentException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Element rootElement = JDomDataObjectFactory.getRootElement(reader);
        T1 instance = this.buildDataObject(rootElement);
        return instance;
    }

    public T1 buildDataObject(String xmlContent) throws JDOMException, IOException, IllegalArgumentException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Reader documentReader = JDomDataObjectFactory.getDocumentReader(xmlContent);
        Element rootElement = JDomDataObjectFactory.getRootElement(documentReader);
        T1 instance = this.buildDataObject(rootElement);
        return instance;
    }

    public T1 buildDataObject(Element element) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchMethodException {
        Constructor<? extends T1> constructor = this._objectClass.getConstructor(Element.class);
        T1 instance = this.buildDataObject(constructor, element);
        return instance;
    }

    private T1 buildDataObject(Constructor<? extends T1> constructor, Element child) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        T1 instance = constructor.newInstance(child);
        return instance;
    }
}

