/*
 * Decompiled with CFR 0.152.
 */
package hec.data;

import hec.data.ParamDouble;
import hec.data.Parameter;

public enum ParamDoubleSupport {
    ELEV(Parameter.PARAMID_ELEV, 4),
    FLOW(Parameter.PARAMID_FLOW, 4),
    LENGTH(Parameter.PARAMID_LENGTH, 4),
    PERCENT(Parameter.PARAMID_PERCENT, 4),
    POWER(Parameter.PARAMID_POWER, 4),
    STORAGE(Parameter.PARAMID_STOR, 4),
    VOLUME(Parameter.PARAMID_VOLUME, 4),
    WIDTH(Parameter.PARAMID_WIDTH, 4);

    private final int _precision;
    private final int _parameterId;

    private ParamDoubleSupport(int parameterId, int precision) {
        this._parameterId = parameterId;
        this._precision = precision;
    }

    public int getPrecision() {
        return this._precision;
    }

    public int getParameterId() {
        return this._parameterId;
    }

    public ParamDouble buildParamDouble() {
        ParamDouble pd = new ParamDouble();
        this.initParamDouble(pd);
        return pd;
    }

    public void initParamDouble(ParamDouble pd) {
        pd.setUnitSystem(2);
        pd.setParameterId(this._parameterId);
        pd.setPrecision(this._precision);
    }

    public void convertParamDouble(ParamDouble pd, int unitSystem) {
        double convertedValue = pd.convertToUnitSystem(unitSystem);
        pd.setUnitSystem(unitSystem);
        pd.setValue(convertedValue);
        pd.setPrecision(this._precision);
    }

    public String getEnglishUnits() {
        return Parameter.getUnitsStringForSystem(this._parameterId, 1);
    }

    public String getSiUnits() {
        return Parameter.getUnitsStringForSystem(this._parameterId, 2);
    }

    public double getComparisonTolerance() {
        return 1.0E-14;
    }
}

