/*
 * Decompiled with CFR 0.152.
 */
package hec.data;

import hec.data.Parameter;
import hec.data.Units;

public class ParameterString {
    public static final String PARAM_TEMPLATE = "%S";
    private int m_paramId = -1;
    private String m_value = null;

    public ParameterString(String value, int paramId) {
        this.m_value = value;
        this.m_paramId = paramId;
    }

    public int getParameterId() {
        return this.m_paramId;
    }

    public String renderString(int unitSystem) {
        if (!Units.isValidUnitsSystem(unitSystem)) {
            throw new IllegalArgumentException("ERROR <ParameterString.renderString()> : Invalid Unit System!");
        }
        int index = -1;
        index = this.m_value.indexOf(PARAM_TEMPLATE);
        if (index == -1) {
            return this.m_value;
        }
        StringBuffer sb = new StringBuffer(this.m_value);
        String unitsLbl = Parameter.getUnitsStringForSystem(this.m_paramId, unitSystem);
        sb.replace(index, index + PARAM_TEMPLATE.length(), "");
        sb.insert(index, unitsLbl);
        return sb.toString();
    }
}

