/*
 * Decompiled with CFR 0.152.
 */
package hec.data;

import hec.data.Interval;
import hec.data.IntervalOffset;
import java.util.Calendar;
import java.util.Date;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.TimeZone;
import java.util.TreeSet;

public class TimeWindow {
    private final boolean _overrideProtection;
    private Date _startDate;
    private Date _endDate;
    private boolean _startInclusive;
    private boolean _endInclusive;

    public TimeWindow(Date startDate, boolean startInclusive, Date endDate, boolean endInclusive) {
        this._startInclusive = startInclusive;
        this._endInclusive = endInclusive;
        this._startDate = startDate;
        this._endDate = endDate;
        this._overrideProtection = false;
    }

    public TimeWindow(Date startDate, boolean startInclusive, Date endDate, boolean endInclusive, boolean overrideProtection) {
        this._startInclusive = startInclusive;
        this._endInclusive = endInclusive;
        this._startDate = startDate;
        this._endDate = endDate;
        this._overrideProtection = overrideProtection;
    }

    public boolean isEndInclusive() {
        return this._endInclusive;
    }

    public void setEndInclusive(boolean tf) {
        this._endInclusive = tf;
    }

    public boolean isStartInclusive() {
        return this._startInclusive;
    }

    public void setStartInclusive(boolean tf) {
        this._startInclusive = tf;
    }

    public Date getEndDate() {
        return this._endDate;
    }

    public void setEndDate(Date endDate) {
        this._endDate = endDate;
    }

    public Date getStartDate() {
        return this._startDate;
    }

    public void setStartDate(Date startDate) {
        this._startDate = startDate;
    }

    public boolean isStartDate(Date date) {
        return this._startDate.equals(date);
    }

    public boolean isEndDate(Date date) {
        return this._endDate.equals(date);
    }

    public boolean contains(Date date, boolean dateInclusive) {
        if (date == null) {
            return false;
        }
        int startCompare = this._startDate.compareTo(date);
        int endCompare = this._endDate.compareTo(date);
        boolean startContained = false;
        boolean endContained = false;
        if (startCompare < 0) {
            startContained = true;
        } else if (startCompare == 0 && (this._startInclusive || dateInclusive)) {
            startContained = true;
        }
        if (endCompare > 0) {
            endContained = true;
        } else if (endCompare == 0 && (this._endInclusive || dateInclusive)) {
            endContained = true;
        }
        boolean contained = startContained && endContained;
        return contained;
    }

    public boolean isOverridingProtection() {
        return this._overrideProtection;
    }

    public boolean contains(TimeWindow timeWindow) {
        Date startDate = timeWindow.getStartDate();
        Date endDate = timeWindow.getEndDate();
        boolean startInclusive = timeWindow.isStartInclusive();
        boolean endInclusive = timeWindow.isEndInclusive();
        int startCompare = this._startDate.compareTo(startDate);
        int endCompare = this._endDate.compareTo(endDate);
        boolean startContained = false;
        if (startCompare < 0) {
            startContained = true;
        } else if (startCompare == 0 && this._startInclusive && startInclusive) {
            startContained = true;
        }
        boolean endContained = false;
        if (endCompare > 0) {
            endContained = true;
        } else if (endCompare == 0 && this._endInclusive && endInclusive) {
            endContained = true;
        }
        boolean contained = startContained && endContained;
        return contained;
    }

    public NavigableSet<Date> buildDateListForInterval(Interval interval, IntervalOffset offset, TimeZone tz) {
        Objects.requireNonNull(tz);
        Objects.requireNonNull(interval);
        Objects.requireNonNull(offset);
        TreeSet<Date> output = new TreeSet<Date>();
        Calendar currentDay = this.initCalendarWithOffset(tz, this._startDate, offset);
        Calendar endCal = this.initCalendarWithOffset(tz, this._endDate, offset);
        do {
            output.add(currentDay.getTime());
            currentDay.add(interval.getCalendarField(), interval.getCalendarAmount());
        } while (!currentDay.after(endCal));
        return output;
    }

    private Calendar initCalendarWithOffset(TimeZone tz, Date date, IntervalOffset offset) {
        Calendar cal = Calendar.getInstance(tz);
        cal.setTime(date);
        cal.set(14, 0);
        cal.set(13, 0);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.add(13, offset.getOffsetSeconds());
        return cal;
    }
}

