/*
 * Decompiled with CFR 0.152.
 */
package hec.data;

import hec.data.TimeWindow;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.NavigableMap;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class TimeWindowMap {
    private final TreeMap<Date, TimeWindow> _startMap = new TreeMap();
    private final TreeMap<Date, TimeWindow> _endMap = new TreeMap();

    public void addTimeWindow(Date startDate, boolean startInclusive, Date endDate, boolean endInclusive) {
        if (startDate.after(endDate)) {
            throw new IllegalArgumentException("Start date cannot be before end date.");
        }
        TimeWindow tw = new TimeWindow(startDate, startInclusive, endDate, endInclusive);
        this.add(tw);
    }

    public void addTimeWindow(Date startDate, boolean startInclusive, Date endDate, boolean endInclusive, boolean overrideProtection) {
        if (startDate.after(endDate)) {
            throw new IllegalArgumentException("Start date cannot be before end date.");
        }
        TimeWindow tw = new TimeWindow(startDate, startInclusive, endDate, endInclusive, overrideProtection);
        this.add(tw);
    }

    public void add(TimeWindow argTw) {
        Date argTwStartDate = argTw.getStartDate();
        Date argTwEndDate = argTw.getEndDate();
        boolean argTwStartInclusive = argTw.isStartInclusive();
        boolean argTwEndInclusive = argTw.isEndInclusive();
        if (this._startMap.isEmpty()) {
            this._startMap.put(argTwStartDate, argTw);
            this._endMap.put(argTwEndDate, argTw);
            return;
        }
        Date floorKey = this._startMap.floorKey(argTwStartDate);
        Date ceilingKey = this._startMap.ceilingKey(argTwEndDate);
        if (floorKey == null) {
            floorKey = argTwStartDate;
        }
        if (ceilingKey == null) {
            ceilingKey = argTwEndDate;
        }
        NavigableMap<Date, TimeWindow> subMap = this._startMap.subMap(floorKey, true, ceilingKey, true);
        TreeMap<Date, TimeWindow> startSubMap = new TreeMap<Date, TimeWindow>((SortedMap<Date, TimeWindow>)subMap);
        boolean dontAdd = false;
        boolean startExtended = false;
        boolean endExtended = false;
        for (TimeWindow existingTimeWindow : startSubMap.values()) {
            Date existingStartDate = existingTimeWindow.getStartDate();
            Date existingEndDate = existingTimeWindow.getEndDate();
            boolean existingStartIncusive = existingTimeWindow.isStartInclusive();
            boolean existingEndInclusive = existingTimeWindow.isEndInclusive();
            if (existingTimeWindow.contains(argTw)) {
                dontAdd = true;
                break;
            }
            if (argTw.contains(existingTimeWindow)) {
                this._startMap.remove(existingStartDate);
                this._endMap.remove(existingEndDate);
            } else if (existingTimeWindow.contains(argTwStartDate, argTwStartInclusive)) {
                this._startMap.remove(existingStartDate);
                this._endMap.remove(existingEndDate);
                argTw.setStartDate(existingStartDate);
                argTwStartDate = existingStartDate;
                argTw.setStartInclusive(existingStartIncusive);
                argTwStartInclusive = existingStartIncusive;
                startExtended = true;
            } else if (existingTimeWindow.contains(argTwEndDate, argTwEndInclusive)) {
                this._startMap.remove(existingStartDate);
                this._endMap.remove(existingEndDate);
                argTw.setEndDate(existingEndDate);
                argTwEndDate = existingEndDate;
                argTw.setEndInclusive(existingEndInclusive);
                argTwEndInclusive = existingEndInclusive;
                endExtended = true;
            }
            if (!startExtended || !endExtended) continue;
            break;
        }
        if (!dontAdd) {
            this._startMap.put(argTw.getStartDate(), argTw);
            this._endMap.put(argTw.getEndDate(), argTw);
        }
    }

    public void clear() {
        this._startMap.clear();
        this._endMap.clear();
    }

    public Set<TimeWindow> getTimeWindowSet() {
        Collection<TimeWindow> values = this._startMap.values();
        return new LinkedHashSet<TimeWindow>(values);
    }

    public int size() {
        return this._startMap.size();
    }

    public boolean isEmpty() {
        return this._startMap.isEmpty();
    }

    public NavigableMap<Date, TimeWindow> getTimeWindowMap(boolean startDateKey) {
        Set<TimeWindow> timeWindowSet = this.getTimeWindowSet();
        TreeMap<Date, TimeWindow> map = new TreeMap<Date, TimeWindow>();
        for (TimeWindow tw : timeWindowSet) {
            if (startDateKey) {
                map.put(tw.getStartDate(), tw);
                continue;
            }
            map.put(tw.getEndDate(), tw);
        }
        return map;
    }

    public boolean containedInTimeWindow(Date date, boolean dateInclusive) {
        Set<TimeWindow> timeWindowSet = this.getTimeWindowSet();
        if (timeWindowSet == null || timeWindowSet.isEmpty()) {
            return false;
        }
        for (TimeWindow tw : timeWindowSet) {
            if (!tw.contains(date, dateInclusive)) continue;
            return true;
        }
        return false;
    }
}

