/*
 * Decompiled with CFR 0.152.
 */
package hec.data;

import hec.data.AbstractDataSet;
import hec.data.DataSetIllegalArgumentException;
import hec.data.ParamDouble;
import hec.data.ParamDoubleArray;
import hec.data.Parameter;
import hec.data.UnitsConversionException;
import hec.heclib.util.stringContainer;
import hec.io.DataContainer;
import hec.io.PairedDataContainer;
import hec.io.TimeSeriesContainer;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.army.usace.hec.metadata.UnitUtil;

@Deprecated
public class Units
extends AbstractDataSet
implements Serializable {
    public static final String UNDEFINED_UNITS = "undef";
    public static final int UNDEF_ID = 0;
    public static final String SI = "SI";
    public static final int SI_ID = 2;
    public static final int ENGLISH_ID = 1;
    public static final String ENGLISH = "English";
    public static final String ERROR_VALID_UNIT_SYSTEMS = "(2) SI (1) English";
    private static final Logger LOGGER = Logger.getLogger(Units.class.getName());
    private mil.army.usace.hec.metadata.Units _units;

    public Units(String units) throws DataSetIllegalArgumentException {
        this(units, false);
        if (!UNDEFINED_UNITS.equals(units) && UNDEFINED_UNITS.equals(this._units.toString())) {
            throw new DataSetIllegalArgumentException("Units name: \"" + units + "\" is not valid");
        }
    }

    public Units() {
        this._units = new mil.army.usace.hec.metadata.Units();
    }

    public Units(String units, boolean useBestMatch) {
        this._units = new mil.army.usace.hec.metadata.Units(units, useBestMatch);
    }

    public Units(Units unitsObject) {
        this._units = unitsObject._units;
    }

    public Units(mil.army.usace.hec.metadata.Units units) {
        this._units = units;
    }

    public void setUnits(String units) {
        try {
            this._units = new mil.army.usace.hec.metadata.Units(units);
        }
        catch (mil.army.usace.hec.metadata.DataSetIllegalArgumentException e) {
            LOGGER.log(Level.SEVERE, "Exception should not be thrown here, this exception handling is for backwards compatibility", e);
        }
    }

    public static String getUnitsForAlias(String alias) {
        return UnitUtil.getUnitsForAlias((String)alias);
    }

    public void setUnits(String units, boolean useBestMatch) {
        this._units = new mil.army.usace.hec.metadata.Units(units, useBestMatch);
    }

    public boolean isSetToUndefined() {
        return this._units.isSetToUndefined();
    }

    public String toString() {
        return this._units.toString();
    }

    public static String[] getAvailableUnits() {
        return UnitUtil.getAvailableUnits();
    }

    public boolean equals(Units units) {
        return Objects.equals(this._units, units._units);
    }

    public static boolean isValidUnitsSystem(int system) {
        return UnitUtil.isValidUnitsSystem((int)system);
    }

    public static int getUnitSystemForUnits(String unitStr) {
        return UnitUtil.getUnitSystemForUnits((String)unitStr);
    }

    public static double convertUnits(double x, String fromUnits, String toUnits) throws UnitsConversionException {
        try {
            return UnitUtil.convertUnits((double)x, (String)fromUnits, (String)toUnits);
        }
        catch (mil.army.usace.hec.metadata.UnitsConversionException e) {
            throw new UnitsConversionException((Exception)((Object)e));
        }
    }

    public static String getUnitsStringForUnitsId(int unitsId) {
        return UnitUtil.getUnitsStringForUnitsId((int)unitsId);
    }

    public static String getUnitsInUnitSystem(String unitsSystem, String unitsFrom) throws UnitsConversionException {
        try {
            return UnitUtil.getUnitsInUnitSystem((String)unitsSystem, (String)unitsFrom);
        }
        catch (mil.army.usace.hec.metadata.UnitsConversionException e) {
            throw new UnitsConversionException((Exception)((Object)e));
        }
    }

    public static boolean canConvertBetweenUnits(String fromUnits, String toUnits) {
        return UnitUtil.canConvertBetweenUnits((String)fromUnits, (String)toUnits);
    }

    public static List<String> getAllUnitsThatCanConvertTo(String unit, String unitSystem) {
        return UnitUtil.getAllUnitsThatCanConvertTo((String)unit, (String)unitSystem);
    }

    public static String[] getAliasesForUnits(String units) {
        return UnitUtil.getAliasesForUnits((String)units);
    }

    public static boolean isUnitsInAlias(String units, String aliasUnits) {
        return UnitUtil.isUnitsInAlias((String)units, (String)aliasUnits);
    }

    public static String getBestMatch(String units) {
        return UnitUtil.getBestMatch((String)units);
    }

    public static ParamDouble convertUnits(ParamDouble x, String fromUnits, String toUnits) throws UnitsConversionException {
        try {
            mil.army.usace.hec.data.ParamDouble paramDouble = ParamDouble.convertUnits((mil.army.usace.hec.data.ParamDouble)x, (String)fromUnits, (String)toUnits);
            return new ParamDouble(paramDouble);
        }
        catch (mil.army.usace.hec.metadata.UnitsConversionException e) {
            throw new UnitsConversionException((Exception)((Object)e));
        }
    }

    public static ParamDoubleArray convertUnits(ParamDoubleArray x, String fromUnits, String toUnits) throws UnitsConversionException {
        try {
            mil.army.usace.hec.data.ParamDoubleArray paramDouble = ParamDoubleArray.convertUnits((mil.army.usace.hec.data.ParamDoubleArray)x, (String)fromUnits, (String)toUnits);
            return new ParamDoubleArray(paramDouble);
        }
        catch (mil.army.usace.hec.metadata.UnitsConversionException e) {
            throw new UnitsConversionException((Exception)((Object)e));
        }
    }

    public static double getScalarFactor(String fromUnits, String toUnits) throws UnitsConversionException {
        try {
            return UnitUtil.getScalarFactor((String)fromUnits, (String)toUnits);
        }
        catch (mil.army.usace.hec.metadata.UnitsConversionException e) {
            throw new UnitsConversionException((Exception)((Object)e));
        }
    }

    public static double convertUnits(double x, int paramID, int fromUnitSystem, int toUnitSystem) throws UnitsConversionException {
        try {
            return UnitUtil.convertUnits((double)x, (int)paramID, (int)fromUnitSystem, (int)toUnitSystem);
        }
        catch (mil.army.usace.hec.metadata.UnitsConversionException e) {
            throw new UnitsConversionException((Exception)((Object)e));
        }
    }

    public static void convertUnits(double[] x, int paramID, int fromUnitSystem, int toUnitSystem) throws UnitsConversionException {
        try {
            UnitUtil.convertUnits((double[])x, (int)paramID, (int)fromUnitSystem, (int)toUnitSystem);
        }
        catch (mil.army.usace.hec.metadata.UnitsConversionException e) {
            throw new UnitsConversionException((Exception)((Object)e));
        }
    }

    public static void convertUnits(double[] x, String fromUnits, String toUnits) throws UnitsConversionException {
        try {
            UnitUtil.convertUnits((double[])x, (String)fromUnits, (String)toUnits);
        }
        catch (mil.army.usace.hec.metadata.UnitsConversionException e) {
            throw new UnitsConversionException((Exception)((Object)e));
        }
    }

    public static double getStorageToFlowConversion(String storageUnits, String flowUnits) throws UnitsConversionException {
        try {
            return UnitUtil.getStorageToFlowConversion((String)storageUnits, (String)flowUnits);
        }
        catch (mil.army.usace.hec.metadata.UnitsConversionException e) {
            throw new UnitsConversionException((Exception)((Object)e));
        }
    }

    public static int convertUnits(TimeSeriesContainer container, int toUnitSyst) {
        if (container.values == null) {
            return -1;
        }
        int unitSystem = Units.getUnitSystemForUnits(container.units);
        if (unitSystem == 0) {
            return -1;
        }
        if (unitSystem == toUnitSyst) {
            return 0;
        }
        String toUnits = null;
        try {
            Parameter parameter = new Parameter(container.parameter);
            toUnits = parameter.getUnitsStringForSystem(toUnitSyst);
        }
        catch (DataSetIllegalArgumentException ex) {
            Logger.getLogger(Units.class.getName()).log(Level.WARNING, "No parameter found for TimeSeriesContainer {0}", container.fullName);
            toUnits = null;
        }
        try {
            if (toUnits == null) {
                toUnits = Units.getUnitsInUnitSystem(Units.getUnitsStringForUnitsId(toUnitSyst), container.units);
            }
        }
        catch (UnitsConversionException e) {
            Logger.getLogger(Units.class.getName()).log(Level.WARNING, "No corresponding unit found for {0} in unit system {1} for {2}", new String[]{container.units, toUnitSyst == 1 ? ENGLISH : SI, container.getFullName()});
            return -1;
        }
        try {
            Units.convertUnits(container.values, container.units, toUnits);
        }
        catch (UnitsConversionException e) {
            Logger.getLogger(Units.class.getName()).log(Level.WARNING, "Unable to convert from unit {0} to unit {1} for {2}", new String[]{container.units, toUnits, container.getFullName()});
            return -1;
        }
        container.units = toUnits;
        return 0;
    }

    public static int convertUnits(PairedDataContainer container, int toUnitSyst) {
        Parameter parameter;
        String toUnits;
        if (container.xOrdinates == null || container.yOrdinates == null) {
            return -1;
        }
        int unitSystem = Units.getUnitSystemForUnits(container.xunits);
        if (unitSystem == 0) {
            return -1;
        }
        if (unitSystem != toUnitSyst) {
            toUnits = null;
            try {
                parameter = new Parameter(container.xparameter);
                toUnits = parameter.getUnitsStringForSystem(toUnitSyst);
            }
            catch (DataSetIllegalArgumentException ex) {
                Logger.getLogger(Units.class.getName()).log(Level.WARNING, "No X parameter found for PairedDataContainer {0}", container.fullName);
                toUnits = null;
            }
            try {
                if (toUnits == null) {
                    toUnits = Units.getUnitsInUnitSystem(Units.getUnitsStringForUnitsId(toUnitSyst), container.xunits);
                }
                Units.convertUnits(container.xOrdinates, container.xunits, toUnits);
            }
            catch (UnitsConversionException e) {
                return -1;
            }
            container.xunits = toUnits;
        }
        if ((unitSystem = Units.getUnitSystemForUnits(container.yunits)) == 0) {
            return -1;
        }
        if (unitSystem != toUnitSyst) {
            toUnits = null;
            try {
                parameter = new Parameter(container.yparameter);
                toUnits = parameter.getUnitsStringForSystem(toUnitSyst);
            }
            catch (DataSetIllegalArgumentException ex) {
                Logger.getLogger(Units.class.getName()).log(Level.WARNING, "No Y parameter found for PairedDataContainer {0}", container.fullName);
                toUnits = null;
            }
            try {
                if (toUnits == null) {
                    toUnits = Units.getUnitsInUnitSystem(Units.getUnitsStringForUnitsId(toUnitSyst), container.yunits);
                }
                for (double[] yOrdinates : container.yOrdinates) {
                    Units.convertUnits(yOrdinates, container.yunits, toUnits);
                }
            }
            catch (UnitsConversionException e) {
                return -1;
            }
            container.yunits = toUnits;
        }
        return 0;
    }

    public static int convertUnits(DataContainer container, int toUnitSyst) {
        if (container instanceof TimeSeriesContainer) {
            return Units.convertUnits((TimeSeriesContainer)container, toUnitSyst);
        }
        if (container instanceof PairedDataContainer) {
            return Units.convertUnits((PairedDataContainer)container, toUnitSyst);
        }
        return -5;
    }

    public static void convertUnits(List<Object> containers, int toUnitSyst) {
        for (Object obj : containers) {
            if (!(obj instanceof DataContainer)) continue;
            Units.convertUnits((DataContainer)obj, toUnitSyst);
        }
    }

    public static int convertUnits(double[] data, int number, int fromUnitSyst, int toUnitSyst, stringContainer units) {
        try {
            Parameter param = Parameter.getParameterForUnitsString(units.string);
            String toUnit = param == null ? Units.getUnitsInUnitSystem(Units.getUnitsStringForUnitsId(toUnitSyst), units.string) : param.getUnitsStringForSystem(toUnitSyst);
            Units.convertUnits(data, units.string, toUnit);
            units.string = toUnit;
            return 0;
        }
        catch (UnitsConversionException e) {
            return -1;
        }
    }

    public mil.army.usace.hec.metadata.Units getUnitsMetaData() {
        return this._units;
    }
}

