/*
 * Decompiled with CFR 0.152.
 */
package hec.data;

import hec.data.DataSetException;
import hec.data.Units;

public class UnitsConversionException
extends DataSetException {
    private static final long serialVersionUID = 1298903841566174669L;
    private String _fromSys;
    private String _fromUnit;
    private String _toSys;
    private String _toUnit;
    private final boolean _usePassedInMessage;

    public UnitsConversionException(Units from, Units to) {
        this._fromUnit = from.toString();
        this._toUnit = to.toString();
        this._usePassedInMessage = false;
    }

    public UnitsConversionException(String fromUnit, String toUnit) {
        this._fromUnit = fromUnit;
        this._toUnit = toUnit;
        this._usePassedInMessage = false;
    }

    public UnitsConversionException(String fromSys, String fromUnit, String toSys, String toUnit) {
        this._fromSys = fromSys;
        this._fromUnit = fromUnit;
        this._toSys = toSys;
        this._toUnit = toUnit;
        this._usePassedInMessage = false;
    }

    public UnitsConversionException(String message) {
        super(message);
        this._usePassedInMessage = true;
    }

    public UnitsConversionException(Exception exception) {
        super(exception);
        this._usePassedInMessage = true;
    }

    @Override
    public String getMessage() {
        if (this._usePassedInMessage) {
            return super.getMessage();
        }
        StringBuffer sb = new StringBuffer();
        sb.append("Unit conversion is invalid. Unit: ");
        if (this._fromSys != null) {
            sb.append(this._fromSys);
            sb.append(".");
        }
        sb.append(this._fromUnit.toString());
        sb.append(" cannot be converted to Unit: ");
        if (this._toSys != null) {
            sb.append(this._toSys);
            sb.append(".");
        }
        sb.append(this._toUnit.toString());
        return sb.toString();
    }
}

