/*
 * Decompiled with CFR 0.152.
 */
package hec.data;

import hec.data.RoundingException;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UsgsRounder {
    private static final int SIGNIFICANT_DIGITS_LEN = 9;
    private static final int ROUNDING_SPEC_LEN = 10;
    private int[] _significantDigits = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
    private int _maxDecimalPlaces = 0;
    private volatile ThreadLocal<DecimalFormat> _formatter = ThreadLocal.withInitial(this::createDecimalFormat);

    public UsgsRounder(CharSequence roundingSpec) throws RoundingException {
        this.setRoundingSpec(roundingSpec);
    }

    public static UsgsRounder getDefault() {
        String defaultString = "2222222222";
        try {
            return new UsgsRounder(defaultString);
        }
        catch (RoundingException e) {
            Logger.getLogger(UsgsRounder.class.getName()).log(Level.SEVERE, "Unable to create default USGS Rounder with string {0}", defaultString);
            return null;
        }
    }

    public double round(double value) throws RoundingException {
        return this.round(value, true);
    }

    public double round(double value, boolean roundHalfEven) throws RoundingException {
        double result = -3.4028234663852886E38;
        try {
            if (value == 0.0 || Double.isNaN(value) || Double.isInfinite(value)) {
                result = value;
            } else {
                double factor;
                int magnitude = (int)Math.floor(Math.log10(Math.abs(value)));
                int index = Math.min(5, Math.max(-3, magnitude)) + 3;
                int digits = this._significantDigits[index];
                if (digits + magnitude < digits) {
                    digits = Math.min(this._maxDecimalPlaces, digits + magnitude + 1);
                }
                int sign = (value /= (factor = Math.pow(10.0, magnitude - digits + 1))) > 0.0 ? 1 : (value < 0.0 ? -1 : 0);
                long integer = (long)value;
                double fraction = Math.abs(value - (double)integer);
                if (Math.abs(fraction - 0.5) < 1.0E-8) {
                    if (!roundHalfEven || integer % 2L != 0L) {
                        integer += (long)sign;
                    }
                } else {
                    integer = (long)(value + 0.5 * (double)sign);
                }
                result = (double)integer * factor;
            }
        }
        catch (Throwable t) {
            throw new RoundingException(t);
        }
        return result;
    }

    public double[] round(double[] values) throws RoundingException {
        return this.round(values, true);
    }

    public double[] round(double[] values, boolean roundHalfEven) throws RoundingException {
        double[] rounded = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            rounded[i] = this.round(values[i], roundHalfEven);
        }
        return rounded;
    }

    public String format(double value) throws RoundingException {
        return this._formatter.get().format(this.round(value));
    }

    public String[] format(double[] values) throws RoundingException {
        String[] formatted = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            formatted[i] = this.format(values[i]);
        }
        return formatted;
    }

    public int[] getSignificantDigits() {
        return Arrays.copyOf(this._significantDigits, 9);
    }

    public void setSignificantDigits(int[] significantDigits) throws RoundingException {
        boolean valid = significantDigits.length == 9;
        for (int i = 0; i < 9 && valid; ++i) {
            valid = significantDigits[i] >= 0 && significantDigits[i] <= 9;
        }
        if (!valid) {
            throw new RoundingException("Significant digits array is invalid.");
        }
        this._significantDigits = Arrays.copyOf(significantDigits, 9);
    }

    public int getMaxDecimalPlaces() {
        return this._maxDecimalPlaces;
    }

    public void setMaxDecimalPlaces(int maxDecimalPlaces) throws RoundingException {
        if (maxDecimalPlaces < 0 || maxDecimalPlaces > 9) {
            throw new RoundingException("Maximum decimal places must be in range 0..9");
        }
        this._maxDecimalPlaces = maxDecimalPlaces;
        this._formatter = ThreadLocal.withInitial(this::createDecimalFormat);
    }

    public String getRoundingSpec() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 9; ++i) {
            sb.append(this._significantDigits[i]);
        }
        sb.append(this._maxDecimalPlaces);
        return sb.toString();
    }

    public void setRoundingSpec(CharSequence roundingSpec) throws RoundingException {
        boolean valid = roundingSpec.length() == 10;
        for (int i = 0; i < 10 && valid; ++i) {
            char c2 = roundingSpec.charAt(i);
            valid = Character.isDigit(c2);
            if (!valid) continue;
            if (i < 9) {
                this._significantDigits[i] = Character.getNumericValue(c2);
                continue;
            }
            this._maxDecimalPlaces = Character.getNumericValue(c2);
        }
        if (!valid) {
            throw new RoundingException("Invalid rounding specification: " + roundingSpec);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 9; ++i) {
            sb.delete(0, sb.length()).append("0");
            int possibleDecimalPlaces = Math.max(Math.min(this._significantDigits[i] - i + 2, this._maxDecimalPlaces), 0) - 1;
            if (possibleDecimalPlaces <= 0) continue;
            sb.append(".");
            for (int j = 0; j < possibleDecimalPlaces; ++j) {
                sb.append("0");
            }
        }
        this._formatter = ThreadLocal.withInitial(this::createDecimalFormat);
    }

    private DecimalFormat createDecimalFormat() {
        Object format = "0";
        if (this._maxDecimalPlaces > 0) {
            format = (String)format + ".";
            for (int i = 0; i < this._maxDecimalPlaces; ++i) {
                format = (String)format + "0";
            }
        }
        return new DecimalFormat((String)format);
    }

    public String toString() {
        return this.getRoundingSpec();
    }
}

