/*
 * Decompiled with CFR 0.152.
 */
package hec.data.characteristic;

import hec.data.AbstractJDomDataObject;
import hec.data.IProperty;
import hec.data.JDomDataObjectFactory;
import hec.data.ParamDouble;
import hec.data.characteristic.ICharacteristic;
import hec.util.BaseXMLUtilities;
import org.jdom.Element;
import rma.util.RMAIO;

public class JDomCharacteristic
extends AbstractJDomDataObject
implements ICharacteristic,
IProperty {
    String _value;

    public JDomCharacteristic() {
    }

    public JDomCharacteristic(String id, String value) {
        this.setName(id);
        this._value = value;
    }

    public JDomCharacteristic(Element element) {
        if (element != null) {
            String id = element.getAttributeValue("id");
            this.setName(id);
            this._value = element.getChildText("value");
        }
    }

    public JDomCharacteristic(ICharacteristic characteristic) {
        this(JDomDataObjectFactory.getRootElement(characteristic.toXmlString()));
    }

    @Override
    public void buildElement(Element element) {
        if (element == null) {
            return;
        }
        if (this.getName() != null) {
            element.setAttribute("id", this.getName());
        } else {
            element.removeAttribute("id");
        }
        Element child = BaseXMLUtilities.getOrCreateChild(element, "value");
        if (this._value != null) {
            child.setText(this._value);
        } else {
            child.removeContent();
        }
    }

    @Override
    public String getCharacteristicId() {
        return this.getName();
    }

    @Override
    public void setCharacteristicId(String id) {
        this.setName(id);
    }

    @Override
    public String getPropertyId() {
        return this.getName();
    }

    public void setPropertyId(String s) {
        this.setName(s);
    }

    @Override
    public String getPropertyValue() {
        return this._value;
    }

    public void setPropertyValue(String s) {
        this._value = s;
    }

    @Override
    public String getPropertyComment() {
        return this.getDescription();
    }

    public void setPropertyComment(String s) {
        this.setDescription(s);
    }

    @Override
    public Boolean getBooleanValue() {
        if (this._value == null) {
            return null;
        }
        return RMAIO.parseBoolean(this._value, false);
    }

    @Override
    public void setBooleanValue(Boolean b) {
        this._value = b == null ? null : b.toString();
    }

    @Override
    public String getStringValue() {
        return this._value;
    }

    @Override
    public void setStringValue(String s) {
        this._value = s;
    }

    @Override
    public void getParamValue(ParamDouble pd) {
        if (this._value == null) {
            pd.setValue(Double.NEGATIVE_INFINITY);
        }
        pd.setValue(this._value);
    }

    @Override
    public void setParamValue(ParamDouble pd) {
        this._value = pd == null ? null : pd.toString();
        if (this._value != null && this._value.isEmpty()) {
            this._value = null;
        }
    }
}

